package dev.felnull.imp.client.gui.screen;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.components.PowerButton;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.music.IMPMusicTrackerFactory;
import dev.felnull.imp.client.music.MusicEngine;
import dev.felnull.imp.client.music.MusicEntry;
import dev.felnull.imp.inventory.MusicManagerMenu;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.music.tracker.IMPMusicTrackers;
import dev.felnull.otyacraftengine.util.OENbtUtils;
import org.jetbrains.annotations.Nullable;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1661;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class MusicManagerScreen extends IMPBaseContainerScreen<MusicManagerMenu> {
    private static final class_310 mc = class_310.method_1551();
    private static final class_2960 BG_TEXTURE = new class_2960(IamMusicPlayer.MODID, "textures/gui/container/music_manager/music_manager_base.png");
    private final Map<MusicManagerBlockEntity.MonitorType, MusicManagerMonitor> monitors = new HashMap<>();
    private final UUID musicPlayerId = UUID.randomUUID();
    public boolean lastSearch;
    protected MusicManagerMonitor monitor;
    public byte[] musicFileImage;

    public MusicManagerScreen(MusicManagerMenu abstractContainerMenu, class_1661 inventory, class_2561 component) {
        super(abstractContainerMenu, inventory, component);
        this.field_2792 = 386;
        this.field_2779 = 227;
        this.bgTextureWidth = 512;
        this.bgTextureHeight = 512;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063(new PowerButton(this, field_2776 + 368, field_2800 + 4, 12, 12, 386, 0, BG_TEXTURE, bgTextureWidth, bgTextureHeight));
        changeScreenMonitor(getBEMonitorType());
        insMonitor(getBEMonitorType());
    }

    public void insMonitor(MusicManagerBlockEntity.MonitorType type) {
        if (monitor != null && monitor.getType() != type)
            stopMusic();

        var tag = new class_2487();
        tag.method_10582("type", type.getName());
        instruction("set_monitor", tag);
    }

    public void insAddPlayList(UUID playListId) {
        var tag = new class_2487();
        tag.method_25927("playlist", playListId);
        instruction("add_playlist", tag);
    }

    private void changeScreenMonitor(MusicManagerBlockEntity.MonitorType type) {
        if (monitor != null) {
            if (monitor.getType() != MusicManagerBlockEntity.MonitorType.UPLOAD_MUSIC || type != MusicManagerBlockEntity.MonitorType.ADD_MUSIC)
                musicFileImage = null;
            monitor.renderables.forEach(this::method_37066);
            monitor.depose();
        }

        if (!monitors.containsKey(type))
            monitors.put(type, MusicManagerMonitor.createdMusicMonitor(type, this));

        monitor = monitors.get(type);
        monitor.init(field_2776, field_2800);
        monitor.renderables.forEach(this::method_37063);
    }

    private MusicManagerBlockEntity.MonitorType getBEMonitorType() {
        if (getBlockEntity() instanceof MusicManagerBlockEntity musicManagerBlockEntity)
            return musicManagerBlockEntity.getMonitor(mc.field_1724);
        return MusicManagerBlockEntity.MonitorType.OFF;
    }

    public void insImportPlayListMusicCount(int count) {
        var tag = new class_2487();
        tag.method_10569("count", count);
        instruction("set_import_playlist_music_count", tag);
    }

    public void insImportPlayListAuthor(String author) {
        var tag = new class_2487();
        tag.method_10582("author", author);
        instruction("set_import_playlist_author", tag);
    }

    public void insImportPlayListName(String name) {
        var tag = new class_2487();
        tag.method_10582("name", name);
        instruction("set_import_playlist_name", tag);
    }

    public void insImportIdentifier(String identifier) {
        var tag = new class_2487();
        tag.method_10582("id", identifier);
        instruction("set_import_identifier", tag);
    }

    public void insImageURL(String url) {
        var tag = new class_2487();
        tag.method_10582("url", url);
        instruction("set_image_url", tag);
    }

    public void insImage(ImageInfo image) {
        var tag = new class_2487();
        tag.method_10566("image", image.createSavedTag());
        instruction("set_image", tag);
    }

    public void insCreateName(String name) {
        var tag = new class_2487();
        tag.method_10582("name", name);
        instruction("set_create_name", tag);
    }

    public void insPublishing(String publishing) {
        var tag = new class_2487();
        tag.method_10582("publishing", publishing);
        instruction("set_publishing", tag);
    }

    public void insInitialAuthority(String initialAuthority) {
        var tag = new class_2487();
        tag.method_10582("initial_authority", initialAuthority);
        instruction("set_initial_authority", tag);
    }

    public void insInvitePlayerName(String name) {
        var tag = new class_2487();
        tag.method_10582("name", name);
        instruction("set_invite_player_name", tag);
    }

    public void insInvitePlayers(List<UUID> players) {
        var tag = new class_2487();
        OENbtUtils.writeUUIDList(tag, "players", players);
        instruction("set_invite_players", tag);
    }

    public void insSelectedPlayList(UUID selectedPlayList) {
        var tag = new class_2487();
        if (selectedPlayList != null)
            tag.method_25927("playlist", selectedPlayList);
        instruction("set_selected_playlist", tag);
    }

    public void insSelectedMusic(@Nullable UUID selectedMusic) {
        var tag = new class_2487();
        if (selectedMusic != null)
            tag.method_25927("music", selectedMusic);
        instruction("set_selected_music", tag);
    }

    public void insSelectedPlayer(@Nullable UUID selectedPlayer) {
        var tag = new class_2487();
        if (selectedPlayer != null)
            tag.method_25927("player", selectedPlayer);
        instruction("set_selected_player", tag);
    }

    public void insMusicLoaderType(String name) {
        var tag = new class_2487();
        tag.method_10582("name", name);
        instruction("set_music_loader_type", tag);
    }

    public void insMusicSourceName(String name) {
        var tag = new class_2487();
        tag.method_10582("name", name);
        instruction("set_music_source_name", tag);
    }

    public void insMusicSource(MusicSource source) {
        if (source == null)
            source = MusicSource.EMPTY;
        var tag = new class_2487();
        tag.method_10566("MusicSource", source.createSavedTag());
        instruction("set_music_source", tag);
    }

    public void insMusicSearchName(String name) {
        var tag = new class_2487();
        tag.method_10582("name", name);
        instruction("set_music_search_name", tag);
    }

    public void insMusicAuthor(String author) {
        var tag = new class_2487();
        tag.method_10582("author", author);
        instruction("set_music_author", tag);
    }

    @Override
    public void onInstructionReturn(String name, class_2487 data) {
        super.onInstructionReturn(name, data);
        if ("add_playlist".equals(name)) {
            if (data.method_10545("playlist")) {
                insSelectedPlayList(data.method_25926("playlist"));
            }
        } else if ("set_selected_playlist".equals(name)) {
            if (data.method_10545("playlist")) {
                monitor.onUpdateSelectedPlayList(data.method_25926("playlist"));
            } else {
                monitor.onUpdateSelectedPlayList(null);
            }
        }
    }

    @Override
    protected class_2960 getBackGrandTexture() {
        return BG_TEXTURE;
    }

    @Override
    protected void method_2388(class_332 guiGraphics, int i, int j) {
      guiGraphics.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 4210752,false);
        //this.font.draw(poseStack, this.title, (float) this.titleLabelX, (float) this.titleLabelY, 4210752);
    }

    @Override
    protected void method_2389(class_332 guiGraphics, float f, int i, int j) {
        super.method_2389(guiGraphics, f, i, j);
        if (monitor != null)
            monitor.render(guiGraphics, f, i, j);
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        if (monitor != null) {
            if (getBEMonitorType() != monitor.getType())
                changeScreenMonitor(getBEMonitorType());
            monitor.tick();
        }
    }

    @Override
    public void method_25419() {
        super.method_25419();
        if (monitor != null)
            monitor.depose();

        stopMusic();
    }

    @Override
    public void method_29638(List<Path> list) {
        if (monitor != null)
            monitor.onFilesDrop(list);
    }

    public void playMusic(MusicSource source, long postion) {
        stopMusic();
        getMusicEngine().loadAndPlay(musicPlayerId, source, postion, false);
        getMusicEngine().addSpeaker(musicPlayerId, musicPlayerId, IMPMusicTrackerFactory.linked(IMPMusicTrackers.createPlayerTracker(mc.field_1724, 1, 10)));

        //getMusicEngine().loadAddMusicPlayer(musicPlayerId, new MusicPlaybackInfo(MusicRingManager.PLAYER_TRACKER, MusicRingManager.createPlayerTracker(mc.player), 1, 10), source, postion, (result, time, player, retry) -> getMusicEngine().playMusicPlayer(musicPlayerId, 0));
    }

    public void stopMusic() {
        getMusicEngine().stop(musicPlayerId);
    }

    public boolean isMusicPlaying() {
        return getMusicEngine().isPlaying(musicPlayerId);
    }

    public boolean isMusicLoading() {
        return getMusicEngine().isLoading(musicPlayerId);
    }

    private MusicEngine getMusicEngine() {
        return MusicEngine.getInstance();
    }

    public MusicEntry getMusicPlayer() {
        return getMusicEngine().getMusicEntry(musicPlayerId);
    }
}
