package dev.felnull.imp.client.handler;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.client.gui.overlay.MusicLinesOverlay;
import dev.felnull.imp.client.renderer.item.hand.BoomboxHandRenderer;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.otyacraftengine.client.event.MoreRenderEvent;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_811;
import net.minecraft.class_989;

public class RenderHandler {
    private static final MusicLinesOverlay MUSIC_LINES_OVERLAY = new MusicLinesOverlay();

    public static void init() {
        MoreRenderEvent.RENDER_ITEM_IN_HAND.register(RenderHandler::onRenderItemInHand);
        MoreRenderEvent.RENDER_ARM_WITH_ITEM.register(RenderHandler::onRenderArmWithItem);
        ClientGuiEvent.RENDER_HUD.register(RenderHandler::renderHud);
    }

    private static void renderHud(class_332 guiGraphics, float tickDelta) {
        if (IamMusicPlayer.getConfig().showMusicLines)
            MUSIC_LINES_OVERLAY.render(guiGraphics, tickDelta);
    }

    private static EventResult onRenderItemInHand(class_4587 poseStack, class_4597 multiBufferSource, class_1268 hand, int packedLight, float partialTicks, float interpolatedPitch, float swingProgress, float equipProgress, class_1799 stack) {
        if (stack.method_31574(IMPBlocks.BOOMBOX.get().method_8389())) {
            BoomboxHandRenderer.render(poseStack, multiBufferSource, hand, packedLight, partialTicks, interpolatedPitch, swingProgress, equipProgress, stack);
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult onRenderArmWithItem(class_989<? extends class_1309, ? extends class_583<?>> itemInHandLayer, class_1309 livingEntity, class_1799 itemStack, class_811 displayContext, class_1306 humanoidArm, class_4587 poseStack, class_4597 multiBufferSource, int i) {
        if (itemStack.method_31574(IMPBlocks.BOOMBOX.get().method_8389()) && BoomboxItem.getTransferProgress(itemStack) >= 1f) {
            BoomboxHandRenderer.renderArmWithItem(itemInHandLayer, livingEntity, itemStack, displayContext, humanoidArm, poseStack, multiBufferSource, i);
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }
}
