package dev.felnull.imp.client.renderer.blockentity;

import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.block.BoomboxData.Buttons;
import dev.felnull.imp.block.MusicManagerBlock;
import dev.felnull.imp.blockentity.BoomboxBlockEntity;
import dev.felnull.imp.client.gui.screen.monitor.boombox.BoomboxMonitor;
import dev.felnull.imp.client.model.IMPModels;
import dev.felnull.imp.client.renderer.item.AntennaItemRenderer;
import dev.felnull.imp.item.IMPItems;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.otyacraftengine.client.renderer.blockentity.AbstractBlockEntityRenderer;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_811;

public class BoomboxBlockEntityRenderer extends AbstractBlockEntityRenderer<BoomboxBlockEntity> {
    private static final Map<BoomboxData.MonitorType, BoomboxMonitor> monitors = new HashMap<>();
    private static final class_310 mc = class_310.method_1551();

    protected BoomboxBlockEntityRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public void render(BoomboxBlockEntity blockEntity, float f, class_4587 poseStack, class_4597 multiBufferSource, int i, int j) {
        var state = blockEntity.method_11010();
        var data = blockEntity.getBoomboxData();
        renderBoombox(poseStack, multiBufferSource, state.method_11654(MusicManagerBlock.FACING), i, j, f, data, data.getHandleRaisedProgress(f) / (float) data.getHandleRaisedMax(), multiBufferSource.getBuffer(class_4722.method_24074()));
    }

    public static void renderBoombox(class_4587 poseStack, class_4597 multiBufferSource, class_2350 direction, int i, int j, float f, BoomboxData data, float handleRaised, class_4588 vertexConsumer) {
        float lidOpen = data.getLidOpenProgress(f) / (float) data.getLidOpenProgressMax();
        var buttons = data.getButtons();
        var cassetteTape = data.getCassetteTape();
        var antenna = data.getAntenna();
        float parabolicAntennaRoted = data.getParabolicAntennaProgress(f);
        float antennaPar = data.getAntennaProgress(f) / 30f;
        boolean changeCassetteTape = data.isChangeCassetteTape();
        var oldCassetteTape = data.getOldCassetteTape();

        var handleM = IMPModels.BOOMBOX_HANDLE.get();
        var lidM = IMPModels.BOOMBOX_LID.get();
        var buttonsM = IMPModels.BOOMBOX_BUTTONS.get();

        poseStack.method_22903();
        OERenderUtils.poseRotateDirection(poseStack, direction, 1);

        if (lidOpen != 0) {
            poseStack.method_22903();
            OERenderUtils.poseTrans16(poseStack, 7.7, 3.225, 6);
            OERenderUtils.poseScaleAll(poseStack, 0.72f);
            mc.method_1480().method_23178(changeCassetteTape ? oldCassetteTape : cassetteTape, class_811.field_4319, i, j, poseStack, multiBufferSource, mc.field_1687, 0);
            poseStack.method_22909();
        }

        renderAntenna(poseStack, multiBufferSource, i, j, antenna, parabolicAntennaRoted, antennaPar);

        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, 1, 8, 6);
        OERenderUtils.poseTrans16(poseStack, 0.5, 0.5, 0.5);
        OERenderUtils.poseRotateX(poseStack, (1f - handleRaised) * 90f);
        OERenderUtils.poseTrans16(poseStack, -0.5, -0.5, -0.5);
        OERenderUtils.renderModel(poseStack, vertexConsumer, handleM, i, j);
        poseStack.method_22909();

        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, 5.5, 1.5, 5);
        OERenderUtils.poseTrans16(poseStack, 0.125, 0.125, 0.125);
        OERenderUtils.poseRotateX(poseStack, lidOpen * -40f);
        OERenderUtils.poseTrans16(poseStack, -0.125, -0.125, -0.125);
        OERenderUtils.renderModel(poseStack, vertexConsumer, lidM, i, j);
        poseStack.method_22909();

        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, 12.25, 9, 5.75);
        OERenderUtils.renderModel(poseStack, vertexConsumer, buttonsM, i, j);
        poseStack.method_22909();
        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, 11.25, 9 - (buttons.radio() ? 0.5 : 0), 5.75);
        OERenderUtils.renderModel(poseStack, vertexConsumer, buttonsM, i, j);
        poseStack.method_22909();
        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, 10.25, 9 - (buttons.start() ? 0.5 : 0), 5.75);
        OERenderUtils.renderModel(poseStack, vertexConsumer, buttonsM, i, j);
        poseStack.method_22909();
        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, 9.25, 9 - (buttons.pause() ? 0.5 : 0), 5.75);
        OERenderUtils.renderModel(poseStack, vertexConsumer, buttonsM, i, j);
        poseStack.method_22909();
        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, 8.25, 9, 5.75);
        OERenderUtils.renderModel(poseStack, vertexConsumer, buttonsM, i, j);
        poseStack.method_22909();
        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, 7.25, 9 - (buttons.loop() ? 0.5 : 0), 5.75);
        OERenderUtils.renderModel(poseStack, vertexConsumer, buttonsM, i, j);
        poseStack.method_22909();

        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, 5.55, 9, 5.75);
        OERenderUtils.renderModel(poseStack, vertexConsumer, buttonsM, i, j);
        poseStack.method_22909();
        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, 4.55, 9, 5.75);
        OERenderUtils.renderModel(poseStack, vertexConsumer, buttonsM, i, j);
        poseStack.method_22909();
        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, 3.55, 9 - (buttons.volMute() ? 0.5 : 0), 5.75);
        OERenderUtils.renderModel(poseStack, vertexConsumer, buttonsM, i, j);
        poseStack.method_22909();
        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, 2.55, 9 - (buttons.volMax() ? 0.5 : 0), 5.75);
        OERenderUtils.renderModel(poseStack, vertexConsumer, buttonsM, i, j);
        poseStack.method_22909();


        poseStack.method_22903();
        poseStack.method_46416(1, 0, 0);
        OERenderUtils.poseRotateY(poseStack, 180);
        OERenderUtils.poseTrans16(poseStack, 0.6, 5.6, -4.9);
        var monitor = getMonitor(data.getMonitorType());
        float px16 = 1f / 16f;
        monitor.renderAppearance(poseStack, multiBufferSource, class_765.field_32767, j, f, px16 * 14.8f, px16 * 2.8f, data);
        poseStack.method_22909();

        poseStack.method_22909();
    }

    private static void renderAntenna(class_4587 poseStack, class_4597 multiBufferSource, int i, int j, class_1799 antenna, float roted, float antennaPar) {
        if (!IMPItemUtil.isAntenna(antenna)) return;
        if (antenna.method_31574(IMPItems.RADIO_ANTENNA.get())) {
            poseStack.method_22903();
            float ws = 0.025f / 2f;
            OERenderUtils.poseTrans16(poseStack, 0.25, 9, 10.25);
            poseStack.method_46416(ws, ws, ws);
            OERenderUtils.poseRotateZ(poseStack, 90);
            poseStack.method_46416(-ws, -ws, -ws);
            OERenderUtils.poseScaleAll(poseStack, 0.75f);
            AntennaItemRenderer.renderAntenna(antenna, poseStack, multiBufferSource, i, j, (-0.5f + Math.max(antennaPar, 0.5f)) * 2f, -90 + 30 * Math.min(antennaPar, 0.5f) * 2f);
            poseStack.method_22909();
        } else {
            poseStack.method_22903();
            OERenderUtils.poseTrans16(poseStack, 0.85, 8, 10.1);
            OERenderUtils.poseScaleAll(poseStack, 0.72f);
            OERenderUtils.poseRotateX(poseStack, 35);
            OERenderUtils.poseRotateZ(poseStack, 35);
            OERenderUtils.poseRotateY(poseStack, roted);
            OERenderUtils.poseTrans16(poseStack, 0, 1.3, 0);
            OERenderUtils.poseRotateX(poseStack, -30 + Math.abs(-0.5f + (roted % 120 / 120f)) * 2f * 60);
            OERenderUtils.poseTrans16(poseStack, 0, -1.3, 0);
            mc.method_1480().method_23178(antenna, class_811.field_4318, i, j, poseStack, multiBufferSource, mc.field_1687, 0);
            poseStack.method_22909();
        }
    }

    private static BoomboxMonitor getMonitor(BoomboxData.MonitorType type) {
        if (monitors.containsKey(type)) return monitors.get(type);

        var monitor = BoomboxMonitor.createdBoomBoxMonitor(type, null);
        monitors.put(type, monitor);
        return monitor;
    }
}
