package dev.felnull.imp.client.renderer.item;

import dev.felnull.imp.client.gui.components.MyPlayListFixedListWidget;
import dev.felnull.imp.client.model.IMPModels;
import dev.felnull.imp.client.renderer.PlayImageRenderer;
import dev.felnull.imp.item.CassetteTapeItem;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.otyacraftengine.client.model.ModelHolder;
import dev.felnull.otyacraftengine.client.renderer.item.BEWLItemRenderer;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import java.util.Date;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_811;
import net.minecraft.class_918;

public class CassetteTapeItemRenderer implements BEWLItemRenderer {
    private static final class_310 mc = class_310.method_1551();

    @Override
    public void render(class_1799 itemStack, class_811 displayContext, class_4587 poseStack, class_4597 multiBufferSource, float v, int i, int i1) {
        float par = CassetteTapeItem.getTapePercentage(itemStack);
        class_4588 ivb = class_918.method_29711(multiBufferSource, class_4722.method_24074(), true, itemStack.method_7958());//multiBufferSource.getBuffer(Sheets.cutoutBlockSheet());

        renderBase(poseStack, ivb, multiBufferSource, itemStack, i, i1);

        class_1087 glassModel = IMPModels.CASSETTE_TAPE_GLASS_MODEL.get();
        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, 3, 0, 2.25d);
        OERenderUtils.renderModel(poseStack, ivb, glassModel, i, i1);
        poseStack.method_22909();

        renderTapeRoll(poseStack, par * 10f, 1 - par, ivb, 7.25d, -0.01f, 2.5d, i, i1);
        renderTapeRoll(poseStack, par * 10f, par, ivb, 1.75d, -0.01f, 2.5d, i, i1);

        class_1087 tapeModel = IMPModels.CASSETTE_TAPE_MODEL.get();
        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, 0.975d, 0.25d, 0.275d);
        OERenderUtils.renderModel(poseStack, ivb, tapeModel, i, i1);
        poseStack.method_22909();

        renderTapeConecter(poseStack, 22 - 46 * par, ivb, 0.975d, 0.25d, 0.8d, i, i1);
        renderTapeConecter(poseStack, 22 - 46 * par, ivb, 9d, 0.25d, 0.8d, i, i1);

        renderMusicInfo(poseStack, ivb, multiBufferSource, itemStack, i, i1);
    }

    private static void renderMusicInfo(class_4587 poseStack, class_4588 ivb, class_4597 multiBufferSource, class_1799 stack, int i, int i1) {

        Music music = CassetteTapeItem.getMusic(stack);

        if (music == null)
            return;

        class_1087 labelModel = music.getImage().isEmpty() ? IMPModels.CASSETTE_TAPE_LABEL_NO_IMAGE_MODEL.get() : IMPModels.CASSETTE_TAPE_LABEL_MODEL.get();
        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, 3d, 1d, 4d);
        OERenderUtils.renderModel(poseStack, ivb, labelModel, i, i1);
        poseStack.method_46416(0, (1f / 16f) * 0.025f + OERenderUtils.MIN_BREADTH, 0);

        if (!music.getImage().isEmpty()) {
            float size = (1f / 16f) * 1.025f;
            float x = 2.8f;
            float y = 0.55f;
            poseStack.method_22903();
            OERenderUtils.poseRotateAll(poseStack, -90, 0, 180);
            PlayImageRenderer.getInstance().renderSprite(music.getImage(), poseStack, multiBufferSource, -(size + (1f / 16f) * x), (1f / 16f) * y, 0, size, i, i1);
            poseStack.method_22909();
        }

        poseStack.method_22903();
        OERenderUtils.poseRotateX(poseStack, 90f);
        OERenderUtils.poseRotateY(poseStack, 180);
        float x = music.getImage().isEmpty() ? 3.85f : 2.65f;
        OERenderUtils.renderTextSprite(poseStack, multiBufferSource, class_2561.method_43470(MyPlayListFixedListWidget.dateFormat.format(new Date(music.getCreateDate()))), -(1f / 16f) * 3.85f, (1f / 16f) * 0.18f, 0, 0.15f, 0, 0, i);
        class_2561 namec = class_2561.method_43470(music.getName());
        int ms = music.getImage().isEmpty() ? 120 : 80;
        String dot = "...";
        if (mc.field_1772.method_27525(namec) >= ms) {
            StringBuilder sb = new StringBuilder();
            for (char c : music.getName().toCharArray()) {
                sb.append(c);
                if (mc.field_1772.method_1727(sb.toString()) >= ms - mc.field_1772.method_1727(dot)) {
                    sb.deleteCharAt(sb.length() - 1);
                    break;
                }
            }
            sb.append(dot);
            namec = class_2561.method_43470(sb.toString());
        }
        OERenderUtils.renderTextSprite(poseStack, multiBufferSource, namec, -(1f / 16f) * x, (1f / 16f) * 1.2f, 0, 0.18f, 0, 0, i);
        class_2561 authorc = class_2561.method_43470(music.getAuthor());
        if (mc.field_1772.method_27525(authorc) >= ms) {
            StringBuilder sb = new StringBuilder();
            for (char c : music.getAuthor().toCharArray()) {
                sb.append(c);
                if (mc.field_1772.method_1727(sb.toString()) >= ms - mc.field_1772.method_1727(dot)) {
                    sb.deleteCharAt(sb.length() - 1);
                    break;
                }
            }
            sb.append(dot);
            authorc = class_2561.method_43470(sb.toString());
        }
        OERenderUtils.renderTextSprite(poseStack, multiBufferSource, authorc, -(1f / 16f) * x, (1f / 16f) * 0.575f, 0, 0.18f, 0, 0, i);
        poseStack.method_22909();

        poseStack.method_22909();
    }

    private static void renderBase(class_4587 poseStack, class_4588 ivb, class_4597 multiBufferSource, class_1799 stack, int i, int i1) {
        if (stack.method_7909() instanceof CassetteTapeItem) {
            CassetteTapeItem.BaseType type = ((CassetteTapeItem) stack.method_7909()).getType();
            ModelHolder holder = IMPModels.CASSETTE_TAPE_BASE_NORMAL_MODEL;
            int color = ((CassetteTapeItem) stack.method_7909()).method_7801(stack) ? ((CassetteTapeItem) stack.method_7909()).method_7800(stack) : 0x1a1a1a;
            if (type == CassetteTapeItem.BaseType.GLASS) {
                holder = ((CassetteTapeItem) stack.method_7909()).method_7801(stack) ? IMPModels.CASSETTE_TAPE_BASE_GLASS_COLOR_MODEL : IMPModels.CASSETTE_TAPE_BASE_GLASS_MODEL;
                ivb = class_918.method_29711(multiBufferSource, class_4722.method_24076(), true, stack.method_7958());//multiBufferSource.getBuffer(Sheets.translucentCullBlockSheet());
            }
            class_1087 bakedModel = holder.get();
            OERenderUtils.renderModel(poseStack, ivb, bakedModel, i, i1, color);
        }
    }

    private static void renderTapeConecter(class_4587 poseStack, float angle, class_4588 ivb, double x, double y, double z, int i, int i1) {
        class_1087 tapeConecterModel = IMPModels.CASSETTE_TAPE_CONECTER.get();
        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, x, y, z);
        float f = 0.025f / 2f;
        OERenderUtils.poseTrans16(poseStack, f, f, f);
        OERenderUtils.poseRotateY(poseStack, angle);
        OERenderUtils.poseTrans16(poseStack, -f, -f, -f);
        OERenderUtils.renderModel(poseStack, ivb, tapeConecterModel, i, i1);
        poseStack.method_22909();
    }

    private static void renderTapeRoll(class_4587 poseStack, float par, float roll, class_4588 ivb, double x, double y, double z, int i, int i1) {
        roll = class_3532.method_15363(roll, 0, 1);
        class_1087 tapeCoreModel = IMPModels.CASSETTE_TAPE_CORE_MODEL.get();
        class_1087 tapeCoreAroundModel = IMPModels.CASSETTE_TAPE_CORE_AROUND_MODEL.get();
        class_1087 tapeRollModel = IMPModels.CASSETTE_TAPE_ROLL_MODEL.get();

        poseStack.method_22903();
        OERenderUtils.poseTrans16(poseStack, x, y, z);
        poseStack.method_22905(1.25f, 1.05f, 1.25f);
        OERenderUtils.poseTrans16(poseStack, 0.4, 0, 0.4);
        OERenderUtils.poseRotateY(poseStack, par * 360f);
        OERenderUtils.poseTrans16(poseStack, -0.4, 0, -0.4);
        OERenderUtils.renderModel(poseStack, ivb, tapeCoreModel, i, i1);
        OERenderUtils.poseTrans16(poseStack, 0, 0.25, 0);
        OERenderUtils.renderModel(poseStack, ivb, tapeCoreAroundModel, i, i1);
        OERenderUtils.poseTrans16(poseStack, 0, 0.125f / 2f, 0);
        float rollPar = roll + 0.5f;
        for (int j = 1; j <= Math.ceil(rollPar); j++) {
            poseStack.method_22903();
            OERenderUtils.poseTrans16(poseStack, 0.4, 0, 0.4);
            float sc = Math.min(rollPar, j);
            poseStack.method_22905(sc, 1, sc);
            OERenderUtils.poseTrans16(poseStack, -0.4, 0, -0.4);
            OERenderUtils.renderModel(poseStack, ivb, tapeRollModel, i, i1);
            poseStack.method_22909();
        }

        poseStack.method_22909();
    }

}
