package dev.felnull.imp.client.renderer.item;

import dev.felnull.imp.IMPHoliday;
import dev.felnull.imp.client.model.IMPModels;
import dev.felnull.otyacraftengine.client.model.ModelHolder;
import dev.felnull.otyacraftengine.client.renderer.item.BEWLItemRenderer;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_811;
import net.minecraft.class_918;

public class ParabolicAntennaItemRenderer implements BEWLItemRenderer {
    @Override
    public void render(class_1799 itemStack, class_811 displayContext, class_4587 poseStack, class_4597 multiBufferSource, float f, int i, int i1) {
        var antenaModel = IMPModels.PARABOLIC_ANTENNA;

        if (IMPHoliday.isXmas() && IMPModels.XMAS_ANTENNA != null)
            antenaModel = IMPModels.XMAS_ANTENNA;
        else if (IMPHoliday.isAprilFool() && IMPModels.APRIL_FOOL_ANTENNA != null)
            antenaModel = IMPModels.APRIL_FOOL_ANTENNA;

        var name = itemStack.method_7964().getString();
        if (name.equalsIgnoreCase("kamesuta")) {
            antenaModel = IMPModels.KAMESUTA_ANTENNA;
        } else if (name.equalsIgnoreCase("ikisugi")) {
            antenaModel = IMPModels.IKISUGI_ANTENNA;
        } else if (name.equalsIgnoreCase("f.c.o.h") || name.equalsIgnoreCase("fcoh")) {
            antenaModel = IMPModels.FCOH_ANTENNA;
        } else if (name.equalsIgnoreCase("katyou")) {
            antenaModel = IMPModels.KATYOU_ANTENNA;
        }
        var plM = antenaModel.get();
        var vc = class_918.method_29711(multiBufferSource, class_4722.method_24073(), true, itemStack.method_7958());

        poseStack.method_22903();
        if (displayContext == class_811.field_4316) {
            if (IMPHoliday.isXmas()) {
                OERenderUtils.poseRotateX(poseStack, 180f);
                OERenderUtils.poseScaleAll(poseStack, 3f);
                poseStack.method_46416(0, 2.5f, 0);
            } else {
                long time = System.currentTimeMillis();
                OERenderUtils.poseRotateY(poseStack, (float) (time % 5000) / 5000f * 360f);
                poseStack.method_46416(0, -5, 0);
                OERenderUtils.poseRotateX(poseStack, -15f + Math.abs(-1f + ((float) (time % 3000) / 1500)) * 30);
                poseStack.method_46416(0, 5, 0);

                OERenderUtils.poseScaleAll(poseStack, 2f);
                poseStack.method_46416(0, 1.45f, 0);
            }
        }
        OERenderUtils.renderModel(poseStack, vc, plM, i, i1);

        if (IMPHoliday.isXmas()) {
            if (IMPModels.XMAS_ANTENNA_SIDE != null)
                OERenderUtils.renderModel(poseStack, vc, IMPModels.XMAS_ANTENNA_SIDE.get(), i, i1);

            if (displayContext == class_811.field_4316 && IMPModels.XMAS_ANTENNA_TAMA != null)
                OERenderUtils.renderModel(poseStack, vc, IMPModels.XMAS_ANTENNA_TAMA.get(), i, i1);
        }

        poseStack.method_22909();
    }
}
