package dev.felnull.imp.music.tracker;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.music.MusicSpeakerFixedInfo;
import dev.felnull.imp.music.MusicSpeakerInfo;
import dev.felnull.imp.music.SpatialType;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class IMPMusicTrackers {
    public static final class_2960 FIXED_TRACKER = new class_2960(IamMusicPlayer.MODID, "fixed");
    public static final class_2960 ENTITY_TRACKER = new class_2960(IamMusicPlayer.MODID, "entity");
    public static final class_2960 PLAYER_TRACKER = new class_2960(IamMusicPlayer.MODID, "player");

    public static MusicTrackerEntry createFixedTracker(class_243 position, float volume, float range, int channel, SpatialType spatialType) {
        return new MusicTrackerEntry(FIXED_TRACKER, new FixedMusicTracker(new MusicSpeakerInfo(position, volume, range, new MusicSpeakerFixedInfo(channel, spatialType))));
    }

    public static MusicTrackerEntry createFixedTracker(class_243 position, float volume, float range) {
        return new MusicTrackerEntry(FIXED_TRACKER, new FixedMusicTracker(new MusicSpeakerInfo(position, volume, range, new MusicSpeakerFixedInfo(-1, SpatialType.ENTRUST))));
    }

    public static MusicTrackerEntry createEntityTracker(class_1297 entity, float volume, float range) {
        if (entity instanceof class_1657 player) return createPlayerTracker(player, volume, range);
        return new MusicTrackerEntry(ENTITY_TRACKER, new EntityMusicTracker(entity, volume, range));
    }

    public static MusicTrackerEntry createPlayerTracker(class_1657 player, float volume, float range) {
        return new MusicTrackerEntry(PLAYER_TRACKER, new PlayerMusicTracker(player, volume, range));
    }

    public static class_2487 saveToTag(MusicTrackerEntry trackerEntry) {
        var tag = new class_2487();
        tag.method_10582("trackerId", trackerEntry.location().toString());
        tag.method_10566("tracker", trackerEntry.tracker().createSavedTag());
        return tag;
    }
}
