package dev.felnull.imp.server.music.ringer;

import dev.felnull.imp.networking.IMPPackets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class MusicRingManager {
    private static final MusicRingManager INSTANCE = new MusicRingManager();
    private final Map<class_3218, MusicRing> musicRings = new HashMap<>();

    public static MusicRingManager getInstance() {
        return INSTANCE;
    }

    public void tick(class_3218 level) {
        getMusicRing(level).tick();
    }

    public Map<class_3218, MusicRing> getMusicRingers() {
        return musicRings;
    }

    public void restartRinger(class_3218 level, UUID uuid) {
        getMusicRing(level).restart(uuid);
    }

    public void addRinger(class_3218 level, IMusicRinger ringer) {
        getMusicRing(level).addRinger(ringer);
    }

    public boolean isWaitRinger(UUID uuid, class_3218 level) {
        return getMusicRing(level).isWaitRinger(uuid);
    }

    public void onUpdate(class_3222 player, UUID uuid, UUID waitUUID, IMPPackets.MusicRingResponseStateType state) {
        getMusicRing(player.method_51469()).onUpdate(player, uuid, waitUUID, state);
    }

    public void addReadyPlayer(class_3222 player, UUID uuid, UUID waitUUID, boolean result, boolean retry, long elapsed) {
        getMusicRing(player.method_51469()).addReadyPlayer(player, uuid, waitUUID, result, retry, elapsed);
    }

    @NotNull
    public MusicRing getMusicRing(class_3218 level) {
        return musicRings.computeIfAbsent(level, MusicRing::new);
    }

    public boolean hasRinger(UUID uuid) {
        for (class_3218 serverLevel : musicRings.keySet()) {
            if (hasRinger(serverLevel, uuid))
                return true;
        }
        return false;
    }

    public boolean hasRinger(class_3218 level, UUID uuid) {
        return getMusicRing(level).hasRinger(uuid);
    }

    public IMusicRinger getRinger(UUID uuid) {
        for (Map.Entry<class_3218, MusicRing> entry : musicRings.entrySet()) {
            var mr = entry.getValue();
            var r = mr.getRingers().get(uuid);
            if (r != null)
                return r;
        }
        return null;
    }

    @Nullable
    public class_3218 getLevel(MusicRing ring) {
        for (Map.Entry<class_3218, MusicRing> entry : musicRings.entrySet()) {
            if (entry.getValue() == ring)
                return entry.getKey();
        }
        return null;
    }

    public void pause() {
        musicRings.forEach((n, m) -> m.pause());
    }

    public void resume() {
        musicRings.forEach((n, m) -> m.resume());
    }

    public void clear() {
        musicRings.forEach((n, m) -> m.depose());
        musicRings.clear();
    }
}
