/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music;

import dev.felnull.imp.client.music.LoadCompleteListener;
import dev.felnull.imp.client.music.MusicEngine;
import dev.felnull.imp.client.music.MusicEntry;
import dev.felnull.imp.music.resource.MusicSource;
import java.util.UUID;

public class MusicScheduler {
    private final UUID musicPlayerId;
    private final MusicSource source;
    private final long position;
    private boolean broken;
    private long delayStartTime = -1L;
    private MusicEntry musicEntry;
    private MusicEntry preMusicEntry;

    protected MusicScheduler(UUID musicPlayerId, MusicSource source, long position) {
        this.musicPlayerId = musicPlayerId;
        this.source = source;
        this.position = position;
    }

    protected void start(LoadCompleteListener listener) {
        this.musicEntry = new MusicEntry(this.musicPlayerId, this.source, this.position);
        this.musicEntry.loadStart(listener);
    }

    protected void delay() {
        if (this.delayStartTime >= 0L) {
            this.getEngine().getLogger().error("Already delay");
            return;
        }
        this.delayStartTime = System.currentTimeMillis();
    }

    protected boolean play() {
        if (this.delayStartTime < 0L) {
            this.musicEntry.playStart(0L);
            return true;
        }
        return false;
    }

    protected void tick() {
        if (this.broken) {
            return;
        }
        if (this.musicEntry != null && !this.musicEntry.tick()) {
            this.broken = true;
            return;
        }
        if (this.preMusicEntry != null) {
            this.preMusicEntry.tick();
        }
        long mw = this.getMaxWait();
        if (this.delayStartTime >= 0L && !this.source.isLive() && this.source.getDuration() < this.position + this.getDelay()) {
            this.broken = true;
            return;
        }
    }

    protected boolean broken() {
        return this.broken;
    }

    private long getDelay() {
        if (this.delayStartTime < 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.delayStartTime;
    }

    private long getMaxWait() {
        if (this.musicEntry == null || this.musicEntry.getMusicPlayer() == null) {
            return -1L;
        }
        return this.musicEntry.getMusicPlayer().getMaxWaitTime();
    }

    private MusicEngine getEngine() {
        return MusicEngine.getInstance();
    }
}

