/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.github.kiulian.downloader;

import dev.felnull.imp.libs.com.github.kiulian.downloader.Config;
import dev.felnull.imp.libs.com.github.kiulian.downloader.cipher.CachedCipherFactory;
import dev.felnull.imp.libs.com.github.kiulian.downloader.downloader.Downloader;
import dev.felnull.imp.libs.com.github.kiulian.downloader.downloader.DownloaderImpl;
import dev.felnull.imp.libs.com.github.kiulian.downloader.downloader.request.RequestChannelUploads;
import dev.felnull.imp.libs.com.github.kiulian.downloader.downloader.request.RequestPlaylistInfo;
import dev.felnull.imp.libs.com.github.kiulian.downloader.downloader.request.RequestSubtitlesInfo;
import dev.felnull.imp.libs.com.github.kiulian.downloader.downloader.request.RequestVideoFileDownload;
import dev.felnull.imp.libs.com.github.kiulian.downloader.downloader.request.RequestVideoInfo;
import dev.felnull.imp.libs.com.github.kiulian.downloader.downloader.request.RequestVideoStreamDownload;
import dev.felnull.imp.libs.com.github.kiulian.downloader.downloader.request.RequestWebpage;
import dev.felnull.imp.libs.com.github.kiulian.downloader.downloader.response.Response;
import dev.felnull.imp.libs.com.github.kiulian.downloader.downloader.response.ResponseImpl;
import dev.felnull.imp.libs.com.github.kiulian.downloader.extractor.ExtractorImpl;
import dev.felnull.imp.libs.com.github.kiulian.downloader.model.Utils;
import dev.felnull.imp.libs.com.github.kiulian.downloader.model.playlist.PlaylistInfo;
import dev.felnull.imp.libs.com.github.kiulian.downloader.model.subtitles.SubtitlesInfo;
import dev.felnull.imp.libs.com.github.kiulian.downloader.model.videos.VideoInfo;
import dev.felnull.imp.libs.com.github.kiulian.downloader.parser.Parser;
import dev.felnull.imp.libs.com.github.kiulian.downloader.parser.ParserImpl;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class YoutubeDownloader {
    private final Config config;
    private final Downloader downloader;
    private final Parser parser;

    public YoutubeDownloader() {
        this(Config.buildDefault());
    }

    public YoutubeDownloader(Config config) {
        this.config = config;
        this.downloader = new DownloaderImpl(config);
        this.parser = new ParserImpl(config, this.downloader, new ExtractorImpl(this.downloader), new CachedCipherFactory(this.downloader));
    }

    public YoutubeDownloader(Config config, Downloader downloader) {
        this(config, downloader, new ParserImpl(config, downloader, new ExtractorImpl(downloader), new CachedCipherFactory(downloader)));
    }

    public YoutubeDownloader(Config config, Downloader downloader, Parser parser) {
        this.config = config;
        this.parser = parser;
        this.downloader = downloader;
    }

    public Config getConfig() {
        return this.config;
    }

    public Response<VideoInfo> getVideoInfo(RequestVideoInfo request) {
        return this.parser.parseVideo(request);
    }

    public Response<List<SubtitlesInfo>> getSubtitlesInfo(RequestSubtitlesInfo request) {
        return this.parser.parseSubtitlesInfo(request);
    }

    public Response<PlaylistInfo> getChannelUploads(RequestChannelUploads request) {
        return this.parser.parseChannelsUploads(request);
    }

    public Response<PlaylistInfo> getPlaylistInfo(RequestPlaylistInfo request) {
        return this.parser.parsePlaylist(request);
    }

    public Response<File> downloadVideoFile(RequestVideoFileDownload request) {
        File outDir = request.getOutputDirectory();
        try {
            Utils.createOutDir(outDir);
        }
        catch (IOException e) {
            return ResponseImpl.error(e);
        }
        return this.downloader.downloadVideoAsFile(request);
    }

    public Response<Void> downloadVideoStream(RequestVideoStreamDownload request) {
        return this.downloader.downloadVideoAsStream(request);
    }

    public Response<String> downloadSubtitle(RequestWebpage request) {
        return this.downloader.downloadWebpage(request);
    }
}

