/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.flac.frame;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.flac.FlacStreamInfo;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.flac.frame.FlacFrameHeaderReader;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.flac.frame.FlacFrameInfo;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.flac.frame.FlacSubFrameReader;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.BitStreamReader;
import java.io.IOException;
import java.io.InputStream;

public class FlacFrameReader {
    public static final int TEMPORARY_BUFFER_SIZE = 32;

    public static int readFlacFrame(InputStream inputStream, BitStreamReader reader, FlacStreamInfo streamInfo, int[][] rawSampleBuffers, short[][] sampleBuffers, int[] temporaryBuffer) throws IOException {
        FlacFrameInfo frameInfo = FlacFrameReader.findAndParseFrameHeader(inputStream, reader, streamInfo);
        if (frameInfo == null) {
            return 0;
        }
        for (int i = 0; i < streamInfo.channelCount; ++i) {
            FlacSubFrameReader.readSubFrame(reader, streamInfo, frameInfo, rawSampleBuffers[i], i, temporaryBuffer);
        }
        reader.readRemainingBits();
        reader.asInteger(16);
        FlacFrameReader.applyChannelDelta(frameInfo.channelDelta, rawSampleBuffers, frameInfo.sampleCount);
        FlacFrameReader.convertToShortPcm(streamInfo, frameInfo.sampleCount, rawSampleBuffers, sampleBuffers);
        return frameInfo.sampleCount;
    }

    private static FlacFrameInfo findAndParseFrameHeader(InputStream inputStream, BitStreamReader reader, FlacStreamInfo streamInfo) throws IOException {
        int blockingStrategy = FlacFrameReader.skipToFrameSync(inputStream);
        if (blockingStrategy == -1) {
            return null;
        }
        return FlacFrameHeaderReader.readFrameHeader(reader, streamInfo, blockingStrategy == 1);
    }

    private static int skipToFrameSync(InputStream inputStream) throws IOException {
        int currentByte;
        int lastByte = -1;
        while ((currentByte = inputStream.read()) != -1) {
            if (lastByte == 255 && (currentByte & 0xFE) == 248) {
                return currentByte & 1;
            }
            lastByte = currentByte;
        }
        return -1;
    }

    private static void applyChannelDelta(FlacFrameInfo.ChannelDelta channelDelta, int[][] rawSampleBuffers, int sampleCount) {
        switch (channelDelta) {
            case LEFT_SIDE: {
                FlacFrameReader.applyLeftSideDelta(rawSampleBuffers, sampleCount);
                break;
            }
            case RIGHT_SIDE: {
                FlacFrameReader.applyRightSideDelta(rawSampleBuffers, sampleCount);
                break;
            }
            case MID_SIDE: {
                FlacFrameReader.applyMidDelta(rawSampleBuffers, sampleCount);
                break;
            }
        }
    }

    private static void applyLeftSideDelta(int[][] rawSampleBuffers, int sampleCount) {
        for (int i = 0; i < sampleCount; ++i) {
            rawSampleBuffers[1][i] = rawSampleBuffers[0][i] - rawSampleBuffers[1][i];
        }
    }

    private static void applyRightSideDelta(int[][] rawSampleBuffers, int sampleCount) {
        for (int i = 0; i < sampleCount; ++i) {
            int[] nArray = rawSampleBuffers[0];
            int n = i;
            nArray[n] = nArray[n] + rawSampleBuffers[1][i];
        }
    }

    private static void applyMidDelta(int[][] rawSampleBuffers, int sampleCount) {
        for (int i = 0; i < sampleCount; ++i) {
            int delta = rawSampleBuffers[1][i];
            int middle = (rawSampleBuffers[0][i] << 1) + (delta & 1);
            rawSampleBuffers[0][i] = middle + delta >> 1;
            rawSampleBuffers[1][i] = middle - delta >> 1;
        }
    }

    private static void convertToShortPcm(FlacStreamInfo streamInfo, int sampleCount, int[][] rawSampleBuffers, short[][] sampleBuffers) {
        if (streamInfo.bitsPerSample < 16) {
            FlacFrameReader.increaseSampleSize(streamInfo, sampleCount, rawSampleBuffers, sampleBuffers);
        } else if (streamInfo.bitsPerSample > 16) {
            FlacFrameReader.decreaseSampleSize(streamInfo, sampleCount, rawSampleBuffers, sampleBuffers);
        } else {
            for (int channel = 0; channel < streamInfo.channelCount; ++channel) {
                for (int i = 0; i < sampleCount; ++i) {
                    sampleBuffers[channel][i] = (short)rawSampleBuffers[channel][i];
                }
            }
        }
    }

    private static void increaseSampleSize(FlacStreamInfo streamInfo, int sampleCount, int[][] rawSampleBuffers, short[][] sampleBuffers) {
        int shiftLeft = 16 - streamInfo.bitsPerSample;
        for (int channel = 0; channel < streamInfo.channelCount; ++channel) {
            for (int i = 0; i < sampleCount; ++i) {
                sampleBuffers[channel][i] = (short)(rawSampleBuffers[channel][i] << shiftLeft);
            }
        }
    }

    private static void decreaseSampleSize(FlacStreamInfo streamInfo, int sampleCount, int[][] rawSampleBuffers, short[][] sampleBuffers) {
        int shiftRight = streamInfo.bitsPerSample - 16;
        for (int channel = 0; channel < streamInfo.channelCount; ++channel) {
            for (int i = 0; i < sampleCount; ++i) {
                sampleBuffers[channel][i] = (short)(rawSampleBuffers[channel][i] >> shiftRight);
            }
        }
    }
}

