/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.AudioFilter;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.AudioFilterChain;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.ShortPcmAudioFilter;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.SplitShortPcmAudioFilter;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.UniversalPcmAudioFilter;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.converter.ConverterAudioFilter;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.converter.ToFloatAudioFilter;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.converter.ToShortAudioFilter;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.converter.ToSplitShortAudioFilter;
import java.util.ArrayList;
import java.util.List;

public class FilterChainBuilder {
    private final List<AudioFilter> filters = new ArrayList<AudioFilter>();

    public void addFirst(AudioFilter filter) {
        this.filters.add(filter);
    }

    public AudioFilter first() {
        return this.filters.get(this.filters.size() - 1);
    }

    public FloatPcmAudioFilter makeFirstFloat(int channelCount) {
        AudioFilter first = this.first();
        if (first instanceof FloatPcmAudioFilter) {
            return (FloatPcmAudioFilter)first;
        }
        return this.prependUniversalFilter(first, channelCount);
    }

    public UniversalPcmAudioFilter makeFirstUniversal(int channelCount) {
        AudioFilter first = this.first();
        if (first instanceof UniversalPcmAudioFilter) {
            return (UniversalPcmAudioFilter)first;
        }
        return this.prependUniversalFilter(first, channelCount);
    }

    public AudioFilterChain build(Object context, int channelCount) {
        UniversalPcmAudioFilter firstFilter = this.makeFirstUniversal(channelCount);
        return new AudioFilterChain(firstFilter, this.filters, context);
    }

    private UniversalPcmAudioFilter prependUniversalFilter(AudioFilter first, int channelCount) {
        ConverterAudioFilter universalInput;
        if (first instanceof SplitShortPcmAudioFilter) {
            universalInput = new ToSplitShortAudioFilter((SplitShortPcmAudioFilter)first, channelCount);
        } else if (first instanceof FloatPcmAudioFilter) {
            universalInput = new ToFloatAudioFilter((FloatPcmAudioFilter)first, channelCount);
        } else if (first instanceof ShortPcmAudioFilter) {
            universalInput = new ToShortAudioFilter((ShortPcmAudioFilter)first, channelCount);
        } else {
            throw new RuntimeException("Filter must implement at least one data type.");
        }
        this.addFirst(universalInput);
        return universalInput;
    }
}

