/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.format;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.format.AudioDataFormatTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.TrackStateListener;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class AudioPlayerInputStream
extends InputStream {
    private final AudioPlayer player;
    private final AudioDataFormat format;
    private final long timeout;
    private final boolean provideSilence;
    private ByteBuffer current;

    public AudioPlayerInputStream(AudioDataFormat format, AudioPlayer player, long timeout, boolean provideSilence) {
        this.format = format;
        this.player = player;
        this.timeout = timeout;
        this.provideSilence = provideSilence;
    }

    @Override
    public int read() throws IOException {
        this.ensureAvailable();
        return this.current.get();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int currentOffset;
        int piece;
        for (currentOffset = offset; currentOffset < length; currentOffset += piece) {
            this.ensureAvailable();
            piece = Math.min(this.current.remaining(), length - currentOffset);
            this.current.get(buffer, currentOffset, piece);
        }
        return currentOffset - offset;
    }

    @Override
    public int available() throws IOException {
        return this.current != null ? this.current.remaining() : 0;
    }

    @Override
    public void close() throws IOException {
        this.player.stopTrack();
    }

    public static AudioInputStream createStream(AudioPlayer player, AudioDataFormat format, long stuckTimeout, boolean provideSilence) {
        AudioFormat jdkFormat = AudioDataFormatTools.toAudioFormat(format);
        return new AudioInputStream(new AudioPlayerInputStream(format, player, stuckTimeout, provideSilence), jdkFormat, -1L);
    }

    private void ensureAvailable() throws IOException {
        while (this.available() == 0) {
            try {
                this.attemptRetrieveFrame();
            }
            catch (TimeoutException e) {
                this.notifyTrackStuck();
            }
            catch (InterruptedException e) {
                ExceptionTools.keepInterrupted(e);
                throw new InterruptedIOException();
            }
            if (this.available() != 0 || !this.provideSilence) continue;
            this.addFrame(this.format.silenceBytes());
            break;
        }
    }

    private void attemptRetrieveFrame() throws TimeoutException, InterruptedException {
        AudioFrame frame = this.player.provide(this.timeout, TimeUnit.MILLISECONDS);
        if (frame != null) {
            if (!this.format.equals(frame.getFormat())) {
                throw new IllegalStateException("Frame read from the player uses a different format than expected.");
            }
            this.addFrame(frame.getData());
        } else if (!this.provideSilence) {
            Thread.sleep(10L);
        }
    }

    private void addFrame(byte[] data) {
        this.current = ByteBuffer.wrap(data);
    }

    private void notifyTrackStuck() {
        if (this.player instanceof TrackStateListener) {
            ((TrackStateListener)((Object)this.player)).onTrackStuck(this.player.getPlayingTrack(), this.timeout);
        }
    }
}

