/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.http;

import dev.felnull.imp.libs.org.apache.http.HttpClientConnection;
import dev.felnull.imp.libs.org.apache.http.HttpHost;
import dev.felnull.imp.libs.org.apache.http.config.ConnectionConfig;
import dev.felnull.imp.libs.org.apache.http.config.SocketConfig;
import dev.felnull.imp.libs.org.apache.http.conn.ConnectionRequest;
import dev.felnull.imp.libs.org.apache.http.conn.HttpClientConnectionManager;
import dev.felnull.imp.libs.org.apache.http.conn.HttpClientConnectionOperator;
import dev.felnull.imp.libs.org.apache.http.conn.HttpConnectionFactory;
import dev.felnull.imp.libs.org.apache.http.conn.ManagedHttpClientConnection;
import dev.felnull.imp.libs.org.apache.http.conn.routing.HttpRoute;
import dev.felnull.imp.libs.org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import dev.felnull.imp.libs.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

public class SimpleHttpClientConnectionManager
implements HttpClientConnectionManager {
    private final HttpClientConnectionOperator connectionOperator;
    private final HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connectionFactory;
    private volatile SocketConfig socketConfig = SocketConfig.DEFAULT;
    private volatile ConnectionConfig connectionConfig = ConnectionConfig.DEFAULT;

    public SimpleHttpClientConnectionManager(HttpClientConnectionOperator connectionOperator, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> factory) {
        this.connectionOperator = connectionOperator;
        this.connectionFactory = factory != null ? factory : ManagedHttpClientConnectionFactory.INSTANCE;
    }

    public void setSocketConfig(SocketConfig config) {
        this.socketConfig = config;
    }

    public void setConnectionConfig(ConnectionConfig config) {
        this.connectionConfig = config;
    }

    @Override
    public ConnectionRequest requestConnection(final HttpRoute route, Object state) {
        return new ConnectionRequest(){

            @Override
            public boolean cancel() {
                return false;
            }

            @Override
            public HttpClientConnection get(long timeout, TimeUnit timeUnit) {
                return (HttpClientConnection)SimpleHttpClientConnectionManager.this.connectionFactory.create(route, SimpleHttpClientConnectionManager.this.connectionConfig);
            }
        };
    }

    @Override
    public void releaseConnection(HttpClientConnection connection, Object newState, long validDuration, TimeUnit timeUnit) {
        try {
            connection.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void connect(HttpClientConnection connection, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
        HttpHost host = route.getProxyHost() != null ? route.getProxyHost() : route.getTargetHost();
        InetSocketAddress localAddress = route.getLocalSocketAddress();
        ManagedHttpClientConnection managed = (ManagedHttpClientConnection)connection;
        this.connectionOperator.connect(managed, host, localAddress, connectTimeout, this.socketConfig, context);
    }

    @Override
    public void upgrade(HttpClientConnection connection, HttpRoute route, HttpContext context) throws IOException {
        ManagedHttpClientConnection managed = (ManagedHttpClientConnection)connection;
        this.connectionOperator.upgrade(managed, route.getTargetHost(), context);
    }

    @Override
    public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) {
    }

    @Override
    public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
    }

    @Override
    public void closeExpiredConnections() {
    }

    @Override
    public void shutdown() {
    }
}

