/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.dev.felnull.fnjl.util;

import dev.felnull.imp.libs.dev.felnull.fnjl.math.FNComplex;
import dev.felnull.imp.libs.dev.felnull.fnjl.math.FNVec2d;
import dev.felnull.imp.libs.dev.felnull.fnjl.math.FNVec2f;
import dev.felnull.imp.libs.dev.felnull.fnjl.math.FNVec2i;
import dev.felnull.imp.libs.dev.felnull.fnjl.tuple.FNPair;
import dev.felnull.imp.libs.dev.felnull.fnjl.tuple.SimpleFNPair;
import java.util.function.Consumer;

public class FNMath {
    public static final double ABSOLUTE_ZERO_TEMP = (double)-273.15f;

    public static float toKelvinTemp(float celsius) {
        return celsius - -273.15f;
    }

    public static float toCelsiusTemp(float kelvin) {
        return kelvin + -273.15f;
    }

    public static int toKelvinTemp(int celsius) {
        return celsius - -273;
    }

    public static int toCelsiusTemp(int kelvin) {
        return kelvin + -273;
    }

    public static long toKelvinTemp(long celsius) {
        return celsius - -273L;
    }

    public static long toCelsiusTemp(long kelvin) {
        return kelvin + -273L;
    }

    public static double toKelvinTemp(double celsius) {
        return celsius - (double)-273.15f;
    }

    public static double toCelsiusTemp(double kelvin) {
        return kelvin + (double)-273.15f;
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(Math.min(value, max), min);
    }

    public static long clamp(long value, long min, long max) {
        return Math.max(Math.min(value, max), min);
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(Math.min(value, max), min);
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(Math.min(value, max), min);
    }

    public static boolean mandelbrot(double x, double y, int num) {
        return FNMath.mandelbrot(new FNComplex(x, y), num);
    }

    public static boolean mandelbrot(FNComplex complex, int num) {
        return complex.mandelbrot(num) >= num;
    }

    public static void generateMandelbrotSet(int width, int height, double posX, double posY, double zoom, int num, Consumer<FNVec2i> pos) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double xp = (-((double)width) / 2.0 + (double)x + posX) / (double)width;
                double yp = (-((double)height) / 2.0 + (double)y + posY) / (double)height;
                if (!FNMath.mandelbrot(xp * (4.0 / zoom), yp * (4.0 / zoom), num)) continue;
                pos.accept(new FNVec2i(x, y));
            }
        }
    }

    public static void generateColorMandelbrot(int width, int height, double posX, double posY, double zoom, int max, Consumer<PosColorEntry> pos) {
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double xp = (-((double)width) / 2.0 + (double)x + posX) / (double)width;
                double yp = (-((double)height) / 2.0 + (double)y + posY) / (double)height;
                pos.accept(new PosColorEntry(new FNVec2i(x, y), new FNComplex(xp * (4.0 / zoom), yp * (4.0 / zoom)).mandelbrot(max)));
            }
        }
    }

    public static FNVec2d scale(double w, double h) {
        if (w > h) {
            return new FNVec2d(1.0, h / w);
        }
        return new FNVec2d(w / h, 1.0);
    }

    public static int min(int value, int ... values) {
        int min = value;
        for (int i : values) {
            if (min <= i) continue;
            min = i;
        }
        return min;
    }

    public static float min(float value, float ... values) {
        float min = value;
        for (float i : values) {
            if (!(min > i)) continue;
            min = i;
        }
        return min;
    }

    public static double min(double value, double ... values) {
        double min = value;
        for (double i : values) {
            if (!(min > i)) continue;
            min = i;
        }
        return min;
    }

    public static long min(long value, long ... values) {
        long min = value;
        for (long i : values) {
            if (min <= i) continue;
            min = i;
        }
        return min;
    }

    public static int max(int value, int ... values) {
        int max = value;
        for (int i : values) {
            if (max >= i) continue;
            max = i;
        }
        return max;
    }

    public static float max(float value, float ... values) {
        float max = value;
        for (float i : values) {
            if (!(max < i)) continue;
            max = i;
        }
        return max;
    }

    public static double max(double value, double ... values) {
        double max = value;
        for (double i : values) {
            if (!(max < i)) continue;
            max = i;
        }
        return max;
    }

    public static long max(long value, long ... values) {
        long max = value;
        for (long i : values) {
            if (max >= i) continue;
            max = i;
        }
        return max;
    }

    public static FNPair<FNVec2f, FNVec2f> trans4to2CornerPlanes(FNVec2f v1, FNVec2f v2, FNVec2f v3, FNVec2f v4) {
        float stX = FNMath.min(v1.getX(), v2.getX(), v3.getX(), v4.getX());
        float stY = FNMath.min(v1.getY(), v2.getY(), v3.getY(), v4.getY());
        float enX = FNMath.max(v1.getX(), v2.getX(), v3.getX(), v4.getX());
        float enY = FNMath.max(v1.getY(), v2.getY(), v3.getY(), v4.getY());
        return new SimpleFNPair<FNVec2f, FNVec2f>(new FNVec2f(stX, stY), new FNVec2f(enX, enY));
    }

    public static class PosColorEntry {
        private final FNVec2i pos;
        private final int color;

        protected PosColorEntry(FNVec2i pos, int color) {
            this.pos = pos;
            this.color = color;
        }

        public FNVec2i getPos() {
            return this.pos;
        }

        public int getColor() {
            return this.color;
        }
    }
}

