/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.server.music;

import dev.felnull.imp.advancements.IMPCriteriaTriggers;
import dev.felnull.imp.music.resource.AuthorityInfo;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.server.data.MusicSaveData;
import dev.felnull.otyacraftengine.server.data.WorldDataManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_3222;

public class MusicManager {
    private static final MusicManager INSTANCE = new MusicManager();

    public static MusicManager getInstance() {
        return INSTANCE;
    }

    public MusicSaveData getSaveData() {
        return (MusicSaveData)WorldDataManager.getInstance().getSaveData(MusicSaveData.class);
    }

    public void addMusic(Music music) {
        this.getSaveData().getMusics().put(music.getUuid(), music);
        this.getSaveData().method_80();
    }

    public MusicPlayList getPlaylistByMusic(UUID musicId) {
        for (MusicPlayList value : this.getSaveData().getPlayLists().values()) {
            if (!value.getMusicList().contains(musicId)) continue;
            return value;
        }
        return null;
    }

    public void addPlayList(MusicPlayList playList) {
        this.getSaveData().getPlayLists().put(playList.getUuid(), playList);
        this.getSaveData().method_80();
    }

    public void removeMusic(UUID musicID) {
        this.getSaveData().getMusics().remove(musicID);
        this.getSaveData().getPlayLists().values().stream().map(MusicPlayList::getMusicList).forEach(n -> n.remove(musicID));
        this.getSaveData().method_80();
    }

    public void removePlayList(UUID playlistID) {
        this.getSaveData().getPlayLists().remove(playlistID);
        this.getSaveData().method_80();
    }

    public void addMusicToPlayList(class_3222 player, UUID playlistId, Music music) {
        this.addMusicToPlayList(playlistId, music);
        IMPCriteriaTriggers.ADD_MUSIC.trigger(player);
    }

    public void addMusicToPlayList(UUID playlistId, Music music) {
        if (this.getSaveData().getPlayLists().containsKey(playlistId)) {
            this.addMusic(music);
            this.getSaveData().getPlayLists().get(playlistId).getMusicList().add(music.getUuid());
            this.getSaveData().method_80();
        }
    }

    public List<MusicPlayList> getPlayerPlayLists(class_3222 player, PlayListGetType getType) {
        UUID uuid = player.method_7334().getId();
        ArrayList playLists = new ArrayList();
        this.getSaveData().getPlayLists().forEach((n, m) -> {
            if (getType.check(m.getAuthority().getAuthorityType(uuid))) {
                playLists.add(m);
            }
        });
        return Collections.unmodifiableList(playLists);
    }

    public void addPlayListToPlayer(UUID playListId, class_3222 player) {
        UUID uuid = player.method_7334().getId();
        MusicPlayList pl = this.getSaveData().getPlayLists().get(playListId);
        if (pl != null && pl.getAuthority().canJoin(uuid)) {
            pl.getAuthority().getRawAuthority().put(uuid, pl.getAuthority().getInitialAuthority());
            this.getSaveData().method_80();
        }
    }

    public void deletePlayList(UUID playListId, class_3222 player) {
        MusicPlayList pl = this.getSaveData().getPlayLists().get(playListId);
        if (pl == null) {
            return;
        }
        if (!pl.getAuthority().getAuthorityType(player.method_7334().getId()).canDelete()) {
            this.exitPlayList(playListId, player);
            return;
        }
        for (UUID uuid : pl.getMusicList()) {
            this.getSaveData().getMusics().remove(uuid);
        }
        this.getSaveData().getPlayLists().remove(playListId);
        this.getSaveData().method_80();
    }

    public void exitPlayList(UUID playListId, class_3222 player) {
        MusicPlayList pl = this.getSaveData().getPlayLists().get(playListId);
        if (pl == null) {
            return;
        }
        this.getSaveData().getPlayLists().get(playListId).getAuthority().getRawAuthority().remove(player.method_7334().getId());
        this.getSaveData().method_80();
    }

    public void deleteMusic(UUID playListId, UUID musicId, class_3222 player) {
        MusicPlayList pl = this.getSaveData().getPlayLists().get(playListId);
        if (pl == null || !pl.getMusicList().contains(musicId)) {
            return;
        }
        UUID pid = player.method_7334().getId();
        Music m = this.getSaveData().getMusics().get(musicId);
        if (m == null) {
            return;
        }
        boolean flg1 = pl.getAuthority().getAuthorityType(pid).canMusicDelete();
        boolean flg2 = m.getOwner().equals(pid);
        if (!flg1 && !flg2) {
            return;
        }
        this.getSaveData().getPlayLists().get(playListId).getMusicList().remove(musicId);
        this.getSaveData().getMusics().remove(musicId);
        this.getSaveData().method_80();
    }

    public void changeAuthority(UUID playListId, UUID targetPlayerId, AuthorityInfo.AuthorityType authorityType, class_3222 player) {
        AuthorityInfo.AuthorityType ta;
        if (authorityType == AuthorityInfo.AuthorityType.INVITATION) {
            return;
        }
        MusicPlayList pl = this.getSaveData().getPlayLists().get(playListId);
        if (pl == null) {
            return;
        }
        if (!pl.getAuthority().getPlayersAuthority().containsKey(targetPlayerId)) {
            return;
        }
        AuthorityInfo.AuthorityType ma = pl.getAuthority().getAuthorityType(player.method_7334().getId());
        if (!ma.canChangeAuth(ta = pl.getAuthority().getAuthorityType(targetPlayerId))) {
            return;
        }
        if (authorityType.isMoreAdmin() && !ma.isMoreOwner()) {
            return;
        }
        if (authorityType == AuthorityInfo.AuthorityType.NONE) {
            this.getSaveData().getPlayLists().get(playListId).getAuthority().getRawAuthority().remove(targetPlayerId);
        } else {
            this.getSaveData().getPlayLists().get(playListId).getAuthority().getRawAuthority().put(targetPlayerId, authorityType);
        }
        this.getSaveData().method_80();
    }

    public void addMultipleMusic(UUID playListId, List<Music> musics, class_3222 player) {
        MusicPlayList pl = this.getSaveData().getPlayLists().get(playListId);
        if (pl == null) {
            return;
        }
        if (!pl.getAuthority().getAuthorityType(player.method_7334().getId()).canAddMusic()) {
            return;
        }
        for (Music music : musics) {
            Music am = new Music(UUID.randomUUID(), music.getName(), music.getAuthor(), music.getSource(), music.getImage(), player.method_7334().getId(), System.currentTimeMillis());
            this.addMusicToPlayList(player, pl.getUuid(), am);
        }
    }

    public void editMusic(UUID musicId, UUID playListId, String name, ImageInfo image, class_3222 player) {
        MusicPlayList pl = this.getSaveData().getPlayLists().get(playListId);
        if (pl == null || !pl.getMusicList().contains(musicId)) {
            return;
        }
        UUID pid = player.method_7334().getId();
        if (pl.getAuthority().getAuthorityType(pid).isBan()) {
            return;
        }
        Music m = this.getSaveData().getMusics().get(musicId);
        if (m == null || !m.getOwner().equals(pid)) {
            return;
        }
        Music nm = new Music(musicId, name, m.getAuthor(), m.getSource(), image, m.getOwner(), m.getCreateDate());
        this.getSaveData().getMusics().put(musicId, nm);
        this.getSaveData().method_80();
    }

    public void editPlayList(UUID playListId, String name, ImageInfo image, List<UUID> invitePlayers, boolean publiced, boolean initMember, class_3222 player) {
        MusicPlayList pl = this.getSaveData().getPlayLists().get(playListId);
        if (pl == null) {
            return;
        }
        if (!pl.getAuthority().getAuthorityType(player.method_7334().getId()).canEdit()) {
            return;
        }
        AuthorityInfo oldAuth = pl.getAuthority();
        HashMap<UUID, AuthorityInfo.AuthorityType> naus = new HashMap<UUID, AuthorityInfo.AuthorityType>(oldAuth.getRawAuthority());
        List<UUID> rms = naus.entrySet().stream().filter(n -> n.getValue() == AuthorityInfo.AuthorityType.INVITATION).map(Map.Entry::getKey).toList();
        rms.forEach(naus::remove);
        invitePlayers.forEach(n -> {
            if (!naus.containsKey(n)) {
                naus.put((UUID)n, AuthorityInfo.AuthorityType.INVITATION);
            }
        });
        AuthorityInfo auth = new AuthorityInfo(publiced, oldAuth.getOwner(), oldAuth.getOwnerName(), naus, initMember ? AuthorityInfo.AuthorityType.MEMBER : AuthorityInfo.AuthorityType.READ_ONLY);
        this.getSaveData().getPlayLists().put(playListId, new MusicPlayList(playListId, name, image, auth, pl.getMusicList(), pl.getCreateDate()));
        this.getSaveData().method_80();
    }

    public static enum PlayListGetType {
        NO_BAN(n -> !n.isBan()),
        JOIN(n -> !n.isBan() && n.isMoreReadOnly()),
        NO_JOIN(n -> !n.isBan() && !n.isMoreReadOnly() || n.isInvitation());

        private final Function<AuthorityInfo.AuthorityType, Boolean> filter;

        private PlayListGetType(Function<AuthorityInfo.AuthorityType, Boolean> filter) {
            this.filter = filter;
        }

        private boolean check(AuthorityInfo.AuthorityType type) {
            return this.filter.apply(type);
        }
    }
}

