/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.server.music.ringer;

import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.server.music.ringer.MusicRing;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class MusicRingManager {
    private static final MusicRingManager INSTANCE = new MusicRingManager();
    public static final class_2960 FIXED_TRACKER = new class_2960("iammusicplayer", "fixed");
    public static final class_2960 ENTITY_TRACKER = new class_2960("iammusicplayer", "entity");
    public static final class_2960 PLAYER_TRACKER = new class_2960("iammusicplayer", "player");
    private final Map<class_3218, MusicRing> MUSIC_RINGERS = new HashMap<class_3218, MusicRing>();

    public static MusicRingManager getInstance() {
        return INSTANCE;
    }

    public void tick(class_3218 level) {
        MusicRing ringer = this.MUSIC_RINGERS.get(level);
        if (ringer == null) {
            ringer = new MusicRing(level);
            this.MUSIC_RINGERS.put(level, ringer);
        }
        ringer.tick(level);
    }

    public Map<class_3218, MusicRing> getMusicRingers() {
        return this.MUSIC_RINGERS;
    }

    public void restartRinger(class_3218 level, UUID uuid) {
        MusicRing ring = this.MUSIC_RINGERS.get(level);
        if (ring != null) {
            ring.restart(uuid);
        }
    }

    public void addRinger(class_3218 level, IMusicRinger ringer) {
        MusicRing ring = this.MUSIC_RINGERS.get(level);
        if (ring != null) {
            ring.addRinger(ringer);
        }
    }

    public boolean isWaitRinger(UUID uuid, class_3218 level) {
        MusicRing ring = this.MUSIC_RINGERS.get(level);
        if (ring != null) {
            return ring.isWaitRinger(uuid);
        }
        return false;
    }

    public void onUpdate(class_3222 player, UUID uuid, UUID waitUUID, int state) {
        MusicRing ring = this.MUSIC_RINGERS.get(player.method_14220());
        if (ring != null) {
            ring.onUpdate(player, uuid, waitUUID, state);
        }
    }

    public void addReadyPlayer(class_3222 player, UUID uuid, UUID waitUUID, boolean result, boolean retry, long elapsed) {
        MusicRing ring = this.MUSIC_RINGERS.get(player.method_14220());
        if (ring != null) {
            ring.addReadyPlayer(player, uuid, waitUUID, result, retry, elapsed);
        }
    }

    public boolean isExistRinger(UUID uuid) {
        for (class_3218 serverLevel : this.MUSIC_RINGERS.keySet()) {
            if (!this.isExistRinger(serverLevel, uuid)) continue;
            return true;
        }
        return false;
    }

    public boolean isExistRinger(class_3218 level, UUID uuid) {
        MusicRing ring = this.MUSIC_RINGERS.get(level);
        if (ring != null) {
            return ring.getRingers().containsKey(uuid);
        }
        return false;
    }

    public IMusicRinger getRinger(UUID uuid) {
        for (class_3218 serverLevel : this.MUSIC_RINGERS.keySet()) {
            IMusicRinger r;
            MusicRing mr = this.MUSIC_RINGERS.get(serverLevel);
            if (mr == null || (r = mr.getRingers().get(uuid)) == null) continue;
            return r;
        }
        return null;
    }

    @Nullable
    public class_3218 getLevel(MusicRing ring) {
        for (Map.Entry<class_3218, MusicRing> entry : this.MUSIC_RINGERS.entrySet()) {
            if (entry.getValue() != ring) continue;
            return entry.getKey();
        }
        return null;
    }

    public void pause() {
        this.MUSIC_RINGERS.forEach((n, m) -> m.pause());
    }

    public void resume() {
        this.MUSIC_RINGERS.forEach((n, m) -> m.resume());
    }

    public void clear() {
        this.MUSIC_RINGERS.forEach((n, m) -> m.depose());
        this.MUSIC_RINGERS.clear();
    }

    public static class_2487 createFixedTracker(class_243 vec3) {
        class_2487 tag = new class_2487();
        tag.method_10549("x", vec3.field_1352);
        tag.method_10549("y", vec3.field_1351);
        tag.method_10549("z", vec3.field_1350);
        return tag;
    }

    public static class_2487 createEntityTracker(class_1297 entity) {
        class_2487 tag = new class_2487();
        class_243 p = entity.method_19538();
        tag.method_10549("x", p.field_1352);
        tag.method_10549("y", p.field_1351);
        tag.method_10549("z", p.field_1350);
        tag.method_10569("id", entity.method_5628());
        return tag;
    }

    public static class_2487 createPlayerTracker(class_1657 player) {
        class_2487 tag = new class_2487();
        class_243 p = player.method_19538();
        tag.method_10549("x", p.field_1352);
        tag.method_10549("y", p.field_1351);
        tag.method_10549("z", p.field_1350);
        tag.method_25927("id", player.method_7334().getId());
        return tag;
    }
}

