package dev.felnull.imp.blockentity;

import dev.felnull.imp.block.BoomboxBlock;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.inventory.BoomboxMenu;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.server.music.ringer.IBoomboxRinger;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import dev.felnull.imp.util.IMPItemUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import var;
import java.util.UUID;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class BoomboxBlockEntity extends IMPBaseEntityBlockEntity implements IBoomboxRinger {
    private final BoomboxData boomboxData;
    private final class_2371<class_1799> items = class_2371.method_10213(2, class_1799.field_8037);
    private final UUID ringerUUID = UUID.randomUUID();

    public BoomboxBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(IMPBlockEntitys.BOOMBOX.get(), blockPos, blockState);
        this.boomboxData = new BoomboxData(new BoomboxData.DataAccess() {
            @Override
            public class_1799 getCassetteTape() {
                return BoomboxBlockEntity.this.getCassetteTape();
            }

            @Override
            public class_1799 getAntenna() {
                return BoomboxBlockEntity.this.getAntenna();
            }

            @Override
            public boolean isPower() {
                return BoomboxBlockEntity.this.isPower();
            }

            @Override
            public void setPower(boolean power) {
                BoomboxBlockEntity.this.setPower(power);
            }

            @Override
            public IMusicRinger getRinger() {
                return BoomboxBlockEntity.this;
            }

            @Override
            public class_243 getPosition() {
                return new class_243(method_11016().method_10263(), method_11016().method_10264(), method_11016().method_10260());
            }

            @Override
            public void setCassetteTape(class_1799 stack) {
                setItemNoUpdate(0, stack);
            }

            @Override
            public void dataUpdate(BoomboxData data) {
                method_5431();
            }
        });
    }

    @Override
    public void method_5447(int i, class_1799 stack) {
        if (i == 0)
            this.boomboxData.onCassetteTapeChange(stack, getCassetteTape());
        setItemNoUpdate(i, stack);
    }

    public void setItemNoUpdate(int i, class_1799 stack) {
        super.method_5447(i, stack);
    }

    public void setBoomboxData(BoomboxData data) {
        boomboxData.load(data.save(new class_2487(), false, false), false, false);
    }

    @Override
    public class_1799 createRetainDropItem() {
        return BoomboxItem.createByBE(this, false);
    }

    @Override
    public boolean isRetainDrop() {
        return true;
    }

    @Override
    public boolean isRetainEmpty() {
        return false;
    }

    @Override
    protected class_2561 method_17823() {
        return IMPBlocks.BOOMBOX.get().method_9518();
    }

    @Override
    protected class_1703 method_5465(int i, @NotNull class_1661 inventory) {
        return new BoomboxMenu(i, inventory, this, method_11016(), class_1799.field_8037, null);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.boomboxData.load(tag.method_10562("BoomBoxData"), false, false);
    }

    @Override
    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10566("BoomBoxData", this.boomboxData.save(new class_2487(), false, false));
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, BoomboxBlockEntity blockEntity) {
        blockEntity.boomboxData.tick(level);
        if (!level.method_8608()) {
            blockEntity.ringerTick();
            blockEntity.setRaisedHandleState(blockEntity.boomboxData.getHandleRaisedProgress() >= blockEntity.boomboxData.getHandleRaisedMax());
            blockEntity.sync();
            blockEntity.method_5431();
        }
    }

    @Override
    public class_2487 getSyncData(class_3222 player, class_2487 tag) {
        tag.method_10566("BoomBoxData", this.boomboxData.save(new class_2487(), false, true));
        return super.getSyncData(player, tag);
    }

    @Override
    public void onSync(class_2487 tag) {
        super.onSync(tag);
        this.boomboxData.load(tag.method_10562("BoomBoxData"), false, true);
    }

    @Override
    public boolean method_5437(int i, class_1799 itemStack) {
        return (i == 0 && IMPItemUtil.isCassetteTape(itemStack)) || (i == 1 && IMPItemUtil.isAntenna(itemStack));
    }

    @Override
    public @NotNull class_2371<class_1799> getItems() {
        return items;
    }

    public void setRaisedHandleState(boolean raised) {
        var bs = method_11010().method_11657(BoomboxBlock.RAISED, raised);
        method_10997().method_8652(method_11016(), bs, 2);
    }

    public BoomboxData getBoomboxData() {
        return boomboxData;
    }

    @Override
    public class_2487 onInstruction(class_3222 player, String name, int num, class_2487 data) {
        var ret = boomboxData.onInstruction(player, name, num, data);
        if (ret != null)
            return ret;
        return super.onInstruction(player, name, num, data);
    }

    public class_1799 getCassetteTape() {
        return method_5438(0);
    }

    public class_1799 getAntenna() {
        return method_5438(1);
    }

    @Override
    public class_2561 getRingerName() {
        return method_17823();
    }

    @Override
    public UUID getRingerUUID() {
        return ringerUUID;
    }

    @Override
    public boolean isRingerExist() {
        if (method_10997() == null || field_11863 != method_10997()) return false;
        return method_11016() != null && field_11863.method_8321(method_11016()) == this;
    }

    @Override
    public @NotNull BoomboxData getRingerBoomboxData() {
        return boomboxData;
    }

    @Override
    public class_3218 getRingerLevel() {
        return (class_3218) this.field_11863;
    }

    @Override
    public Pair<class_2960, class_2487> getRingerTracker() {
        return Pair.of(MusicRingManager.FIXED_TRACKER, MusicRingManager.createFixedTracker(getRingerSpatialPosition()));
    }

    @Override
    public @NotNull class_243 getRingerSpatialPosition() {
        return new class_243(method_11016().method_10263() + 0.5, method_11016().method_10264() + 0.5, method_11016().method_10260() + 0.5);
    }

    public void setByItem(class_1799 stack) {
        setPower(BoomboxItem.isPowerOn(stack));
        setItemNoUpdate(0, BoomboxItem.getCassetteTape(stack));
        setItemNoUpdate(1, BoomboxItem.getAntenna(stack));
        setBoomboxData(BoomboxItem.getData(stack));
        setPower(BoomboxItem.isPowerOn(stack));
        if (BoomboxItem.getTransferProgress(stack) == 0) {
            boomboxData.setHandleRaising(true);
            boomboxData.setHandleRaisedProgress(boomboxData.getHandleRaisedMax());
            boomboxData.setHandleRaisedProgressOld(boomboxData.getHandleRaisedMax());
        }
    }
}
