package dev.felnull.imp.client.gui.components;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.client.music.subtitle.SubtitleEntry;
import dev.felnull.imp.client.music.subtitle.SubtitleType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4071;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import var;

public class MusicSubtitleOverlay extends class_4071 {
    public static final MusicSubtitleOverlay SUBTITLE_OVERLAY = new MusicSubtitleOverlay();
    private static final class_310 mc = class_310.method_1551();
    private final Map<SubtitleEntry, Long> SUBTITLES = new HashMap<>();
    private final List<SubtitleEntry> REMOVE_SUBTITLES = new ArrayList<>();
    private final Map<SubtitleEntry, Long> UPDATE_SUBTITLES = new HashMap<>();
    private final Map<SubtitleEntry, Boolean> PAUSED_SUBTITLES = new HashMap<>();
    private final Map<SubtitleEntry, Long> PAUSED_TIME_SUBTITLES = new HashMap<>();

    public void addSubtitle(SubtitleEntry entry) {
        SUBTITLES.put(entry, System.currentTimeMillis());
    }

    @Override
    public void method_25394(class_4587 poseStack, int i, int j, float f) {
        if (IamMusicPlayer.CONFIG.subtitleType != SubtitleType.OVERLAY) {
            SUBTITLES.clear();
            REMOVE_SUBTITLES.clear();
            UPDATE_SUBTITLES.clear();
            PAUSED_SUBTITLES.clear();
            PAUSED_TIME_SUBTITLES.clear();
            return;
        }

        SUBTITLES.forEach((n, m) -> {
            var pc = PAUSED_SUBTITLES.get(n);
            var cp = n.musicPlayer().isPaused();
            if (pc != null && pc != cp) {
                if (cp) {
                    PAUSED_TIME_SUBTITLES.put(n, System.currentTimeMillis());
                } else {
                    var pt = PAUSED_TIME_SUBTITLES.get(n);
                    if (pt != null) {
                        UPDATE_SUBTITLES.put(n, m + (System.currentTimeMillis() - pt));
                    }
                    PAUSED_TIME_SUBTITLES.clear();
                }
            }
            PAUSED_SUBTITLES.put(n, cp);

            if (((m + n.duration()) < System.currentTimeMillis() && n.musicPlayer().isPlaying()) || n.musicPlayer().isFinished() || (!n.musicPlayer().isPaused() && !n.musicPlayer().isPlaying()))
                REMOVE_SUBTITLES.add(n);
        });
        SUBTITLES.putAll(UPDATE_SUBTITLES);
        UPDATE_SUBTITLES.clear();
        REMOVE_SUBTITLES.forEach(SUBTITLES::remove);
        REMOVE_SUBTITLES.clear();

        if (SUBTITLES.isEmpty())
            return;
        int fh = mc.field_1772.field_2000;
        int mh = mc.method_22683().method_4502() - getMinHeight() - 1;
        mh -= SUBTITLES.size() * (fh + 1);
        int ch = 0;
        for (SubtitleEntry sub : SUBTITLES.keySet()) {
            drawText(poseStack, mh + ch, sub.component());
            ch += fh + 1;
        }
    }

    private void drawText(class_4587 poseStack, int y, class_2561 text) {
        var x = mc.method_22683().method_4486() / 2;
        class_327 font = mc.field_1772;
        int width = font.method_27525(text) + 2;
        x -= width / 2;
        method_25294(poseStack, x, y, x + width, y + font.field_2000, mc.field_1690.method_19345(0.8F));
        font.method_30883(poseStack, text, x + 1, y + 1, 14737632);
    }

    private int getMinHeight() {
        int h = 0;

        if (mc.field_1755 == null) {
            h += 22;
            if (mc.field_1724 != null && !mc.field_1724.method_7325() && !mc.field_1724.method_7337()) {
                h += 17;
                if (mc.field_1724.method_6096() > 0)
                    h += 10;
            }
        } else if (mc.field_1755 instanceof class_408) {
            h += 15;
        }

        return h;
    }
}
