package dev.felnull.imp.client.gui.components;

import dev.architectury.utils.value.IntValue;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.otyacraftengine.client.util.OEClientUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.function.BooleanSupplier;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_6382;

public class VolumeWidget extends class_339 implements IIMPSmartRender {
    private final IntValue volume;
    private final BooleanSupplier mute;
    private final BooleanConsumer setMute;

    public VolumeWidget(int x, int y, IntValue volume, BooleanSupplier mute, BooleanConsumer setMute) {
        super(x, y, 30, 10, new class_2588("imp.widget.volume"));
        this.volume = volume;
        this.mute = mute;
        this.setMute = setMute;
    }

    @Override
    public void method_37020(class_6382 narrationElementOutput) {
        this.method_37021(narrationElementOutput);
    }

    @Override
    public void method_25359(class_4587 poseStack, int i, int j, float f) {
        int vol = volume.get();
        boolean imute = mute.getAsBoolean();
        int nv = imute ? 3 : vol / 100;
        int lfs = (nv * 2) + (vol <= 0 ? 0 : 2);
        int z = method_25367() ? 20 : 0;
        OERenderUtil.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, poseStack, field_22760, field_22761, z, 156, imute ? 4 : 4 + lfs, 8);
        if (imute)
            OERenderUtil.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, poseStack, field_22760 + 3, field_22761, 12 + z, 156, 8, 8);
        drawSmartText(poseStack, new class_2585(String.valueOf(vol)), field_22760 + 5 + lfs, field_22761 + 0.5f, method_25367() ? 0XFF007F06 : 0XFF115D0E);
    }

    @Override
    public void method_25348(double d, double e) {
        super.method_25348(d, e);
        if (setMute != null)
            setMute.accept(!mute.getAsBoolean());
    }

    @Override
    public boolean method_25401(double d, double e, double f) {
        float mv = 1;
        if (OEClientUtil.isKeyInput(mc.field_1690.field_1832))
            mv *= 10;
        if (OEClientUtil.isKeyInput(mc.field_1690.field_1867))
            mv *= 10;
        int an = (int) (mv * f);
        volume.accept(class_3532.method_15340(volume.get() + an, 0, 300));
        return true;
    }
}
