package dev.felnull.imp.client.gui.screen.monitor.boombox;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.BoomboxScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import var;

public class RadioBMonitor extends PlayBackBaseBMonitor {
    private static final class_2960 BACK_BG_TEXTURE = new class_2960(IamMusicPlayer.MODID, "textures/gui/container/boombox/monitor/playback_back.png");
    private static final class_2561 LOADING_STREAM_TEXT = new class_2588("imp.text.streamLoading");
    private static final class_2561 PLAYING_STREAM_TEXT = new class_2588("imp.text.streamPlaying");
    private static final class_2561 NON_PROGRESS_TEXT = new class_2585("--:--/--:--");
    private SmartButton backButton;

    public RadioBMonitor(BoomboxData.MonitorType monitorType, BoomboxScreen screen) {
        super(monitorType, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.backButton = this.addRenderWidget(new SmartButton(getStartX() + width - 15, getStartY() + height - 12, 14, 11, new class_2588("gui.back"), n -> setMonitor(BoomboxData.MonitorType.RADIO_SELECT)));
        this.backButton.setHideText(true);
        this.backButton.setIcon(MusicManagerMonitor.WIDGETS_TEXTURE, 11, 123, 8, 8);
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtil.drawTexture(BACK_BG_TEXTURE, poseStack, getStartX(), getStartY(), 0f, 0f, width, height, width, height);
        var ptx = LOADING_STREAM_TEXT;
        if (!getScreen().isMusicLoading() && getScreen().getBoomBoxData().isPlaying()) {
            ptx = PLAYING_STREAM_TEXT;
        } else if (!getScreen().getBoomBoxData().isPlaying()) {
            ptx = NON_PROGRESS_TEXT;
        }
        drawSmartText(poseStack, ptx, getStartX() + 38 - (isShortProgressBar() ? 0 : 36), getStartY() + 15, 0XFF115D0E);
    }

    @Override
    public void renderAppearance(class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight, BoomboxData data) {
        super.renderAppearance(poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight, data);
        OERenderUtil.renderTextureSprite(BACK_BG_TEXTURE, poseStack, multiBufferSource, 0, 0, OERenderUtil.MIN_BREADTH * 2, 0, 0, 0, monitorWidth, monitorHeight, 0, 0, width, height, width, height, i, j);
        var ptx = LOADING_STREAM_TEXT;
        if (!data.isLoadingMusic() && data.isPlaying()) {
            ptx = PLAYING_STREAM_TEXT;
        } else if (!data.isPlaying()) {
            ptx = NON_PROGRESS_TEXT;
        }
        float onPxW = monitorWidth / (float) width;
        float onPxH = monitorHeight / (float) height;

        renderSmartTextSpriteColorSprite(poseStack, multiBufferSource, ptx, 38f - (isShortProgressBar(data) ? 0 : 36f), 17f, OERenderUtil.MIN_BREADTH * 2, onPxW, onPxH, monitorHeight, 0XFF115D0E, i);

        renderSmartButtonSprite(poseStack, multiBufferSource, width - 15, height - 12, OERenderUtil.MIN_BREADTH * 2f, 14, 11, i, j, onPxW, onPxH, monitorHeight, MusicManagerMonitor.WIDGETS_TEXTURE, 11, 123, 8, 8, 256, 256);
    }

    @Override
    protected @NotNull ImageInfo getPlayBackImage(BoomboxData data) {
        return data.getRadioImage();
    }

    @Override
    protected @NotNull String getPlayBackName(BoomboxData data) {
        return data.getRadioName();
    }

    @Override
    protected @NotNull String getPlayBackAuthor(BoomboxData data) {
        return data.getRadioAuthor();
    }

    @Override
    protected @NotNull MusicSource getPlayBackSource(BoomboxData data) {
        return data.getRadioSource();
    }

    @Override
    protected boolean isShortTipProgressBar() {
        return true;
    }
}
