package dev.felnull.imp.client.music.tracker;

import dev.felnull.imp.music.MusicPlaybackInfo;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class IMPMusicTrackers {
    private static final Map<class_2960, Function<class_2487, IMusicTracker>> TRACKERS = new HashMap<>();

    public static void init() {
        registerTracker(MusicRingManager.FIXED_TRACKER, FixedMusicTracker::new);
        registerTracker(MusicRingManager.ENTITY_TRACKER, EntityMusicTracker::new);
        registerTracker(MusicRingManager.PLAYER_TRACKER, PlayerMusicTracker::new);
    }

    public static void registerTracker(class_2960 location, Function<class_2487, IMusicTracker> tracker) {
        TRACKERS.put(location, tracker);
    }

    public static IMusicTracker createTracker(MusicPlaybackInfo playbackInfo) {
        return createTracker(playbackInfo.getTracker(), playbackInfo.getTrackerTag());
    }

    public static IMusicTracker createTracker(class_2960 location, class_2487 tag) {
        if (TRACKERS.containsKey(location))
            return TRACKERS.get(location).apply(tag);
        return null;
    }
}
