package dev.felnull.imp.item;

import dev.felnull.imp.block.BoomboxBlock;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.blockentity.BoomboxBlockEntity;
import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import dev.felnull.otyacraftengine.item.IInstructionItem;
import dev.felnull.otyacraftengine.item.ItemContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import var;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5328;

public class BoomboxItem extends class_1747 implements IInstructionItem {

    public BoomboxItem(class_2248 block, class_1793 properties) {
        super(block, properties);
    }

    @Override
    public void method_7888(@NotNull class_1799 itemStack, @NotNull class_1937 level, @NotNull class_1297 entity, int i, boolean bl) {
        super.method_7888(itemStack, level, entity, i, bl);
        tick(level, entity, itemStack, false);
    }

    @Override
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (getTransferProgress(itemStack) == 0 || getTransferProgress(itemStack) == 10) {
            if (!level.method_8608()) {
                if (checkDuplication(itemStack, player))
                    setUUID(itemStack, UUID.randomUUID());

                if (player.method_18276()) {
                    setPowerOn(itemStack, !isPowerOn(itemStack));
                } else {
                    if (isPowerOn(itemStack))
                        BoomboxItemContainer.openContainer((class_3222) player, interactionHand, itemStack);
                }
            }
            return class_1271.method_29237(itemStack, level.method_8608());
        }
        return super.method_7836(level, player, interactionHand);
    }

    @Override
    public class_1269 method_7712(class_1750 blockPlaceContext) {
        var itemStack = blockPlaceContext.method_8041();
        var player = blockPlaceContext.method_8036();
        if (player != null && !(!player.isCrouching() && !isPowerOn(itemStack))) {
            if (getTransferProgress(itemStack) == 0 || getTransferProgress(itemStack) == 10) {
                if (!blockPlaceContext.method_8045().method_8608()) {
                    if (player.isCrouching()) {
                        if (getTransferProgress(itemStack) == 0 || getTransferProgress(itemStack) == 10) {
                            setPowerOn(itemStack, !isPowerOn(itemStack));
                        }
                    } else {
                        if (isPowerOn(itemStack))
                            BoomboxItemContainer.openContainer((class_3222) player, blockPlaceContext.method_20287(), itemStack);
                    }
                }
                return class_1269.method_29236(blockPlaceContext.method_8045().field_9236);
            } else {
                return class_1269.field_5814;
            }
        }
        return super.method_7712(blockPlaceContext);
    }

    @Override
    protected boolean method_7709(class_1750 blockPlaceContext, @NotNull class_2680 blockState) {
        return !isPowerOn(blockPlaceContext.method_8041()) && super.method_7709(blockPlaceContext, blockState);
    }

    @Override
    public void method_33261(@NotNull class_1542 itemEntity) {
        if (this.method_7711() instanceof BoomboxBlock) {
            class_5328.method_33263(itemEntity, getContainItem(itemEntity.method_6983()).stream());
        }
        super.method_33261(itemEntity);
    }

    public static void tick(class_1937 level, class_1297 entity, class_1799 stack, boolean musicOnly) {
        if (!stack.method_31574(IMPBlocks.BOOMBOX.get().method_8389())) return;
        if (!level.method_8608()) {
            if (getUUID(stack) == null)
                setUUID(stack, UUID.randomUUID());

            var mr = MusicRingManager.getInstance();
            var uuid = getUUID(stack);
            if (uuid != null && BoomboxEntityRinger.canRing(entity) && !mr.isExistRinger((class_3218) level, uuid)) {
                mr.addRinger((class_3218) level, new BoomboxEntityRinger(entity, uuid));
            }
        }

        if (musicOnly) return;

        var data = getData(stack);
        data.tick(level);
        setData(stack, data);

        if (entity instanceof class_1309 livingEntity && (livingEntity.method_6047() == stack || livingEntity.method_6079() == stack)) {
            boolean power = isPowerOn(stack);
            setTransferProgressOld(stack, getTransferProgress(stack));
            setTransferProgress(stack, getTransferProgress(stack) + (power ? 1 : -1));
        }
    }

    @Override
    protected boolean method_7710(@NotNull class_2338 blockPos, class_1937 level, @Nullable class_1657 player, @NotNull class_1799 itemStack, @NotNull class_2680 blockState) {
        var server = level.method_8503();
        if (server != null) {
            var be = level.method_8321(blockPos);
            if (be instanceof BoomboxBlockEntity boomboxBlockEntity) {
                boomboxBlockEntity.setByItem(itemStack);
                boomboxBlockEntity.method_5431();
                super.method_7710(blockPos, level, player, itemStack, blockState);
                return true;
            }
        }
        return super.method_7710(blockPos, level, player, itemStack, blockState);
    }

    public static boolean matches(class_1799 src, class_1799 target) {
        if (src == target)
            return true;
        var uid = getUUID(src);
        return uid != null && uid.equals(getUUID(target));
    }

    public static class_2487 getBoomboxTag(class_1799 stack) {
        if (stack.method_7969() != null)
            return stack.method_7969().method_10562("BoomboxTag");
        return null;
    }

    public static class_2487 getOrCreateBoomboxTag(class_1799 stack) {
        var tag = stack.method_7948();
        if (!tag.contains("BoomboxTag"))
            tag.put("BoomboxTag", new class_2487());
        return tag.getCompound("BoomboxTag");
    }

    public static BoomboxData getData(class_1799 stack) {
        var data = new BoomboxData(new BoomboxData.DataAccess() {
            @Override
            public class_1799 getCassetteTape() {
                return BoomboxItem.getCassetteTape(stack);
            }

            @Override
            public class_1799 getAntenna() {
                return BoomboxItem.getAntenna(stack);
            }

            @Override
            public boolean isPower() {
                return isPowerOn(stack);
            }

            @Override
            public void setPower(boolean power) {
                BoomboxItem.setPowerOn(stack, power);
            }

            @Override
            public IMusicRinger getRinger() {
                var uuid = getUUID(stack);
                var mr = MusicRingManager.getInstance();
                if (uuid != null)
                    return mr.getRinger(uuid);
                return null;
            }

            @Override
            public class_243 getPosition() {
                if (getRinger() == null)
                    return class_243.field_1353;
                return getRinger().getRingerSpatialPosition();
            }

            @Override
            public void setCassetteTape(class_1799 cassette) {
                BoomboxItem.setCassetteTape(stack, cassette);
            }

            @Override
            public void dataUpdate(BoomboxData data) {
                setData(stack, data);
            }
        });
        var tag = getBoomboxTag(stack);
        if (tag != null)
            data.load(tag.getCompound("BoomBoxData"), true, true);
        return data;
    }

    public static void setData(class_1799 stack, BoomboxData data) {
        getOrCreateBoomboxTag(stack).method_10566("BoomBoxData", data.save(new class_2487(), true, true));
    }

    public static boolean isPowerOn(class_1799 itemStack) {
        if (getBoomboxTag(itemStack) != null)
            return getBoomboxTag(itemStack).method_10577("Power");
        return false;
    }

    public static void setPowerOn(class_1799 itemStack, boolean power) {
        getOrCreateBoomboxTag(itemStack).method_10556("Power", power);
    }

    public static int getTransferProgress(class_1799 stack) {
        if (getBoomboxTag(stack) != null)
            return getBoomboxTag(stack).method_10550("Transfer");
        return 0;
    }

    public static void setTransferProgress(class_1799 stack, int num) {
        getOrCreateBoomboxTag(stack).method_10569("Transfer", class_3532.method_15340(num, 0, 10));
    }

    public static int getTransferProgressOld(class_1799 stack) {
        if (getBoomboxTag(stack) != null)
            return getBoomboxTag(stack).method_10550("TransferOld");
        return 0;
    }

    public static void setTransferProgressOld(class_1799 stack, int num) {
        getOrCreateBoomboxTag(stack).method_10569("TransferOld", class_3532.method_15340(num, 0, 10));
    }

    public static float getTransferProgress(class_1799 stack, float partialTicks) {
        return class_3532.method_16439(partialTicks, BoomboxItem.getTransferProgressOld(stack), BoomboxItem.getTransferProgress(stack)) / 10f;
    }

    public static UUID getUUID(class_1799 stack) {
        if (getBoomboxTag(stack) != null && getBoomboxTag(stack).method_10545("Identification"))
            return getBoomboxTag(stack).method_25926("Identification");
        return null;
    }

    public static void setUUID(class_1799 stack, UUID id) {
        getOrCreateBoomboxTag(stack).method_25927("Identification", id);
    }

    public static class_2371<class_1799> getContainItem(class_1799 stack) {
        class_2371<class_1799> stacks = class_2371.method_10213(2, class_1799.field_8037);
        ItemContainer.loadItemList(stack, stacks, "BoomboxItems");
        return stacks;
    }

    public static void setContainItem(class_1799 stack, class_2371<class_1799> stacks) {
        ItemContainer.saveItemList(stack, stacks, "BoomboxItems");
    }

    public static void setCassetteTape(class_1799 stack, class_1799 cassette) {
        var itms = getContainItem(stack);
        itms.set(0, cassette);
        setContainItem(stack, itms);
    }

    public static class_1799 getCassetteTape(class_1799 stack) {
        return getContainItem(stack).get(0);
    }

    public static class_1799 getAntenna(class_1799 stack) {
        return getContainItem(stack).get(1);
    }

    @Override
    public class_2487 onInstruction(class_1799 itemStack, class_3222 player, String name, int num, class_2487 data) {
        return BoomboxItem.getData(itemStack).onInstruction(player, name, num, data);
    }

    public static class_1799 createByBE(BoomboxBlockEntity blockEntity, boolean stopMusic) {
        var itemStack = new class_1799(IMPBlocks.BOOMBOX.get());
        setContainItem(itemStack, blockEntity.getItems());
        setData(itemStack, blockEntity.getBoomboxData());
        var d = getData(itemStack);
        if (stopMusic) {
            d.setPlaying(false);
            d.setMusicPosition(0);
        }
        setData(itemStack, d);
        setPowerOn(itemStack, blockEntity.isPower());
        if (blockEntity.isPower()) {
            setTransferProgress(itemStack, 10);
            setTransferProgressOld(itemStack, 10);
        }
        if (blockEntity.method_16914())
            itemStack.setHoverName(blockEntity.method_5797());
        setUUID(itemStack, UUID.randomUUID());
        return itemStack;
    }

    public static boolean checkDuplication(class_1799 stack, class_1297 entity) {
        var stackId = getUUID(stack);
        if (stackId == null) return false;
        List<class_1799> allItem = new ArrayList<>();

        if (entity instanceof class_1309 livingEntity) {
            for (class_1304 value : class_1304.values()) {
                allItem.add(livingEntity.method_6118(value));
            }
        }
        if (entity instanceof class_1657 player) {
            allItem.addAll(player.method_31548().field_7547);
        }
        for (class_1799 item : allItem) {
            if (item != stack && !item.method_7960() && stackId.equals(getUUID(item)))
                return true;
        }
        return false;
    }
}
