/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.boombox;

import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.BoomboxScreen;
import dev.felnull.imp.client.gui.screen.monitor.boombox.PlayBackBaseBMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;

public class RadioBMonitor
extends PlayBackBaseBMonitor {
    private static final class_2960 BACK_BG_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/boombox/monitor/playback_back.png");
    private static final class_2561 LOADING_STREAM_TEXT = new class_2588("imp.text.streamLoading");
    private static final class_2561 PLAYING_STREAM_TEXT = new class_2588("imp.text.streamPlaying");
    private static final class_2561 NON_PROGRESS_TEXT = new class_2585("--:--/--:--");
    private SmartButton backButton;

    public RadioBMonitor(BoomboxData.MonitorType monitorType, BoomboxScreen screen) {
        super(monitorType, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.backButton = this.addRenderWidget(new SmartButton(this.getStartX() + this.width - 15, this.getStartY() + this.height - 12, 14, 11, (class_2561)new class_2588("gui.back"), n -> this.setMonitor(BoomboxData.MonitorType.RADIO_SELECT)));
        this.backButton.setHideText(true);
        this.backButton.setIcon(MusicManagerMonitor.WIDGETS_TEXTURE, 11, 123, 8, 8);
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtil.drawTexture((class_2960)BACK_BG_TEXTURE, (class_4587)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        class_2561 ptx = LOADING_STREAM_TEXT;
        if (!this.getScreen().isMusicLoading() && this.getScreen().getBoomBoxData().isPlaying()) {
            ptx = PLAYING_STREAM_TEXT;
        } else if (!this.getScreen().getBoomBoxData().isPlaying()) {
            ptx = NON_PROGRESS_TEXT;
        }
        this.drawSmartText(poseStack, ptx, this.getStartX() + 38 - (this.isShortProgressBar() ? 0 : 36), this.getStartY() + 15, -15639282);
    }

    @Override
    public void renderAppearance(class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight, BoomboxData data) {
        super.renderAppearance(poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight, data);
        OERenderUtil.renderTextureSprite((class_2960)BACK_BG_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.002f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        class_2561 ptx = LOADING_STREAM_TEXT;
        if (!data.isLoadingMusic() && data.isPlaying()) {
            ptx = PLAYING_STREAM_TEXT;
        } else if (!data.isPlaying()) {
            ptx = NON_PROGRESS_TEXT;
        }
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        this.renderSmartTextSpriteColorSprite(poseStack, multiBufferSource, ptx, 38.0f - (this.isShortProgressBar(data) ? 0.0f : 36.0f), 17.0f, 0.002f, onPxW, onPxH, monitorHeight, -15639282, i);
        this.renderSmartButtonSprite(poseStack, multiBufferSource, this.width - 15, this.height - 12, 0.002f, 14.0f, 11.0f, i, j, onPxW, onPxH, monitorHeight, MusicManagerMonitor.WIDGETS_TEXTURE, 11, 123, 8, 8, 256, 256);
    }

    @Override
    @NotNull
    protected ImageInfo getPlayBackImage(BoomboxData data) {
        return data.getRadioImage();
    }

    @Override
    @NotNull
    protected String getPlayBackName(BoomboxData data) {
        return data.getRadioName();
    }

    @Override
    @NotNull
    protected String getPlayBackAuthor(BoomboxData data) {
        return data.getRadioAuthor();
    }

    @Override
    @NotNull
    protected MusicSource getPlayBackSource(BoomboxData data) {
        return data.getRadioSource();
    }

    @Override
    protected boolean isShortTipProgressBar() {
        return true;
    }
}

