/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.data;

import dev.felnull.imp.item.CassetteTapeItem;
import dev.felnull.imp.item.IMPItems;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.server.music.MusicManager;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.imp.util.IMPNbtUtil;
import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoomboxData {
    private final Map<UUID, UUID> playerSelectPlaylists = new HashMap<UUID, UUID>();
    private final DataAccess access;
    private MonitorType monitorType = MonitorType.OFF;
    private MonitorType lastMonitorType = MonitorType.OFF;
    private boolean handleRaising = true;
    private boolean lidOpen;
    private int handleRaisedProgressOld = this.getHandleRaisedMax();
    private int handleRaisedProgress = this.getHandleRaisedMax();
    private int lidOpenProgressOld;
    private int lidOpenProgress;
    private int parabolicAntennaProgressOld;
    private int parabolicAntennaProgress;
    private int antennaProgressOld;
    private int antennaProgress;
    private class_1799 oldCassetteTape = class_1799.field_8037;
    private boolean changeCassetteTape;
    private boolean playing;
    private int volume = 150;
    private boolean loop;
    private boolean mute;
    private long musicPosition;
    private boolean loadingMusic;
    private String radioUrl = "";
    private MusicSource radioSource = MusicSource.EMPTY;
    private ImageInfo radioImage = ImageInfo.EMPTY;
    private String radioName = "";
    private String radioAuthor = "";
    private Music selectedMusic;
    private ContinuousType continuousType = ContinuousType.NONE;
    private boolean radioStartFlg;
    private boolean noChangeCassetteTape;

    public BoomboxData(@NotNull DataAccess access) {
        this.access = access;
    }

    public void tick(class_1937 level) {
        this.handleRaisedProgressOld = this.handleRaisedProgress;
        this.lidOpenProgressOld = this.lidOpenProgress;
        this.parabolicAntennaProgressOld = this.parabolicAntennaProgress;
        this.antennaProgressOld = this.antennaProgress;
        this.antennaProgress = this.isUseAntenna() && this.isRadioStream() ? class_3532.method_15340((int)(this.antennaProgress + 1), (int)0, (int)30) : class_3532.method_15340((int)(this.antennaProgress - 1), (int)0, (int)30);
        if (this.handleRaising) {
            if (this.handleRaisedProgress < this.getHandleRaisedMax()) {
                ++this.handleRaisedProgress;
            }
        } else if (this.handleRaisedProgress > 0) {
            --this.handleRaisedProgress;
        }
        if (this.lidOpen) {
            if (this.lidOpenProgress < this.getLidOpenProgressMax()) {
                ++this.lidOpenProgress;
            }
        } else if (this.lidOpenProgress > 0) {
            --this.lidOpenProgress;
        }
        if (this.isPower() && this.isUseAntenna() && this.isAntennaExist() && this.getAntenna().method_31574((class_1792)IMPItems.PARABOLIC_ANTENNA.get())) {
            this.parabolicAntennaProgress += 2;
        }
        if (!level.method_8608()) {
            if (this.getRinger() != null) {
                this.loadingMusic = this.getRinger().isRingerWait();
            }
            if (this.isPower() && this.monitorType == MonitorType.OFF) {
                this.monitorType = MonitorType.PLAYBACK;
            }
            if (!this.isPower() && this.monitorType != MonitorType.OFF) {
                this.monitorType = MonitorType.OFF;
            }
            if (this.monitorType != this.lastMonitorType) {
                this.lastMonitorType = this.monitorType;
                this.setMusicPosition(0L);
                this.setPlaying(false);
            }
            if (!this.canPlay()) {
                this.setMusicPosition(0L);
                this.setPlaying(false);
            }
            if (!this.isRadioRemote()) {
                this.playerSelectPlaylists.clear();
                this.setSelectedMusic(null);
                this.setContinuousType(ContinuousType.NONE);
            }
            if (this.radioStartFlg) {
                this.setRadioStartFlg(false);
                this.setPlaying(true);
            }
            if (this.monitorType == MonitorType.REMOTE_PLAYBACK && this.getSelectedMusic() == null) {
                this.monitorType = MonitorType.REMOTE_PLAYBACK_SELECT;
            }
            if (this.monitorType == MonitorType.RADIO && this.getRadioSource().isEmpty()) {
                this.monitorType = MonitorType.RADIO_SELECT;
            }
            if (this.isRadio() && !this.isAntennaExist() || this.isRadioRemote() && !IMPItemUtil.isRemotePlayBackAntenna(this.getAntenna()) || this.isRadioStream() && IMPItemUtil.isRemotePlayBackAntenna(this.getAntenna())) {
                this.monitorType = MonitorType.PLAYBACK;
            }
            if (!this.isRadioStream()) {
                this.setRadioImage(ImageInfo.EMPTY);
                this.setRadioSource(MusicSource.EMPTY);
                this.setRadioAuthor("");
                this.setRadioName("");
                this.setRadioUrl("");
            }
            if (this.monitorType != MonitorType.RADIO_SELECT) {
                this.setRadioUrl("");
            }
            if (this.changeCassetteTape) {
                if (!this.isLidOpen()) {
                    this.startLidOpen(true, level);
                }
                if (this.getLidOpenProgress() >= this.getLidOpenProgressMax()) {
                    this.changeCassetteTape = false;
                    this.startLidOpen(false, level);
                }
            }
        }
    }

    public boolean canPlay() {
        boolean canPlayFlg = this.monitorType == MonitorType.PLAYBACK && this.isMusicCassetteTapeExist();
        boolean canPlayFlg2 = this.monitorType == MonitorType.RADIO && !this.getRadioSource().isEmpty();
        boolean canPlayFlg3 = this.monitorType == MonitorType.REMOTE_PLAYBACK;
        return canPlayFlg || canPlayFlg2 || canPlayFlg3;
    }

    public class_2487 onInstruction(class_3222 player, String name, int num, class_2487 data) {
        if ("buttons_press".equals(name)) {
            ButtonType type = ButtonType.getByName(data.method_10558("Type"));
            switch (type) {
                case POWER: {
                    this.setPower(!this.isPower());
                    break;
                }
                case LOOP: {
                    this.setLoop(!this.isLoop());
                    break;
                }
                case VOL_DOWN: {
                    if (!this.isPower()) break;
                    this.setVolume(Math.max(this.volume - 10, 0));
                    break;
                }
                case VOL_UP: {
                    if (this.isPower()) {
                        this.setVolume(Math.min(this.volume + 10, 300));
                    }
                    this.setMute(false);
                    break;
                }
                case VOL_MUTE: {
                    this.setMute(!this.isMute());
                    break;
                }
                case VOL_MAX: {
                    if (this.isPower()) {
                        this.setVolume(300);
                    }
                    this.setMute(false);
                    break;
                }
                case RADIO: {
                    if (this.isRadio()) {
                        this.setMonitorType(MonitorType.PLAYBACK);
                        break;
                    }
                    this.setPower(true);
                    this.setRadioMode();
                    break;
                }
                case START: {
                    if (!this.isMusicCassetteTapeExist() && !this.isRadio()) break;
                    this.setPower(true);
                    this.setPlaying(true);
                    break;
                }
                case STOP: {
                    if (!this.isPower()) break;
                    this.setPlaying(false);
                    this.setMusicPosition(0L);
                    break;
                }
                case PAUSE: {
                    if (!this.isPower()) break;
                    this.setPlaying(false);
                    if (!this.isRadioStream()) break;
                    this.setMusicPosition(0L);
                }
            }
            return null;
        }
        if ("set_volume".equals(name)) {
            if (this.isPower()) {
                this.setVolume(data.method_10550("volume"));
            }
            return null;
        }
        if ("set_playing".equals(name)) {
            if (this.isPower()) {
                boolean pl = data.method_10577("playing");
                this.setPlaying(pl);
                if (!pl) {
                    this.setMusicPosition(0L);
                }
            }
            return null;
        }
        if ("set_pause".equals(name)) {
            if (this.isPower()) {
                this.setPlaying(false);
            }
            return null;
        }
        if ("set_loop".equals(name)) {
            if (this.isPower()) {
                this.setLoop(data.method_10577("loop"));
            }
            return null;
        }
        if ("restat_and_set_position".equals(name)) {
            if (this.isPower()) {
                this.setMusicPositionAndRestart(data.method_10537("position"));
            }
            return null;
        }
        if ("set_radio_url".equals(name)) {
            if (this.isPower()) {
                this.setRadioUrl(data.method_10558("url"));
            }
            return null;
        }
        if ("set_monitor".equals(name)) {
            if (this.isPower()) {
                MonitorType m = MonitorType.getByName(data.method_10558("name"));
                this.setMonitorType(m);
                if (m == MonitorType.RADIO && this.getRadioSource() != null && !this.getRadioSource().isEmpty() || m == MonitorType.REMOTE_PLAYBACK && this.getSelectedMusic() != null && !this.getSelectedMusic().getSource().isEmpty()) {
                    this.setRadioStartFlg(true);
                }
            }
            return null;
        }
        if ("set_radio_source".equals(name)) {
            if (this.isPower()) {
                this.setRadioSource((MusicSource)OENbtUtil.readSerializable((class_2487)data, (String)"source", (ITAGSerializable)new MusicSource()));
            }
            return null;
        }
        if ("set_radio_image".equals(name)) {
            if (this.isPower()) {
                this.setRadioImage((ImageInfo)OENbtUtil.readSerializable((class_2487)data, (String)"image", (ITAGSerializable)new ImageInfo()));
            }
            return null;
        }
        if ("set_radio_name".equals(name)) {
            if (this.isPower()) {
                this.setRadioName(data.method_10558("name"));
            }
            return null;
        }
        if ("set_radio_author".equals(name)) {
            if (this.isPower()) {
                this.setRadioAuthor(data.method_10558("author"));
            }
            return null;
        }
        if ("set_selected_play_list".equals(name)) {
            if (this.isPower() && this.isRadioRemote()) {
                if (data.method_10545("pl")) {
                    UUID uuid = data.method_25926("pl");
                    MusicPlayList pl = MusicManager.getInstance().getSaveData().getPlayLists().get(uuid);
                    if (pl != null && pl.getAuthority().getAuthorityType(player.method_7334().getId()).isMoreReadOnly()) {
                        this.setSelectedPlayList(player, uuid);
                    }
                } else {
                    this.setSelectedPlayList(player, null);
                }
            }
            return null;
        }
        if ("set_selected_music".equals(name)) {
            if (this.isPower() && this.isRadioRemote()) {
                if (data.method_10545("m")) {
                    MusicPlayList pl;
                    UUID uuid = data.method_25926("m");
                    Music m = MusicManager.getInstance().getSaveData().getMusics().get(uuid);
                    if (m != null && (pl = MusicManager.getInstance().getPlaylistByMusic(m.getUuid())) != null && pl.getAuthority().getAuthorityType(player.method_7334().getId()).isMoreReadOnly()) {
                        this.setSelectedMusic(m);
                    }
                } else {
                    this.setSelectedMusic(null);
                }
            }
            return null;
        }
        if ("set_continuous_type".equals(name)) {
            if (this.isPower() && this.isRadioRemote()) {
                this.setContinuousType(ContinuousType.getByName(data.method_10558("type")));
            }
            return null;
        }
        return null;
    }

    public void onCassetteTapeChange(class_1799 newItem, class_1799 oldItem) {
        this.oldCassetteTape = oldItem.method_7972();
        if (!this.isRadio()) {
            this.setMusicPosition(0L);
            this.setPlaying(false);
        }
        if (!this.getCassetteTape().method_7960() || !this.isLidOpen()) {
            this.changeCassetteTape = true;
        }
        this.update();
    }

    public class_2487 save(class_2487 tag, boolean absolutely, boolean sync) {
        tag.method_10582("MonitorType", this.monitorType.getName());
        tag.method_10556("HandleRaising", this.handleRaising);
        tag.method_10556("LidOpen", this.lidOpen);
        tag.method_10556("Playing", this.playing);
        tag.method_10569("Volume", this.volume);
        tag.method_10556("Loop", this.loop);
        tag.method_10556("Mute", this.mute);
        tag.method_10544("RingerPosition", this.musicPosition);
        tag.method_10582("RadioUrl", this.radioUrl);
        OENbtUtil.writeSerializable((class_2487)tag, (String)"RadioSource", (ITAGSerializable)this.radioSource);
        OENbtUtil.writeSerializable((class_2487)tag, (String)"RadioImage", (ITAGSerializable)this.radioImage);
        tag.method_10582("RadioName", this.radioName);
        tag.method_10582("RadioAuthor", this.radioAuthor);
        IMPNbtUtil.writeUUIDMap(tag, "PlayerSelectPlaylists", this.playerSelectPlaylists);
        if (this.selectedMusic != null) {
            OENbtUtil.writeSerializable((class_2487)tag, (String)"SelectedMusic", (ITAGSerializable)this.selectedMusic);
        }
        tag.method_10582("ContinuousType", this.continuousType.getName());
        if (absolutely) {
            tag.method_10569("HandleRaisedProgressOld", this.handleRaisedProgressOld);
            tag.method_10569("HandleRaisedProgress", this.handleRaisedProgress);
            tag.method_10569("LidOpenProgressOld", this.lidOpenProgressOld);
            tag.method_10569("LidOpenProgress", this.lidOpenProgress);
            tag.method_10569("ParabolicAntennaProgressOld", this.parabolicAntennaProgressOld);
            tag.method_10569("ParabolicAntennaProgress", this.parabolicAntennaProgress);
            tag.method_10569("AntennaProgressOld", this.antennaProgressOld);
            tag.method_10569("AntennaProgress", this.antennaProgress);
            tag.method_10582("LastMonitorType", this.lastMonitorType.getName());
            tag.method_10556("NoChangeCassetteTape", this.noChangeCassetteTape);
        }
        if (absolutely || sync) {
            tag.method_10556("ChangeCassetteTape", this.changeCassetteTape);
            tag.method_10566("OldCassetteTape", (class_2520)this.oldCassetteTape.method_7953(new class_2487()));
            tag.method_10556("LoadingMusic", this.loadingMusic);
            tag.method_10556("RadioStartFlg", this.radioStartFlg);
        }
        return tag;
    }

    public void load(class_2487 tag, boolean absolutely, boolean sync) {
        this.monitorType = MonitorType.getByName(tag.method_10558("MonitorType"));
        this.handleRaising = tag.method_10577("HandleRaising");
        this.lidOpen = tag.method_10577("LidOpen");
        this.playing = tag.method_10577("Playing");
        if (tag.method_10545("Volume")) {
            this.volume = tag.method_10550("Volume");
        }
        this.loop = tag.method_10577("Loop");
        this.mute = tag.method_10577("Mute");
        this.musicPosition = tag.method_10537("RingerPosition");
        this.radioUrl = tag.method_10558("RadioUrl");
        this.radioSource = (MusicSource)OENbtUtil.readSerializable((class_2487)tag, (String)"RadioSource", (ITAGSerializable)new MusicSource());
        this.radioImage = (ImageInfo)OENbtUtil.readSerializable((class_2487)tag, (String)"RadioImage", (ITAGSerializable)new ImageInfo());
        this.radioName = tag.method_10558("RadioName");
        this.radioAuthor = tag.method_10558("RadioAuthor");
        IMPNbtUtil.readUUIDMap(tag, "PlayerSelectPlaylists", this.playerSelectPlaylists);
        this.continuousType = ContinuousType.getByName(tag.method_10558("ContinuousType"));
        if (tag.method_10545("SelectedMusic")) {
            this.selectedMusic = (Music)OENbtUtil.readSerializable((class_2487)tag, (String)"SelectedMusic", (ITAGSerializable)new Music());
        }
        if (absolutely) {
            this.handleRaisedProgressOld = tag.method_10550("HandleRaisedProgressOld");
            this.handleRaisedProgress = tag.method_10550("HandleRaisedProgress");
            this.lidOpenProgressOld = tag.method_10550("LidOpenProgressOld");
            this.lidOpenProgress = tag.method_10550("LidOpenProgress");
            this.parabolicAntennaProgressOld = tag.method_10550("ParabolicAntennaProgressOld");
            this.parabolicAntennaProgress = tag.method_10550("ParabolicAntennaProgress");
            this.antennaProgressOld = tag.method_10550("AntennaProgressOld");
            this.antennaProgress = tag.method_10550("AntennaProgress");
            this.lastMonitorType = MonitorType.getByName(tag.method_10558("LastMonitorType"));
            this.noChangeCassetteTape = tag.method_10577("NoChangeCassetteTape");
        }
        if (absolutely || sync) {
            this.changeCassetteTape = tag.method_10577("ChangeCassetteTape");
            this.oldCassetteTape = class_1799.method_7915((class_2487)tag.method_10562("OldCassetteTape"));
            this.loadingMusic = tag.method_10577("LoadingMusic");
            this.radioStartFlg = tag.method_10577("RadioStartFlg");
        }
        if (!sync) {
            if (this.handleRaising) {
                this.handleRaisedProgress = this.getHandleRaisedMax();
            }
            if (this.lidOpen) {
                this.lidOpenProgress = this.getLidOpenProgressMax();
            }
        }
    }

    public void setNoChangeCassetteTape(boolean noChangeCassetteTape) {
        this.noChangeCassetteTape = noChangeCassetteTape;
    }

    public boolean isNoChangeCassetteTape() {
        return this.noChangeCassetteTape;
    }

    public void setRadioSource(MusicSource radioSource) {
        this.radioSource = radioSource;
        this.update();
    }

    public void setRadioImage(ImageInfo radioImage) {
        this.radioImage = radioImage;
        this.update();
    }

    public MusicSource getRadioSource() {
        return this.radioSource;
    }

    public ImageInfo getRadioImage() {
        return this.radioImage;
    }

    public void setRadioUrl(String radioUrl) {
        this.radioUrl = radioUrl;
        this.update();
    }

    public void setRadioName(String radioName) {
        this.radioName = radioName;
        this.update();
    }

    public void setRadioAuthor(String radioAuthor) {
        this.radioAuthor = radioAuthor;
        this.update();
    }

    public String getRadioName() {
        return this.radioName;
    }

    public String getRadioAuthor() {
        return this.radioAuthor;
    }

    public String getRadioUrl() {
        return this.radioUrl;
    }

    public boolean isLoadingMusic() {
        return this.loadingMusic;
    }

    public long getMusicPosition() {
        return this.musicPosition;
    }

    public void setMusicPosition(long position) {
        class_1799 nc;
        MusicSource m;
        this.musicPosition = position;
        if (this.isMusicCassetteTapeExist() && !this.isRadioRemote() && (m = this.getMusicSource()) != null && !class_1799.method_7973((class_1799)(nc = CassetteTapeItem.setTapePercentage(this.getCassetteTape().method_7972(), (float)position / (float)m.getDuration())), (class_1799)this.getCassetteTape())) {
            this.setCassetteTape(nc);
        }
        this.update();
    }

    public void setCassetteTape(class_1799 stack) {
        this.access.setCassetteTape(stack);
    }

    public MusicSource getMusicSource() {
        Music m;
        if (this.isMusicCassetteTapeExist() && (m = CassetteTapeItem.getMusic(this.getCassetteTape())) != null) {
            return m.getSource();
        }
        return null;
    }

    public void setMusicPositionAndRestart(long position) {
        this.setMusicPosition(position);
        if (this.getRinger() != null) {
            this.getRinger().ringerRestart();
            this.update();
        }
    }

    public float getRawVolume() {
        return (float)this.getVolume() / 300.0f;
    }

    public void setRadioMode() {
        if (this.isAntennaExist()) {
            if (IMPItemUtil.isRemotePlayBackAntenna(this.getAntenna())) {
                this.setMonitorType(MonitorType.REMOTE_PLAYBACK_SELECT);
            } else {
                this.setMonitorType(MonitorType.RADIO_SELECT);
            }
        }
        this.update();
    }

    public boolean isRadio() {
        return this.isRadioStream() || this.isRadioRemote();
    }

    public boolean isRadioStream() {
        return this.monitorType == MonitorType.RADIO_SELECT || this.monitorType == MonitorType.RADIO;
    }

    public boolean isRadioRemote() {
        return this.monitorType == MonitorType.REMOTE_PLAYBACK || this.monitorType == MonitorType.REMOTE_PLAYBACK_SELECT;
    }

    public void setPower(boolean power) {
        this.access.setPower(power);
    }

    public boolean isChangeCassetteTape() {
        return this.changeCassetteTape;
    }

    private boolean isMusicCassetteTapeExist() {
        return this.isCassetteTapeExist() && CassetteTapeItem.getMusic(this.getCassetteTape()) != null;
    }

    private boolean isCassetteTapeExist() {
        return IMPItemUtil.isCassetteTape(this.getCassetteTape());
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        if (this.canPlay() || !playing) {
            this.playing = playing;
            this.update();
        }
    }

    public class_1799 getOldCassetteTape() {
        return this.oldCassetteTape;
    }

    public void setMonitorType(MonitorType monitorType) {
        this.monitorType = monitorType;
        this.update();
    }

    public MonitorType getMonitorType() {
        return this.monitorType;
    }

    public boolean isUseAntenna() {
        return this.isRadio();
    }

    public boolean isAntennaExist() {
        return IMPItemUtil.isAntenna(this.getAntenna());
    }

    @Nullable
    public IMusicRinger getRinger() {
        return this.access.getRinger();
    }

    public boolean cycleLidOpen(class_1937 level) {
        boolean flg2;
        boolean flg = this.lidOpenProgress >= this.getLidOpenProgressMax();
        boolean bl = flg2 = this.lidOpenProgress <= 0;
        if (!flg && !flg2) {
            return false;
        }
        if (flg) {
            this.startLidOpen(false, level);
        }
        if (flg2) {
            this.startLidOpen(true, level);
        }
        return true;
    }

    public void setContinuousType(ContinuousType continuousType) {
        this.continuousType = continuousType;
        this.update();
    }

    public ContinuousType getContinuousType() {
        return this.continuousType;
    }

    public void setSelectedMusic(Music selectedMusic) {
        this.selectedMusic = selectedMusic;
        this.update();
    }

    public Music getSelectedMusic() {
        return this.selectedMusic;
    }

    @Nullable
    public Music getCassetteTapeMusic() {
        if (IMPItemUtil.isCassetteTape(this.getCassetteTape())) {
            return CassetteTapeItem.getMusic(this.getCassetteTape());
        }
        return null;
    }

    public void startLidOpen(boolean open, class_1937 level) {
        this.setLidOpen(open);
        class_243 pos = this.getPosition();
        level.method_8465(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), this.isLidOpen() ? class_3417.field_14664 : class_3417.field_14541, class_3419.field_15245, 0.5f, 0.4f / (level.method_8409().nextFloat() * 0.4f + 0.8f));
    }

    public boolean isLidOpen() {
        return this.lidOpen;
    }

    public void setLidOpen(boolean lidOpen) {
        this.lidOpen = lidOpen;
        this.update();
    }

    public void setSelectedPlayList(@NotNull class_3222 player, UUID selectedPlayList) {
        if (selectedPlayList != null) {
            this.playerSelectPlaylists.put(player.method_7334().getId(), selectedPlayList);
        } else {
            this.playerSelectPlaylists.remove(player.method_7334().getId());
        }
        this.update();
    }

    @Nullable
    public UUID getSelectedPlayList(@NotNull class_1657 player) {
        return this.playerSelectPlaylists.get(player.method_7334().getId());
    }

    public class_1799 getCassetteTape() {
        return this.access.getCassetteTape();
    }

    public class_1799 getAntenna() {
        return this.access.getAntenna();
    }

    public int getLidOpenProgressMax() {
        return 10;
    }

    public int getHandleRaisedProgress() {
        return this.handleRaisedProgress;
    }

    public float getHandleRaisedProgress(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.handleRaisedProgressOld, (float)this.handleRaisedProgress);
    }

    public int getParabolicAntennaProgress() {
        return this.parabolicAntennaProgress;
    }

    public float getParabolicAntennaProgress(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.parabolicAntennaProgressOld, (float)this.parabolicAntennaProgress);
    }

    public int getLidOpenProgress() {
        return this.lidOpenProgress;
    }

    public float getLidOpenProgress(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.lidOpenProgressOld, (float)this.lidOpenProgress);
    }

    public boolean isLoop() {
        return this.loop;
    }

    public boolean isMute() {
        return this.mute;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
        this.update();
    }

    public void setMute(boolean mute) {
        this.mute = mute;
        this.update();
    }

    public void setVolume(int volume) {
        this.volume = volume;
        this.update();
    }

    public int getVolume() {
        return this.volume;
    }

    public int getAntennaProgress() {
        return this.antennaProgress;
    }

    public float getAntennaProgress(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.antennaProgressOld, (float)this.antennaProgress);
    }

    public boolean isHandleRaising() {
        return this.handleRaising;
    }

    public int getHandleRaisedMax() {
        return 10;
    }

    public boolean cycleRaisedHandle() {
        boolean flg2;
        boolean flg = this.getHandleRaisedProgress() >= this.getHandleRaisedMax();
        boolean bl = flg2 = this.getHandleRaisedProgress() <= 0;
        if (!flg && !flg2) {
            return false;
        }
        if (flg) {
            this.setHandleRaising(false);
        }
        if (flg2) {
            this.setHandleRaising(true);
        }
        return true;
    }

    public void setHandleRaising(boolean handleRaising) {
        this.handleRaising = handleRaising;
        this.update();
    }

    public void setHandleRaisedProgressOld(int handleRaisedProgressOld) {
        this.handleRaisedProgressOld = handleRaisedProgressOld;
    }

    public int getHandleRaisedProgressOld() {
        return this.handleRaisedProgressOld;
    }

    public void setHandleRaisedProgress(int handleRaisedProgress) {
        this.handleRaisedProgress = handleRaisedProgress;
    }

    public void setAntennaProgressOld(int antennaProgressOld) {
        this.antennaProgressOld = antennaProgressOld;
    }

    public boolean isPower() {
        return this.access.isPower();
    }

    public class_243 getPosition() {
        return this.access.getPosition();
    }

    public void update() {
        this.access.dataUpdate(this);
    }

    public void setRadioStartFlg(boolean radioStartFlg) {
        this.radioStartFlg = radioStartFlg;
        this.update();
    }

    public Buttons getButtons() {
        return new Buttons(this.isRadio(), this.isPlaying(), !this.isPlaying() && this.getMusicPosition() > 0L, this.isLoop(), this.isMute(), !this.isMute() && this.volume >= 300);
    }

    public static enum MonitorType {
        OFF("off"),
        PLAYBACK("playback"),
        REMOTE_PLAYBACK("remote_playback"),
        REMOTE_PLAYBACK_SELECT("remote_playback_select"),
        RADIO("radio"),
        RADIO_SELECT("radio_select");

        private final String name;

        private MonitorType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static MonitorType getByName(String name) {
            for (MonitorType value : MonitorType.values()) {
                if (!value.getName().equals(name)) continue;
                return value;
            }
            return OFF;
        }
    }

    public static enum ContinuousType {
        NONE("none"),
        ORDER("order"),
        RANDOM("random");

        private final String name;
        private final class_2561 component;

        private ContinuousType(String name) {
            this.name = name;
            this.component = new class_2588("imp.text.continuous." + name);
        }

        public class_2561 getComponent() {
            return this.component;
        }

        public String getName() {
            return this.name;
        }

        public static ContinuousType getByName(String name) {
            for (ContinuousType value : ContinuousType.values()) {
                if (!value.getName().equals(name)) continue;
                return value;
            }
            return NONE;
        }
    }

    public static interface DataAccess {
        public class_1799 getCassetteTape();

        public class_1799 getAntenna();

        public boolean isPower();

        public void setPower(boolean var1);

        public IMusicRinger getRinger();

        public class_243 getPosition();

        public void setCassetteTape(class_1799 var1);

        public void dataUpdate(BoomboxData var1);
    }

    public static enum ButtonType {
        NONE("none", n -> false),
        POWER("power", n -> false),
        RADIO("radio", n -> n.radio()),
        START("start", n -> n.start()),
        PAUSE("pause", n -> n.pause()),
        STOP("stop", n -> false),
        LOOP("loop", n -> n.loop()),
        VOL_DOWN("volDown", n -> false),
        VOL_UP("volUp", n -> false),
        VOL_MUTE("volMute", n -> n.volMute()),
        VOL_MAX("volMax", n -> n.volMax());

        private final String name;
        private final class_2561 component;
        private final Function<Buttons, Boolean> getter;

        private ButtonType(String name, Function<Buttons, Boolean> getter) {
            this.name = name;
            this.component = new class_2588("imp.button.boombox." + name);
            this.getter = getter;
        }

        public String getName() {
            return this.name;
        }

        public class_2561 getComponent() {
            return this.component;
        }

        public boolean getState(Buttons buttons) {
            return this.getter.apply(buttons);
        }

        public static ButtonType getByName(String name) {
            for (ButtonType value : ButtonType.values()) {
                if (!value.getName().equals(name)) continue;
                return value;
            }
            return NONE;
        }
    }

    public record Buttons(boolean radio, boolean start, boolean pause, boolean loop, boolean volMute, boolean volMax) {
        public static final Buttons EMPTY = new Buttons(false, false, false, false, false, false);
    }
}

