/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerDescriptor;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;

public class MediaContainerDetectionResult {
    private static final MediaContainerDetectionResult UNKNOWN_FORMAT = new MediaContainerDetectionResult(null, null, null, null, null);
    private final AudioTrackInfo trackInfo;
    private final MediaContainerProbe containerProbe;
    private final String probeSettings;
    private final AudioReference reference;
    private final String unsupportedReason;

    private MediaContainerDetectionResult(AudioTrackInfo trackInfo, MediaContainerProbe containerProbe, String probeSettings, AudioReference reference, String unsupportedReason) {
        this.trackInfo = trackInfo;
        this.containerProbe = containerProbe;
        this.probeSettings = probeSettings;
        this.reference = reference;
        this.unsupportedReason = unsupportedReason;
    }

    public static MediaContainerDetectionResult unknownFormat() {
        return UNKNOWN_FORMAT;
    }

    public static MediaContainerDetectionResult unsupportedFormat(MediaContainerProbe probe, String reason) {
        return new MediaContainerDetectionResult(null, probe, null, null, reason);
    }

    public static MediaContainerDetectionResult refer(MediaContainerProbe probe, AudioReference reference) {
        return new MediaContainerDetectionResult(null, probe, null, reference, null);
    }

    public static MediaContainerDetectionResult supportedFormat(MediaContainerProbe probe, String settings, AudioTrackInfo trackInfo) {
        return new MediaContainerDetectionResult(trackInfo, probe, settings, null, null);
    }

    public boolean isContainerDetected() {
        return this.containerProbe != null;
    }

    public MediaContainerDescriptor getContainerDescriptor() {
        return new MediaContainerDescriptor(this.containerProbe, this.probeSettings);
    }

    public boolean isSupportedFile() {
        return this.isContainerDetected() && this.unsupportedReason == null;
    }

    public String getUnsupportedReason() {
        return this.unsupportedReason;
    }

    public AudioTrackInfo getTrackInfo() {
        return this.trackInfo;
    }

    public boolean isReference() {
        return this.reference != null;
    }

    public AudioReference getReference() {
        return this.reference;
    }
}

