/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.fragmented;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackConsumer;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegFileTrackProvider;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegReader;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegSectionInfo;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegVersionedSectionInfo;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.fragmented.MpegGlobalSeekInfo;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.fragmented.MpegSegmentEntry;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.fragmented.MpegTrackFragmentHeader;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.DetachedByteChannel;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.concurrent.atomic.AtomicReference;

public class MpegFragmentedFileTrackProvider
implements MpegFileTrackProvider {
    private final MpegReader reader;
    private final MpegSectionInfo root;
    private MpegTrackConsumer consumer;
    private boolean isFragmented;
    private long totalDuration;
    private MpegGlobalSeekInfo globalSeekInfo;
    private boolean seeking;
    private long minimumTimecode;

    public MpegFragmentedFileTrackProvider(MpegReader reader, MpegSectionInfo root) {
        this.reader = reader;
        this.root = root;
    }

    @Override
    public boolean initialise(MpegTrackConsumer consumer) {
        if (!this.isFragmented) {
            return false;
        }
        this.consumer = consumer;
        return true;
    }

    @Override
    public void provideFrames() throws InterruptedException {
        try (DetachedByteChannel channel = new DetachedByteChannel(Channels.newChannel(this.reader.seek));){
            MpegSectionInfo moof;
            while ((moof = this.reader.nextChild(this.root)) != null) {
                if (!"moof".equals(moof.type)) {
                    this.reader.skip(moof);
                    continue;
                }
                MpegTrackFragmentHeader fragment = this.parseTrackMovieFragment(moof, this.consumer.getTrack().trackId);
                MpegSectionInfo mdat = this.reader.nextChild(this.root);
                long timecode = fragment.baseTimecode;
                this.reader.seek.seek(moof.offset + (long)fragment.dataOffset);
                for (int i = 0; i < fragment.sampleSizes.length; ++i) {
                    this.handleSeeking(this.consumer, timecode);
                    this.consumer.consume(channel, fragment.sampleSizes[i]);
                }
                this.reader.skip(mdat);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void seekToTimecode(long timecode) {
        int segmentIndex;
        if (this.globalSeekInfo == null) {
            return;
        }
        this.minimumTimecode = timecode * (long)this.globalSeekInfo.timescale / 1000L;
        this.seeking = true;
        for (segmentIndex = 0; segmentIndex < this.globalSeekInfo.entries.length - 1 && this.globalSeekInfo.timeOffsets[segmentIndex + 1] <= this.minimumTimecode; ++segmentIndex) {
        }
        try {
            this.reader.seek.seek(this.globalSeekInfo.fileOffsets[segmentIndex]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getDuration() {
        if (this.globalSeekInfo == null) {
            return Long.MAX_VALUE;
        }
        return this.totalDuration * 1000L / (long)this.globalSeekInfo.timescale;
    }

    public void parseMovieExtended(MpegSectionInfo mvex) throws IOException {
        this.reader.in(mvex).handleVersioned("trex", trex -> {
            this.isFragmented = true;
        }).run();
    }

    public void parseSegmentIndex(MpegVersionedSectionInfo sbix) throws IOException {
        this.reader.data.readInt();
        int timescale = this.reader.data.readInt();
        if (sbix.version == 0) {
            this.reader.data.readInt();
            this.reader.data.readInt();
        } else {
            this.reader.data.readLong();
            this.reader.data.readLong();
        }
        this.reader.data.readShort();
        MpegSegmentEntry[] entries = new MpegSegmentEntry[this.reader.data.readUnsignedShort()];
        for (int i = 0; i < entries.length; ++i) {
            int typeAndSize = this.reader.data.readInt();
            int duration = this.reader.data.readInt();
            this.reader.data.readInt();
            entries[i] = new MpegSegmentEntry(typeAndSize >>> 31, typeAndSize & Integer.MAX_VALUE, duration);
            this.totalDuration += (long)duration;
        }
        this.globalSeekInfo = new MpegGlobalSeekInfo(timescale, sbix.offset + sbix.length, entries);
    }

    private void handleSeeking(MpegTrackConsumer consumer, long timecode) {
        if (this.seeking) {
            consumer.seekPerformed(this.minimumTimecode * 1000L / (long)this.globalSeekInfo.timescale, timecode * 1000L / (long)this.globalSeekInfo.timescale);
            this.seeking = false;
        }
    }

    private MpegTrackFragmentHeader parseTrackMovieFragment(MpegSectionInfo moof, int trackId) throws IOException {
        AtomicReference header = new AtomicReference();
        this.reader.in(moof).handle("traf", traf -> {
            MpegTrackFragmentHeader.Builder builder = new MpegTrackFragmentHeader.Builder();
            this.reader.in(traf).handleVersioned("tfhd", tfhd -> this.parseTrackFragmentHeader(tfhd, builder)).handleVersioned("tfdt", tfdt -> builder.setBaseTimecode(tfdt.version == 1 ? this.reader.data.readLong() : (long)this.reader.data.readInt())).handleVersioned("trun", trun -> {
                if (builder.getTrackId() == trackId) {
                    this.parseTrackRunInfo(trun, builder);
                }
            }).run();
            if (builder.getTrackId() == trackId) {
                header.set(builder.build());
            }
        }).run();
        return (MpegTrackFragmentHeader)header.get();
    }

    private void parseTrackFragmentHeader(MpegVersionedSectionInfo tfhd, MpegTrackFragmentHeader.Builder builder) throws IOException {
        builder.setTrackId(this.reader.data.readInt());
        if ((tfhd.flags & 0x10) != 0) {
            if ((tfhd.flags & 1) != 0) {
                this.reader.data.readLong();
            }
            if ((tfhd.flags & 2) != 0) {
                this.reader.data.readInt();
            }
            if ((tfhd.flags & 8) != 0) {
                this.reader.data.readInt();
            }
            builder.setDefaultSampleSize(this.reader.data.readInt());
        }
    }

    private void parseTrackRunInfo(MpegVersionedSectionInfo trun, MpegTrackFragmentHeader.Builder builder) throws IOException {
        int sampleCount = this.reader.data.readInt();
        builder.setDataOffset((trun.flags & 1) != 0 ? this.reader.data.readInt() : -1);
        if ((trun.flags & 4) != 0) {
            this.reader.data.skipBytes(4);
        }
        boolean hasDurations = (trun.flags & 0x100) != 0;
        boolean hasSizes = (trun.flags & 0x200) != 0;
        builder.createSampleArrays(hasDurations, hasSizes, sampleCount);
        for (int i = 0; i < sampleCount; ++i) {
            if (hasDurations) {
                builder.setDuration(i, this.reader.data.readInt());
            }
            if (hasSizes) {
                builder.setSize(i, this.reader.data.readInt());
            }
            if ((trun.flags & 0x400) != 0) {
                this.reader.data.skipBytes(4);
            }
            if ((trun.flags & 0x800) == 0) continue;
            this.reader.data.skipBytes(4);
        }
    }
}

