/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.playlists;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.libs.org.slf4j.Logger;
import dev.felnull.imp.libs.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlainPlaylistContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(PlainPlaylistContainerProbe.class);
    private static final Pattern linkPattern = Pattern.compile("^(?:https?|icy)://.*");

    @Override
    public String getName() {
        return "plain";
    }

    @Override
    public boolean matchesHints(MediaContainerHints hints) {
        return false;
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        if (!MediaContainerDetection.matchNextBytesAsRegex(inputStream, 1000, linkPattern, StandardCharsets.UTF_8)) {
            return null;
        }
        log.debug("Track {} is a plain playlist file.", (Object)reference.identifier);
        return this.loadFromLines(DataFormatTools.streamToLines(inputStream, StandardCharsets.UTF_8));
    }

    private MediaContainerDetectionResult loadFromLines(String[] lines) {
        for (String line : lines) {
            Matcher matcher = linkPattern.matcher(line);
            if (!matcher.matches()) continue;
            return MediaContainerDetectionResult.refer(this, new AudioReference(matcher.group(0), null));
        }
        return MediaContainerDetectionResult.unsupportedFormat(this, "The playlist file contains no links.");
    }

    @Override
    public AudioTrack createTrack(String parameters, AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        throw new UnsupportedOperationException();
    }
}

