/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.format.StandardAudioDataFormats;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.playback.AllocatingAudioFrameBuffer;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameBufferFactory;

public class AudioConfiguration {
    public static final int OPUS_QUALITY_MAX = 10;
    private volatile ResamplingQuality resamplingQuality = ResamplingQuality.LOW;
    private volatile int opusEncodingQuality = 10;
    private volatile AudioDataFormat outputFormat = StandardAudioDataFormats.DISCORD_OPUS;
    private volatile boolean filterHotSwapEnabled = false;
    private volatile AudioFrameBufferFactory frameBufferFactory = AllocatingAudioFrameBuffer::new;

    public ResamplingQuality getResamplingQuality() {
        return this.resamplingQuality;
    }

    public void setResamplingQuality(ResamplingQuality resamplingQuality) {
        this.resamplingQuality = resamplingQuality;
    }

    public int getOpusEncodingQuality() {
        return this.opusEncodingQuality;
    }

    public void setOpusEncodingQuality(int opusEncodingQuality) {
        this.opusEncodingQuality = Math.max(0, Math.min(opusEncodingQuality, 10));
    }

    public AudioDataFormat getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(AudioDataFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public boolean isFilterHotSwapEnabled() {
        return this.filterHotSwapEnabled;
    }

    public void setFilterHotSwapEnabled(boolean filterHotSwapEnabled) {
        this.filterHotSwapEnabled = filterHotSwapEnabled;
    }

    public AudioFrameBufferFactory getFrameBufferFactory() {
        return this.frameBufferFactory;
    }

    public void setFrameBufferFactory(AudioFrameBufferFactory frameBufferFactory) {
        this.frameBufferFactory = frameBufferFactory;
    }

    public AudioConfiguration copy() {
        AudioConfiguration copy = new AudioConfiguration();
        copy.setResamplingQuality(this.resamplingQuality);
        copy.setOpusEncodingQuality(this.opusEncodingQuality);
        copy.setOutputFormat(this.outputFormat);
        copy.setFilterHotSwapEnabled(this.filterHotSwapEnabled);
        copy.setFrameBufferFactory(this.frameBufferFactory);
        return copy;
    }

    public static enum ResamplingQuality {
        HIGH,
        MEDIUM,
        LOW;

    }
}

