/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.soundcloud;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudHtmlDataLoader;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.libs.org.apache.http.client.methods.CloseableHttpResponse;
import dev.felnull.imp.libs.org.apache.http.client.methods.HttpGet;
import dev.felnull.imp.libs.org.apache.http.util.EntityUtils;
import dev.felnull.imp.libs.org.slf4j.Logger;
import dev.felnull.imp.libs.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class DefaultSoundCloudHtmlDataLoader
implements SoundCloudHtmlDataLoader {
    private static final Logger log = LoggerFactory.getLogger(DefaultSoundCloudHtmlDataLoader.class);
    private static final DataFormatTools.TextRange[] JSON_RANGES = new DataFormatTools.TextRange[]{new DataFormatTools.TextRange("catch(e){}})},", ");</script>"), new DataFormatTools.TextRange("){}})},", ");</script>")};

    @Override
    public JsonBrowser load(HttpInterface httpInterface, String url) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(url));){
            if (response.getStatusLine().getStatusCode() == 404) {
                JsonBrowser jsonBrowser = JsonBrowser.NULL_BROWSER;
                return jsonBrowser;
            }
            HttpClientTools.assertSuccessWithContent(response, "video page response");
            String html = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            String rootData = DataFormatTools.extractBetween(html, JSON_RANGES);
            if (rootData == null) {
                throw new FriendlyException("This url does not appear to be a playable track.", FriendlyException.Severity.SUSPICIOUS, ExceptionTools.throwWithDebugInfo(log, null, "No track JSON found", "html", html));
            }
            JsonBrowser jsonBrowser = JsonBrowser.parse(rootData);
            return jsonBrowser;
        }
    }
}

