/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io;

import java.io.IOException;
import java.io.OutputStream;

public class BitStreamWriter {
    private final OutputStream stream;
    private int currentByte;
    private int bitsUnused;

    public BitStreamWriter(OutputStream stream) {
        this.stream = stream;
        this.bitsUnused = 8;
    }

    public void write(long value, int bits) throws IOException {
        int bitsToPush = bits;
        while (bitsToPush > 0) {
            int chunk = Math.min(this.bitsUnused, bitsToPush);
            int mask = (1 << chunk) - 1;
            this.currentByte |= ((int)(value >> bitsToPush - chunk) & mask) << this.bitsUnused - chunk;
            this.sendOnFullByte();
            bitsToPush -= chunk;
            this.bitsUnused -= chunk;
        }
    }

    private void sendOnFullByte() throws IOException {
        if (this.bitsUnused == 0) {
            this.stream.write(this.currentByte);
            this.bitsUnused = 8;
            this.currentByte = 0;
        }
    }

    public void flush() throws IOException {
        if (this.bitsUnused < 8) {
            this.stream.write(this.currentByte);
        }
        this.bitsUnused = 8;
        this.currentByte = 0;
    }
}

