/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io;

import java.io.IOException;
import java.io.InputStream;

public class ChainedInputStream
extends InputStream {
    private final Provider provider;
    private InputStream currentStream;
    private boolean streamEnded;

    public ChainedInputStream(Provider provider) {
        this.provider = provider;
    }

    private boolean loadNextStream() throws IOException {
        if (!this.streamEnded) {
            this.close();
            this.currentStream = this.provider.next();
            if (this.currentStream == null) {
                this.streamEnded = true;
            }
        }
        return !this.streamEnded;
    }

    @Override
    public int read() throws IOException {
        int result;
        if (this.streamEnded || this.currentStream == null && !this.loadNextStream()) {
            return -1;
        }
        int emptyStreamCount = 0;
        while ((result = this.currentStream.read()) == -1 && ++emptyStreamCount < 5) {
            if (this.loadNextStream()) continue;
            return -1;
        }
        return result;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int result;
        if (this.streamEnded || this.currentStream == null && !this.loadNextStream()) {
            return -1;
        }
        int emptyStreamCount = 0;
        while ((result = this.currentStream.read(buffer, offset, length)) == -1 && ++emptyStreamCount < 5) {
            if (this.loadNextStream()) continue;
            return -1;
        }
        return result;
    }

    @Override
    public long skip(long distance) throws IOException {
        long result;
        if (this.streamEnded || this.currentStream == null && !this.loadNextStream()) {
            return -1L;
        }
        int emptyStreamCount = 0;
        while ((result = this.currentStream.skip(distance)) == 0L && ++emptyStreamCount < 5) {
            if (this.loadNextStream()) continue;
            return 0L;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.currentStream != null) {
            this.currentStream.close();
            this.currentStream = null;
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public static interface Provider {
        public InputStream next() throws IOException;
    }
}

