/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoProvider;
import java.io.IOException;
import java.util.List;

public class SavedHeadSeekableInputStream
extends SeekableInputStream {
    private final SeekableInputStream delegate;
    private final byte[] savedHead;
    private boolean usingHead;
    private boolean allowDirectReads;
    private long headPosition;
    private long savedUntilPosition;

    public SavedHeadSeekableInputStream(SeekableInputStream delegate, int savedSize) {
        super(delegate.getContentLength(), delegate.getMaxSkipDistance());
        this.delegate = delegate;
        this.savedHead = new byte[savedSize];
        this.allowDirectReads = true;
    }

    public void setAllowDirectReads(boolean allowDirectReads) {
        this.allowDirectReads = allowDirectReads;
    }

    public void loadHead() throws IOException {
        this.delegate.seek(0L);
        this.savedUntilPosition = this.read(this.savedHead, 0, this.savedHead.length);
        this.usingHead = this.savedUntilPosition > 0L;
        this.headPosition = 0L;
    }

    @Override
    public long getPosition() {
        if (this.usingHead) {
            return this.headPosition;
        }
        return this.delegate.getPosition();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void seekHard(long position) throws IOException {
        if (position >= this.savedUntilPosition) {
            if (!this.allowDirectReads) throw new IndexOutOfBoundsException("Reads beyond saved head are disabled.");
            this.usingHead = false;
            this.delegate.seekHard(position);
            return;
        } else {
            this.usingHead = true;
            this.headPosition = position;
        }
    }

    @Override
    public boolean canSeekHard() {
        return this.delegate.canSeekHard();
    }

    @Override
    public List<AudioTrackInfoProvider> getTrackInfoProviders() {
        return this.delegate.getTrackInfoProviders();
    }

    @Override
    public int read() throws IOException {
        if (this.usingHead) {
            byte result = this.savedHead[(int)this.headPosition];
            if (++this.headPosition == this.savedUntilPosition) {
                this.delegate.seek(this.savedUntilPosition);
                this.usingHead = false;
            }
            return result & 0xFF;
        }
        if (this.allowDirectReads) {
            return this.delegate.read();
        }
        throw new IndexOutOfBoundsException("Reads beyond saved head are disabled.");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.usingHead) {
            return super.read(b, off, len);
        }
        if (this.allowDirectReads) {
            return this.delegate.read(b, off, len);
        }
        throw new IndexOutOfBoundsException("Reads beyond saved head are disabled.");
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.usingHead) {
            return super.skip(n);
        }
        if (this.allowDirectReads) {
            return this.delegate.skip(n);
        }
        throw new IndexOutOfBoundsException("Reads beyond saved head are disabled.");
    }

    @Override
    public int available() throws IOException {
        if (this.usingHead) {
            return (int)(this.savedUntilPosition - this.headPosition);
        }
        if (this.allowDirectReads) {
            return this.delegate.available();
        }
        throw new IndexOutOfBoundsException("Reads beyond saved head are disabled.");
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

