/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.org.apache.http.impl.client;

import dev.felnull.imp.libs.org.apache.http.HttpException;
import dev.felnull.imp.libs.org.apache.http.HttpHost;
import dev.felnull.imp.libs.org.apache.http.HttpRequest;
import dev.felnull.imp.libs.org.apache.http.annotation.Contract;
import dev.felnull.imp.libs.org.apache.http.annotation.ThreadingBehavior;
import dev.felnull.imp.libs.org.apache.http.client.ClientProtocolException;
import dev.felnull.imp.libs.org.apache.http.client.config.RequestConfig;
import dev.felnull.imp.libs.org.apache.http.client.methods.CloseableHttpResponse;
import dev.felnull.imp.libs.org.apache.http.client.methods.Configurable;
import dev.felnull.imp.libs.org.apache.http.client.methods.HttpExecutionAware;
import dev.felnull.imp.libs.org.apache.http.client.methods.HttpRequestWrapper;
import dev.felnull.imp.libs.org.apache.http.client.protocol.HttpClientContext;
import dev.felnull.imp.libs.org.apache.http.conn.ClientConnectionManager;
import dev.felnull.imp.libs.org.apache.http.conn.ClientConnectionRequest;
import dev.felnull.imp.libs.org.apache.http.conn.HttpClientConnectionManager;
import dev.felnull.imp.libs.org.apache.http.conn.ManagedClientConnection;
import dev.felnull.imp.libs.org.apache.http.conn.routing.HttpRoute;
import dev.felnull.imp.libs.org.apache.http.conn.scheme.SchemeRegistry;
import dev.felnull.imp.libs.org.apache.http.impl.DefaultConnectionReuseStrategy;
import dev.felnull.imp.libs.org.apache.http.impl.client.CloseableHttpClient;
import dev.felnull.imp.libs.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import dev.felnull.imp.libs.org.apache.http.impl.execchain.MinimalClientExec;
import dev.felnull.imp.libs.org.apache.http.params.BasicHttpParams;
import dev.felnull.imp.libs.org.apache.http.params.HttpParams;
import dev.felnull.imp.libs.org.apache.http.protocol.BasicHttpContext;
import dev.felnull.imp.libs.org.apache.http.protocol.HttpContext;
import dev.felnull.imp.libs.org.apache.http.protocol.HttpRequestExecutor;
import dev.felnull.imp.libs.org.apache.http.util.Args;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, timeUnit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

