/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.api;

import dev.felnull.imp.api.music.MusicRingerAccess;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.server.music.ringer.MusicRing;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;

public class IamMusicPlayerAPI {
    public static int getRingerCount() {
        AtomicInteger ct = new AtomicInteger();
        MusicRingManager.getInstance().getMusicRingers().values().stream().map(MusicRing::getRingers).map(Map::size).forEach(ct::addAndGet);
        return ct.get();
    }

    public static int getRingerCount(ServerLevel level) {
        MusicRing rs = MusicRingManager.getInstance().getMusicRingers().get(level);
        if (rs != null) {
            return rs.getRingers().size();
        }
        return 0;
    }

    public static int getPlayingRingerCount() {
        AtomicInteger ct = new AtomicInteger();
        MusicRingManager.getInstance().getMusicRingers().entrySet().stream().map(n -> (int)((MusicRing)n.getValue()).getRingers().values().stream().filter(IMusicRinger::isRingerPlaying).count()).forEach(ct::addAndGet);
        return ct.get();
    }

    public static int getPlayingRingerCount(ServerLevel level) {
        MusicRing rs = MusicRingManager.getInstance().getMusicRingers().get(level);
        if (rs != null) {
            return (int)rs.getRingers().values().stream().filter(IMusicRinger::isRingerPlaying).count();
        }
        return 0;
    }

    @NotNull
    public static List<MusicRingerAccess> getRingers() {
        ArrayList pls = new ArrayList();
        MusicRingManager.getInstance().getMusicRingers().values().stream().map(MusicRing::getRingers).map(Map::values).forEach(n -> n.forEach(m -> pls.add(new MusicRingerAccess((IMusicRinger)m))));
        return Collections.unmodifiableList(pls);
    }

    @NotNull
    public static List<MusicRingerAccess> getRingers(ServerLevel level) {
        ArrayList pls = new ArrayList();
        MusicRing mr = MusicRingManager.getInstance().getMusicRingers().get(level);
        if (mr != null) {
            mr.getRingers().values().forEach(n -> pls.add(new MusicRingerAccess((IMusicRinger)n)));
        }
        return Collections.unmodifiableList(pls);
    }
}

