/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.components.MusicLoaderTypesFixedButtonsList;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImageNameBaseMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.SavedMusicBaseMMMonitor;
import dev.felnull.imp.client.music.loadertypes.IMPMusicLoaderTypes;
import dev.felnull.imp.client.music.loadertypes.IMusicLoaderType;
import dev.felnull.imp.client.music.loadertypes.MusicLoadResult;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.imp.util.FlagThread;
import dev.felnull.otyacraftengine.client.gui.components.FixedButtonsList;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import dev.felnull.otyacraftengine.networking.BlockEntityExistence;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;

public class AddMusicMMMonitor
extends SavedMusicBaseMMMonitor {
    private static final Component MUSIC_CHECKING_TEXT = new TranslatableComponent("imp.text.musicChecking");
    private static final Component MUSIC_GUESSING_TEXT = new TranslatableComponent("imp.text.musicGuessing");
    private static final Component MUSIC_LOAD_FAILURE_TEXT = new TranslatableComponent("imp.text.loadFailure");
    private static final Component AUTO_ENTER_TEXT = new TranslatableComponent("imp.text.enterText.auto");
    private static final Component AUTO_INFO_TEXT = new TranslatableComponent("imp.text.loaderTypeInfo.auto");
    private static final Component AUTO_FAILURE_TEXT = new TranslatableComponent("imp.text.loadFailure.auto");
    private static final Component UPLOAD_MUSIC_TEXT = new TranslatableComponent("imp.button.uploadMusic");
    protected static final Component IMPORT_TEXT = new TranslatableComponent("imp.button.import");
    private final List<String> musicLoaderTypes = new ArrayList<String>();
    private EditBox musicSourceNameEditBox;
    private SmartButton searchButton;
    private SmartButton uploadButton;
    private MusicLoadThread musicLoadThread;
    private boolean loadFailure;

    public AddMusicMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
        this.playBackX = 189;
        this.playBackY = 140;
        this.isLoaderSelect = true;
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.musicLoaderTypes.clear();
        this.musicLoaderTypes.add("auto");
        this.musicLoaderTypes.add("upload");
        this.musicLoaderTypes.addAll(IMPMusicLoaderTypes.getMusicLoaderTypes().keySet());
        this.addRenderWidget(new MusicLoaderTypesFixedButtonsList(this.getStartX() + 189, this.getStartY() + 23, 175, 65, 5, (Component)new TranslatableComponent("imp.fixedList.musicLoaderTypes"), this.musicLoaderTypes, (FixedButtonsList.PressEntry<String>)((FixedButtonsList.PressEntry)(fixedButtonsList, s, i, i1) -> {
            this.setMusicLoaderType((String)s);
            this.loadFailure = false;
        }), n -> this.getMusicLoaderType().equals(n)));
        this.musicSourceNameEditBox = new EditBox(IIMPSmartRender.mc.f_91062_, this.getStartX() + 189, this.getStartY() + 112, this.isMSNShortWidth() ? 141 : 177, 12, (Component)new TranslatableComponent("imp.editBox.musicSourceName"));
        this.musicSourceNameEditBox.m_94199_(300);
        this.musicSourceNameEditBox.f_93624_ = this.isMSNVisible();
        this.musicSourceNameEditBox.m_94144_(this.getMusicSourceName());
        this.musicSourceNameEditBox.m_94151_(this::setMusicSourceName);
        this.addRenderWidget(this.musicSourceNameEditBox);
        this.startMusicLoad(this.getMusicSourceName(), this.getScreen().lastSearch);
        this.getScreen().lastSearch = false;
        this.searchButton = this.addRenderWidget(new SmartButton(this.getStartX() + 331, this.getStartY() + 111, 35, 14, (Component)new TranslatableComponent("imp.button.search"), n -> this.insMonitor(MusicManagerBlockEntity.MonitorType.SEARCH_MUSIC)));
        this.searchButton.setHideText(true);
        this.searchButton.setIcon(WIDGETS_TEXTURE, 24, 107, 12, 12);
        this.searchButton.f_93624_ = this.isMSNVisible() && this.isMSNShortWidth();
        this.uploadButton = this.addRenderWidget(new SmartButton(this.getStartX() + 189, this.getStartY() + 111, 177, 14, UPLOAD_MUSIC_TEXT, n -> this.insMonitor(MusicManagerBlockEntity.MonitorType.UPLOAD_MUSIC)));
        this.uploadButton.setIcon(WIDGETS_TEXTURE, 36, 107, 12, 12);
        this.uploadButton.f_93624_ = "upload".equals(this.getMusicLoaderType());
        this.addRenderWidget(new SmartButton(this.getStartX() + this.width - 95 - 87, this.getStartY() + 180, 87, 15, IMPORT_TEXT, n -> this.insMonitor(MusicManagerBlockEntity.MonitorType.IMPORT_MUSICS_SELECT)));
    }

    @Override
    public void depose() {
        super.depose();
        this.stopMusicLoad();
    }

    @Override
    public void render(PoseStack poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        if (this.musicLoadThread != null && !this.getMusicSourceName().isEmpty()) {
            this.drawSmartText(poseStack, "auto".equals(this.getMusicLoaderType()) ? MUSIC_GUESSING_TEXT : MUSIC_CHECKING_TEXT, this.getStartX() + 189, this.getStartY() + 128);
        }
        if (this.getRawMusicLoaderType() != null) {
            this.drawSmartText(poseStack, this.getRawMusicLoaderType().getEnterText(), this.getStartX() + 189, this.getStartY() + 102);
        } else if ("auto".equals(this.getMusicLoaderType())) {
            this.drawSmartText(poseStack, AUTO_ENTER_TEXT, this.getStartX() + 189, this.getStartY() + 102);
            this.drawSmartText(poseStack, AUTO_INFO_TEXT, this.getStartX() + 189, this.getStartY() + 90);
        }
        if (this.loadFailure && !this.getMusicSourceName().isEmpty()) {
            this.drawSmartText(poseStack, "auto".equals(this.getMusicLoaderType()) ? AUTO_FAILURE_TEXT : MUSIC_LOAD_FAILURE_TEXT, this.getStartX() + 189, this.getStartY() + 128);
        }
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        this.musicLoaderTypes.clear();
        this.musicLoaderTypes.add("auto");
        this.musicLoaderTypes.add("upload");
        this.musicLoaderTypes.addAll(IMPMusicLoaderTypes.getMusicLoaderTypes().keySet());
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        IMusicLoaderType ml = this.getRawMusicLoaderType(blockEntity);
        if (ml != null) {
            this.renderSmartTextSprite(poseStack, multiBufferSource, ml.getEnterText(), 189.0f, 102.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
        } else if ("auto".equals(this.getMusicLoaderType(blockEntity))) {
            this.renderSmartTextSprite(poseStack, multiBufferSource, AUTO_ENTER_TEXT, 189.0f, 102.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
            this.renderSmartTextSprite(poseStack, multiBufferSource, AUTO_INFO_TEXT, 189.0f, 91.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
        }
        if (!"upload".equals(this.getMusicLoaderType(blockEntity))) {
            IMusicLoaderType rtp = this.getRawMusicLoaderType(blockEntity);
            this.renderSmartEditBoxSprite(poseStack, multiBufferSource, 189.0f, 112.0f, 0.004f, rtp != null && rtp.isSearchable() ? 141.0f : 177.0f, 12.0f, i, j, onPxW, onPxH, monitorHeight, this.getName(blockEntity));
            if (rtp != null && rtp.isSearchable()) {
                this.renderSmartButtonSprite(poseStack, multiBufferSource, 333.0f, 111.0f, 0.004f, 33.0f, 14.0f, i, j, onPxW, onPxH, monitorHeight, MusicManagerMonitor.WIDGETS_TEXTURE, 24, 107, 11, 11, 256, 256);
            }
        } else {
            this.renderSmartButtonSprite(poseStack, multiBufferSource, 189.0f, 111.0f, 0.004f, 177.0f, 14.0f, i, j, onPxW, onPxH, monitorHeight, UPLOAD_MUSIC_TEXT, WIDGETS_TEXTURE, 36, 107, 12, 12, 256, 256);
        }
        this.renderScrollbarSprite(poseStack, multiBufferSource, 355.0f, 23.0f, 0.003f, 65.0f, i, j, onPxW, onPxH, monitorHeight, this.musicLoaderTypes.size(), 5);
        for (int k = 0; k < Math.min(5, this.musicLoaderTypes.size()); ++k) {
            String lt = this.musicLoaderTypes.get(k);
            this.renderSmartButtonBoxSprite(poseStack, multiBufferSource, 189.0f, 23 + k * 13, 0.003f, 165.0f, 13.0f, i, j, onPxW, onPxH, monitorHeight, lt.equals(this.getMusicLoaderType(blockEntity)));
            IMusicLoaderType type = IMPMusicLoaderTypes.getMusicLoaderTypes().get(lt);
            int tx = 191;
            if (type != null && type.getIcon() != null || "upload".equals(lt)) {
                ResourceLocation icon = type != null ? type.getIcon() : MusicLoaderTypesFixedButtonsList.UPLOAD_ICON;
                OERenderUtil.renderTextureSprite((ResourceLocation)icon, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (float)(190.0f * onPxW), (float)(monitorHeight - (23.0f + (float)k * 13.0f + 1.0f + 11.0f) * onPxH), (float)0.0050000004f, (float)0.0f, (float)0.0f, (float)0.0f, (float)(11.0f * onPxW), (float)(11.0f * onPxH), (float)0.0f, (float)0.0f, (float)(11.0f * onPxW), (float)(11.0f * onPxH), (float)(11.0f * onPxW), (float)(11.0f * onPxH), (int)i, (int)j);
                tx += 12;
            }
            this.renderSmartTextSprite(poseStack, multiBufferSource, (Component)(type == null ? new TranslatableComponent("imp.loaderType." + lt) : type.getName()), tx, (float)(23 + k * 13) + 3.25f + 1.0f, 0.0050000004f, onPxW, onPxH, monitorHeight, i);
        }
        this.renderSmartButtonSprite(poseStack, multiBufferSource, this.width - 95 - 87, 180.0f, 0.004f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, IMPORT_TEXT, true);
    }

    @Override
    public boolean done(ImageInfo imageInfo, String name) {
        MusicManagerBlockEntity musicManagerBlock;
        MusicSource ms = this.getMusicSource();
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity && (musicManagerBlock = (MusicManagerBlockEntity)blockEntity).getMySelectedPlayList() != null) {
            NetworkManager.sendToServer((ResourceLocation)IMPPackets.MUSIC_ADD, (FriendlyByteBuf)new IMPPackets.MusicMessage(musicManagerBlock.getMySelectedPlayList(), name, this.getMusicAuthor(), imageInfo, ms, BlockEntityExistence.getByBlockEntity((BlockEntity)this.getScreen().getBlockEntity())).toFBB());
        }
        return true;
    }

    @Override
    public boolean canDone(MusicManagerBlockEntity blockEntity) {
        return super.canDone(blockEntity) && !this.getMusicSource(blockEntity).isEmpty();
    }

    @Override
    public List<Component> getNotEntered(List<Component> names, MusicManagerBlockEntity blockEntity) {
        if (this.getMusicSource(blockEntity).isEmpty()) {
            names.add(MUSIC_SOURCE_TEXT);
        }
        return super.getNotEntered(names, blockEntity);
    }

    @Override
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return MusicManagerBlockEntity.MonitorType.PLAY_LIST;
    }

    @Override
    public void tick() {
        super.tick();
        this.musicSourceNameEditBox.f_93624_ = this.isMSNVisible();
        this.musicSourceNameEditBox.m_93674_(this.isMSNShortWidth() ? 141 : 177);
        this.searchButton.f_93624_ = this.isMSNVisible() && this.isMSNShortWidth();
        this.uploadButton.f_93624_ = "upload".equals(this.getMusicLoaderType());
        if (this.getScreen().isMusicPlaying() && !this.getMusicSource().equals(this.getScreen().getMusicPlayer().getMusicSource()) || this.getScreen().isMusicLoading() && !this.getMusicSource().equals(this.getScreen().getLoadingMusic().getSource())) {
            this.getScreen().stopMusic();
        }
    }

    private boolean isMSNVisible() {
        return !"upload".equals(this.getMusicLoaderType());
    }

    @Override
    protected ImageNameBaseMMMonitor.DoneType getDoneType() {
        return ImageNameBaseMMMonitor.DoneType.ADD;
    }

    private boolean isMSNShortWidth() {
        IMusicLoaderType rtp = this.getRawMusicLoaderType();
        return rtp != null && rtp.isSearchable();
    }

    private void setMusicLoaderType(String name) {
        this.musicSourceNameEditBox.m_94144_("");
        this.getScreen().insMusicLoaderType(name);
    }

    private void setMusicSourceName(String name) {
        if (!this.getMusicSourceName().equals(name)) {
            this.startMusicLoad(name, true);
        }
        this.getScreen().insMusicSourceName(name);
    }

    private void setLoadResult(MusicLoadResult result, boolean autoIn) {
        if (result != null) {
            this.setMusicSource(result.source(), result.author());
            if (autoIn) {
                if (result.imageInfo() != null) {
                    this.setImage(result.imageInfo());
                }
                if (result.name() != null) {
                    this.nameEditBox.m_94144_(result.name());
                }
            }
        } else {
            this.setMusicSource(MusicSource.EMPTY, "");
        }
    }

    private void startMusicLoad(String name, boolean autoIn) {
        this.stopMusicLoad();
        if (this.getRawMusicLoaderType() != null || "auto".equals(this.getMusicLoaderType()) || "upload".equals(this.getMusicLoaderType())) {
            this.loadFailure = false;
            this.musicLoadThread = new MusicLoadThread(this.getMusicLoaderType(), name, autoIn);
            this.musicLoadThread.start();
        }
    }

    private void stopMusicLoad() {
        if (this.musicLoadThread != null) {
            this.musicLoadThread.stopped();
            this.musicLoadThread = null;
        }
    }

    private class MusicLoadThread
    extends FlagThread {
        private final String name;
        private final String loaderType;
        private boolean autoIn;

        private MusicLoadThread(String loaderType, String name, boolean autoIn) {
            this.setName("Music Load Thread");
            this.loaderType = loaderType;
            this.name = name;
            this.autoIn = autoIn;
        }

        @Override
        public void run() {
            try {
                if (this.isStopped()) {
                    return;
                }
                IMusicLoaderType loader = IMPMusicLoaderTypes.getMusicLoaderTypes().get(this.loaderType);
                if ("upload".equals(this.loaderType)) {
                    loader = IMPMusicLoaderTypes.getLoaderType("http");
                }
                if (this.isStopped()) {
                    return;
                }
                if (loader != null) {
                    if (this.isStopped()) {
                        return;
                    }
                    MusicLoadResult r = loader.load(this.name);
                    if (this.isStopped()) {
                        return;
                    }
                    AddMusicMMMonitor.this.setLoadResult(r, this.autoIn);
                    if (r == null) {
                        AddMusicMMMonitor.this.loadFailure = true;
                    }
                    if (this.isStopped()) {
                        return;
                    }
                } else if ("auto".equals(this.loaderType)) {
                    if (this.isStopped()) {
                        return;
                    }
                    Pair<String, MusicLoadResult> ar = IMPMusicLoaderTypes.loadAuto(this.name);
                    if (this.isStopped()) {
                        return;
                    }
                    if (ar != null) {
                        AddMusicMMMonitor.this.setMusicLoaderType((String)ar.getKey());
                        if (this.isStopped()) {
                            return;
                        }
                        IIMPSmartRender.mc.m_18707_(() -> {
                            AddMusicMMMonitor.this.musicSourceNameEditBox.m_94144_(((MusicLoadResult)ar.getValue()).source().getIdentifier());
                            AddMusicMMMonitor.this.startMusicLoad(((MusicLoadResult)ar.getValue()).source().getIdentifier(), this.autoIn);
                        });
                        if (this.isStopped()) {
                            return;
                        }
                    } else {
                        AddMusicMMMonitor.this.loadFailure = true;
                    }
                    if (this.isStopped()) {
                        return;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            AddMusicMMMonitor.this.musicLoadThread = null;
        }
    }
}

