/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.lava;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.client.lava.LavaPlayerLoader;
import dev.felnull.imp.include.dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.imp.include.dev.felnull.fnjl.util.FNURLUtil;
import dev.felnull.imp.include.org.apache.commons.codec.binary.Hex;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LavaNativeManager {
    private static final Logger LOGGER = LogManager.getLogger(LavaNativeManager.class);
    private static final Gson GSON = new Gson();
    private static final LavaNativeManager INSTANCE = new LavaNativeManager();
    private static final String nativesVersion = "1";

    public static LavaNativeManager getInstance() {
        return INSTANCE;
    }

    public boolean load(String osAndArch, String name) {
        File npF = LavaPlayerLoader.getNaiveLibraryFolder().resolve(osAndArch).toFile();
        if (!this.checked(npF)) {
            try {
                LOGGER.info("LavaPlayer natives download start");
                this.downloadNatives(osAndArch);
                LOGGER.info("LavaPlayer natives download successful");
            }
            catch (Exception e) {
                LOGGER.error("LavaPlayer natives download failed", (Throwable)e);
                return false;
            }
        }
        LOGGER.info("LavaPlayer native(" + name + ") check successful");
        return npF.toPath().resolve(name).toFile().exists();
    }

    private void downloadNatives(String osAndArch) throws Exception {
        JsonObject jo;
        File npF = LavaPlayerLoader.getNaiveLibraryFolder().resolve(osAndArch).toFile();
        if (!npF.exists() && !npF.mkdirs()) {
            throw new IllegalStateException("Failed to create the folder of the native library");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(FNURLUtil.getStream(new URL(IamMusicPlayer.CONFIG.lavaPlayerNativesURL))));){
            jo = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        if (!jo.has(nativesVersion) || !jo.get(nativesVersion).isJsonObject()) {
            throw new IllegalStateException("Could not find version of native library to support");
        }
        JsonObject joo = jo.getAsJsonObject(nativesVersion);
        if (!joo.has(osAndArch) || !joo.get(osAndArch).isJsonObject()) {
            throw new IllegalStateException("Unsupported OS or architecture");
        }
        JsonObject jooo = joo.getAsJsonObject(osAndArch);
        if (!jooo.has("hash")) {
            throw new IllegalStateException("The hash value was not found");
        }
        if (!jooo.has("url")) {
            throw new IllegalStateException("Native library URL not found");
        }
        JsonObject ho = new JsonObject();
        ho.add("hash", jooo.get("hash"));
        Files.writeString(npF.toPath().resolve("hash.json"), (CharSequence)GSON.toJson((JsonElement)ho), new OpenOption[0]);
        FNDataUtil.readZipStreamed(new BufferedInputStream(FNURLUtil.getStream(new URL(jooo.get("url").getAsString()))), (zipEntry, inputStream) -> {
            File fl = npF.toPath().resolve(zipEntry.getName()).toFile();
            try (InputStream is = inputStream;
                 FileOutputStream os = new FileOutputStream(fl);){
                FNDataUtil.bufInputToOutput(is, os);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        if (!this.checked(npF)) {
            throw new IllegalStateException("Consistency check failed");
        }
    }

    private boolean checked(File file) {
        JsonObject jo;
        Object[] fs = file.listFiles();
        if (fs == null) {
            return false;
        }
        ArrayList fls = Lists.newArrayList((Object[])fs);
        Optional<File> hf = fls.stream().filter(n -> n.getName().equals("hash.json")).findAny();
        if (hf.isEmpty()) {
            return false;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(hf.get())));){
            jo = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        catch (IOException e) {
            return false;
        }
        if (!jo.has("hash") || fls.size() <= 1) {
            return false;
        }
        fls.remove(hf.get());
        if (fls.size() == 1 && !jo.get("hash").isJsonObject()) {
            try {
                String ch = jo.get("hash").getAsString();
                String th = new String(Hex.encodeHex(FNDataUtil.createMD5Hash(Files.readAllBytes(((File)fls.get(0)).toPath()))));
                return th.equals(ch);
            }
            catch (Exception ch) {}
        } else if (jo.get("hash").isJsonObject() && jo.get("hash").getAsJsonObject().size() == fls.size()) {
            JsonObject hjo = jo.get("hash").getAsJsonObject();
            for (Map.Entry entry : hjo.entrySet()) {
                Optional<File> lf = fls.stream().filter(n -> n.getName().equals(entry.getKey())).findAny();
                if (lf.isEmpty()) {
                    return false;
                }
                try {
                    String ch = ((JsonElement)entry.getValue()).getAsString();
                    String th = new String(Hex.encodeHex(FNDataUtil.createMD5Hash(Files.readAllBytes(lf.get().toPath()))));
                    if (th.equals(ch)) continue;
                    return false;
                }
                catch (Exception ignored) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

