/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.format.transcoder;

import com.sedmelluq.discord.lavaplayer.natives.opus.OpusEncoder;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkEncoder;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class OpusChunkEncoder
implements AudioChunkEncoder {
    private final AudioDataFormat format;
    private final OpusEncoder encoder;
    private final ByteBuffer encodedBuffer;

    public OpusChunkEncoder(AudioConfiguration configuration, AudioDataFormat format) {
        this.encodedBuffer = ByteBuffer.allocateDirect(format.maximumChunkSize());
        this.encoder = new OpusEncoder(format.sampleRate, format.channelCount, configuration.getOpusEncodingQuality());
        this.format = format;
    }

    @Override
    public byte[] encode(ShortBuffer buffer) {
        this.encoder.encode(buffer, this.format.chunkSampleCount, this.encodedBuffer);
        byte[] bytes = new byte[this.encodedBuffer.remaining()];
        this.encodedBuffer.get(bytes);
        return bytes;
    }

    @Override
    public void encode(ShortBuffer buffer, ByteBuffer outBuffer) {
        if (outBuffer.isDirect()) {
            this.encoder.encode(buffer, this.format.chunkSampleCount, outBuffer);
        } else {
            this.encoder.encode(buffer, this.format.chunkSampleCount, this.encodedBuffer);
            int length = this.encodedBuffer.remaining();
            this.encodedBuffer.get(outBuffer.array(), 0, length);
            outBuffer.position(0);
            outBuffer.limit(length);
        }
    }

    @Override
    public void close() {
        this.encoder.close();
    }
}

