/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.nico;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.nico.NicoAudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import dev.felnull.imp.include.org.apache.http.client.methods.CloseableHttpResponse;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpGet;
import dev.felnull.imp.include.org.apache.http.client.utils.URLEncodedUtils;
import dev.felnull.imp.include.org.apache.http.util.EntityUtils;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class NicoAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(NicoAudioTrack.class);
    private final NicoAudioSourceManager sourceManager;

    public NicoAudioTrack(AudioTrackInfo trackInfo, NicoAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        this.sourceManager.checkLoggedIn();
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            this.loadVideoMainPage(httpInterface);
            String playbackUrl = this.loadPlaybackUrl(httpInterface);
            log.debug("Starting NicoNico track from URL: {}", (Object)playbackUrl);
            try (PersistentHttpStream stream = new PersistentHttpStream(httpInterface, new URI(playbackUrl), null);){
                this.processDelegate(new MpegAudioTrack(this.trackInfo, stream), localExecutor);
            }
        }
    }

    private void loadVideoMainPage(HttpInterface httpInterface) throws IOException {
        HttpGet request = new HttpGet("http://www.nicovideo.jp/watch/" + this.trackInfo.identifier);
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new IOException("Unexpected status code from video main page: " + statusCode);
            }
            EntityUtils.consume(response.getEntity());
        }
    }

    private String loadPlaybackUrl(HttpInterface httpInterface) throws IOException {
        HttpGet request = new HttpGet("http://flapi.nicovideo.jp/api/getflv/" + this.trackInfo.identifier);
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new IOException("Unexpected status code from playback parameters page: " + statusCode);
            }
            String text = EntityUtils.toString(response.getEntity());
            Map<String, String> format = DataFormatTools.convertToMapLayout(URLEncodedUtils.parse(text, StandardCharsets.UTF_8));
            String string = format.get("url");
            return string;
        }
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new NicoAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

