/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.dev.felnull.fnjl.util;

import java.util.function.Function;

public class FNColorUtil {
    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public static int getAlpha(int color) {
        return color >>> 24;
    }

    public static int getHexColor(int r, int g, int b) {
        return (r << 16) + (g << 8) + b;
    }

    public static int getARGBHexColor(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static String getStringHexColor(int colorCode) {
        String hex = Integer.toHexString(colorCode);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Math.max(0, 6 - hex.length()); ++i) {
            sb.append("0");
        }
        sb.append(hex);
        return sb.toString();
    }

    public static double getColorDistance(int color1, int color2) {
        return Math.abs(Math.sqrt(Math.pow(FNColorUtil.getRed(color1) - FNColorUtil.getRed(color2), 2.0) + Math.pow(FNColorUtil.getGreen(color1) - FNColorUtil.getGreen(color2), 2.0) + Math.pow(FNColorUtil.getBlue(color1) - FNColorUtil.getBlue(color2), 2.0)));
    }

    public static int getApproximateColor(int target, int ... colors) {
        int most = -1;
        double mostDis = Double.MAX_VALUE;
        for (int color : colors) {
            if (target == color) {
                return color;
            }
            double dis = FNColorUtil.getColorDistance(target, color);
            if (!(dis < mostDis)) continue;
            mostDis = dis;
            most = color;
        }
        return most;
    }

    public static <T> T getApproximateColorObject(int target, T[] colors, Function<T, Integer> colorGetter) {
        T mostObject = null;
        double mostDis = Double.MAX_VALUE;
        for (T color : colors) {
            int col = colorGetter.apply(color);
            if (target == col) {
                return color;
            }
            double dis = FNColorUtil.getColorDistance(target, col);
            if (!(dis < mostDis)) continue;
            mostDis = dis;
            mostObject = color;
        }
        return mostObject;
    }

    public static int getAverageMixColor(int ... colors) {
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        for (int color : colors) {
            r += (double)FNColorUtil.getRed(color);
            g += (double)FNColorUtil.getGreen(color);
            b += (double)FNColorUtil.getBlue(color);
        }
        return FNColorUtil.getHexColor((int)(r / (double)colors.length), (int)(g / (double)colors.length), (int)(b / (double)colors.length));
    }
}

