/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.item;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.server.music.ringer.IBoomboxRinger;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class BoomboxEntityRinger
implements IBoomboxRinger {
    private final Entity entity;
    private final UUID uuid;
    private int lastInventory;

    public BoomboxEntityRinger(Entity entity, UUID uuid) {
        this.entity = entity;
        this.uuid = uuid;
    }

    @Override
    public Component getRingerName() {
        if (this.entity instanceof ItemEntity) {
            return new TranslatableComponent("imp.ringer.drop", new Object[]{this.getBoombox().m_41611_()});
        }
        return new TranslatableComponent("imp.ringer.have", new Object[]{this.getBoombox().m_41611_(), this.entity.m_5446_()});
    }

    @Override
    public ServerLevel getRingerLevel() {
        return (ServerLevel)this.entity.f_19853_;
    }

    @Override
    public UUID getRingerUUID() {
        return this.uuid;
    }

    @Override
    public boolean exists() {
        return BoomboxEntityRinger.canRing(this.entity) && !this.getBoombox().m_41619_();
    }

    @Override
    public Pair<ResourceLocation, CompoundTag> getRingerTracker() {
        Entity entity = this.entity;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return Pair.of((Object)MusicRingManager.PLAYER_TRACKER, (Object)MusicRingManager.createPlayerTracker(player));
        }
        return Pair.of((Object)MusicRingManager.ENTITY_TRACKER, (Object)MusicRingManager.createEntityTracker(this.entity));
    }

    @Override
    @NotNull
    public Vec3 getRingerSpatialPosition() {
        return this.entity.m_20182_();
    }

    @NotNull
    private ItemStack getBoombox() {
        ItemEntity itemEntity;
        ItemStack item;
        Entity li;
        EquipmentSlot[] equipmentSlotArray = this.entity;
        if (equipmentSlotArray instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)equipmentSlotArray;
            equipmentSlotArray = EquipmentSlot.values();
            int n = equipmentSlotArray.length;
            for (int i = 0; i < n; ++i) {
                EquipmentSlot value = equipmentSlotArray[i];
                ItemStack item2 = livingEntity.m_6844_(value);
                if (!this.uuid.equals(BoomboxItem.getRingerUUID(item2))) continue;
                return item2;
            }
        }
        if ((equipmentSlotArray = this.entity) instanceof Player) {
            Player player = (Player)equipmentSlotArray;
            li = player.m_150109_().m_8020_(this.lastInventory);
            if (this.uuid.equals(BoomboxItem.getRingerUUID((ItemStack)li))) {
                return li;
            }
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack item3 = player.m_150109_().m_8020_(i);
                if (!this.uuid.equals(BoomboxItem.getRingerUUID(item3))) continue;
                this.lastInventory = i;
                return item3;
            }
        }
        if (IamMusicPlayer.CONFIG.dropItemRing && (li = this.entity) instanceof ItemEntity && this.uuid.equals(BoomboxItem.getRingerUUID(item = (itemEntity = (ItemEntity)li).m_32055_()))) {
            return item;
        }
        return ItemStack.f_41583_;
    }

    @Override
    @NotNull
    public BoomboxData getRingerBoomboxData() {
        return BoomboxItem.getData(this.getBoombox());
    }

    public static boolean canRing(Entity entity) {
        if (!entity.m_6084_()) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !player.m_5833_();
        }
        return true;
    }
}

