/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.server.music.ringer;

import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.advancements.IMPCriteriaTriggers;
import dev.felnull.imp.music.MusicPlaybackInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;

public class MusicRing {
    private final ServerLevel level;
    private final Map<UUID, IMusicRinger> ringers = new HashMap<UUID, IMusicRinger>();
    private final Map<UUID, RingedPlayerInfos> playerInfos = new HashMap<UUID, RingedPlayerInfos>();
    private final Set<UUID> waitRingers = new HashSet<UUID>();
    private long baseTime;
    private long pauseTime;
    private long lastTime;

    public MusicRing(ServerLevel level) {
        this.level = level;
        this.baseTime = System.currentTimeMillis();
    }

    private ServerLevel getLevel() {
        return this.level;
    }

    protected void tick() {
        ArrayList<UUID> stopRingers = new ArrayList<UUID>();
        for (IMusicRinger ringer : this.ringers.values()) {
            UUID uuid = ringer.getRingerUUID();
            if (!ringer.exists()) {
                stopRingers.add(uuid);
                continue;
            }
            MusicSource ms = ringer.getRingerMusicSource();
            if (ms == null || !ringer.isRingerPlaying()) {
                ringer.setRingerPlaying(false);
                this.stopRingingPlayer(uuid);
                continue;
            }
            RingedPlayerInfos rpi = this.playerInfos.get(uuid);
            if (rpi == null) {
                rpi = new RingedPlayerInfos(uuid, this.getTime());
                rpi.sendFirstPackets();
                this.playerInfos.put(uuid, rpi);
                this.waitRingers.add(uuid);
            }
            if (!rpi.tick(this.getTime())) continue;
            this.waitRingers.remove(uuid);
            long eq = this.getTime() - this.lastTime;
            if (ms.getDuration() >= ringer.getRingerPosition() + eq || ringer.isRingerStream()) {
                MusicSource sc = ringer.getRingerMusicSource();
                ringer.setRingerPosition(Mth.m_14053_((long)(ringer.getRingerPosition() + eq), (long)0L, (long)(sc != null ? sc.getDuration() : 0L)));
                continue;
            }
            ringer.setRingerPosition(0L);
            ringer.ringerEnd();
            if (ringer.isRingerLoop()) {
                this.stopRingingPlayer(uuid);
                continue;
            }
            ringer.setRingerPlaying(false);
        }
        stopRingers.forEach(this::stopRinger);
        this.lastTime = this.getTime();
    }

    protected boolean isWaitRinger(UUID ringer) {
        return this.waitRingers.contains(ringer);
    }

    protected void addRinger(IMusicRinger ringer) {
        if (!this.ringers.containsKey(ringer.getRingerUUID())) {
            this.ringers.put(ringer.getRingerUUID(), ringer);
        }
    }

    public boolean hasRinger(UUID ringer) {
        return this.ringers.containsKey(ringer);
    }

    public Map<UUID, IMusicRinger> getRingers() {
        return this.ringers;
    }

    protected void pause() {
        this.pauseTime = System.currentTimeMillis();
    }

    protected void resume() {
        this.baseTime += System.currentTimeMillis() - this.pauseTime;
        this.pauseTime = 0L;
    }

    private long getTime() {
        return System.currentTimeMillis() - this.baseTime;
    }

    protected void depose() {
        this.ringers.clear();
        this.playerInfos.clear();
        this.waitRingers.clear();
    }

    protected void restart(UUID uuid) {
        IMusicRinger ringer = this.ringers.get(uuid);
        if (ringer != null) {
            this.stopRinger(uuid);
            this.addRinger(ringer);
        }
    }

    protected void stopRinger(UUID ringer) {
        this.ringers.remove(ringer);
        this.waitRingers.remove(ringer);
        if (this.playerInfos.containsKey(ringer)) {
            this.playerInfos.get(ringer).depose();
            this.playerInfos.remove(ringer);
        }
    }

    protected void stopRingingPlayer(UUID ringer) {
        this.waitRingers.remove(ringer);
        if (this.playerInfos.containsKey(ringer)) {
            this.playerInfos.get(ringer).depose();
            this.playerInfos.remove(ringer);
        }
    }

    private MusicPlaybackInfo getPlaybackInfo(IMusicRinger ringer) {
        Pair<ResourceLocation, CompoundTag> tr = ringer.getRingerTracker();
        return new MusicPlaybackInfo((ResourceLocation)tr.getKey(), (CompoundTag)tr.getValue(), ringer.isRingerMute() ? 0.0f : ringer.getRingerVolume(), ringer.isRingerMute() ? 0.0f : ringer.getRingerRange());
    }

    protected void onUpdate(ServerPlayer player, UUID uuid, UUID waitUUID, int state) {
        RingedPlayerInfos pr = this.playerInfos.get(uuid);
        if (pr != null && pr.infoUUID.equals(waitUUID)) {
            pr.responseUpdate(player, state);
        }
    }

    protected void addReadyPlayer(ServerPlayer player, UUID uuid, UUID waitUUID, boolean result, boolean retry, long elapsed) {
        RingedPlayerInfos pr = this.playerInfos.get(uuid);
        if (pr != null && pr.infoUUID.equals(waitUUID)) {
            pr.addReadyPlayer(player, result, retry, elapsed);
        }
    }

    public static long getMaxWaitTime() {
        return IamMusicPlayer.CONFIG.maxWaitTime;
    }

    public static long getRetryTime() {
        return IamMusicPlayer.CONFIG.retryTime;
    }

    private class RingedPlayerInfos {
        private final UUID ringerUUID;
        private final UUID infoUUID = UUID.randomUUID();
        private final List<UUID> firstWaitPlayers = new ArrayList<UUID>();
        private final List<UUID> firstReadyPlayers = new ArrayList<UUID>();
        private final List<UUID> listenPlayers = new ArrayList<UUID>();
        private final List<UUID> middleLoadPlayers = new ArrayList<UUID>();
        private final Map<UUID, Long> failurePlayers = new HashMap<UUID, Long>();
        private final long startTime;
        private boolean notWait;

        public RingedPlayerInfos(UUID ringer, long startTime) {
            this.ringerUUID = ringer;
            this.startTime = startTime;
            this.firstWaitPlayers.addAll(MusicRing.this.getLevel().m_6907_().stream().filter(this::canListen).map(n -> n.m_36316_().getId()).toList());
        }

        private void sendFirstPackets() {
            for (UUID firstWaitPlayer : this.firstWaitPlayers) {
                Player player = MusicRing.this.getLevel().m_46003_(firstWaitPlayer);
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)IMPPackets.MUSIC_RING_READY, (FriendlyByteBuf)new IMPPackets.MusicReadyMessage(this.infoUUID, this.ringerUUID, this.getRinger().getRingerMusicSource(), MusicRing.this.getPlaybackInfo(this.getRinger()), this.getRingerPosition()).toFBB());
            }
        }

        private void sendStopPackets(UUID player) {
            Player player2 = MusicRing.this.getLevel().m_46003_(player);
            if (player2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player2;
                NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)IMPPackets.MUSIC_RING_STATE, (FriendlyByteBuf)new IMPPackets.MusicRingStateMessage(this.ringerUUID, this.infoUUID, 1).toFBB());
            }
        }

        private void sendMiddleStartPacket(UUID player) {
            Player player2 = MusicRing.this.getLevel().m_46003_(player);
            if (player2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player2;
                NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)IMPPackets.MUSIC_RING_READY, (FriendlyByteBuf)new IMPPackets.MusicReadyMessage(this.infoUUID, this.ringerUUID, this.getRinger().getRingerMusicSource(), MusicRing.this.getPlaybackInfo(this.getRinger()), this.getRingerPosition()).toFBB());
                this.advancement(serverPlayer);
            }
        }

        private long getRingerPosition() {
            if (this.getRinger().isRingerStream()) {
                return 0L;
            }
            MusicSource sc = this.getRinger().getRingerMusicSource();
            return Mth.m_14053_((long)this.getRinger().getRingerPosition(), (long)0L, (long)(sc != null ? sc.getDuration() : 0L));
        }

        private void addReadyPlayer(ServerPlayer player, boolean result, boolean retry, long elapsed) {
            UUID id = player.m_36316_().getId();
            if (this.notWait) {
                if (this.middleLoadPlayers.contains(id)) {
                    if (result) {
                        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)IMPPackets.MUSIC_RING_STATE, (FriendlyByteBuf)new IMPPackets.MusicRingStateMessage(this.ringerUUID, this.infoUUID, 0, elapsed, MusicPlaybackInfo.EMPTY).toFBB());
                        this.listenPlayers.add(id);
                    } else {
                        this.failurePlayers.put(id, System.currentTimeMillis());
                    }
                    this.middleLoadPlayers.remove(id);
                }
            } else {
                if (result) {
                    this.listenPlayers.add(id);
                    this.firstReadyPlayers.add(id);
                } else {
                    this.failurePlayers.put(id, System.currentTimeMillis());
                }
                this.firstWaitPlayers.remove(id);
            }
        }

        private void startReadyWaitPlayers() {
            for (UUID pl : this.firstReadyPlayers) {
                Player player = MusicRing.this.getLevel().m_46003_(pl);
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)IMPPackets.MUSIC_RING_STATE, (FriendlyByteBuf)new IMPPackets.MusicRingStateMessage(this.ringerUUID, this.infoUUID, 0).toFBB());
                this.advancement(serverPlayer);
            }
        }

        private void responseUpdate(ServerPlayer player, int state) {
            UUID id = player.m_36316_().getId();
            if (this.listenPlayers.contains(id) && state != 1) {
                this.listenPlayers.remove(id);
            }
            if (this.middleLoadPlayers.contains(id) && state != 2) {
                this.middleLoadPlayers.remove(id);
            }
        }

        private void sendUpdate() {
            ServerPlayer serverPlayer;
            Player player;
            for (UUID player2 : this.listenPlayers) {
                player = MusicRing.this.getLevel().m_46003_(player2);
                if (!(player instanceof ServerPlayer)) continue;
                serverPlayer = (ServerPlayer)player;
                NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)IMPPackets.MUSIC_RING_STATE, (FriendlyByteBuf)new IMPPackets.MusicRingStateMessage(this.ringerUUID, this.infoUUID, 2, 0L, MusicRing.this.getPlaybackInfo(this.getRinger())).toFBB());
            }
            for (UUID player2 : this.middleLoadPlayers) {
                player = MusicRing.this.getLevel().m_46003_(player2);
                if (!(player instanceof ServerPlayer)) continue;
                serverPlayer = (ServerPlayer)player;
                NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)IMPPackets.MUSIC_RING_STATE, (FriendlyByteBuf)new IMPPackets.MusicRingStateMessage(this.ringerUUID, this.infoUUID, 2, 0L, MusicRing.this.getPlaybackInfo(this.getRinger())).toFBB());
            }
        }

        private boolean tick(long currentTime) {
            if (this.notWait) {
                ArrayList<UUID> nl = new ArrayList<UUID>();
                for (ServerPlayer player : MusicRing.this.getLevel().m_6907_()) {
                    UUID id;
                    if (!this.canListen((Player)player) || this.isFailureCoolDown(id = player.m_36316_().getId())) continue;
                    nl.add(id);
                    if (this.listenPlayers.contains(id) || this.middleLoadPlayers.contains(id)) continue;
                    this.sendMiddleStartPacket(id);
                    this.middleLoadPlayers.add(id);
                }
                for (UUID listenPlayer : this.listenPlayers) {
                    if (nl.contains(listenPlayer)) continue;
                    this.sendStopPackets(listenPlayer);
                }
                for (UUID middleLoadPlayer : this.middleLoadPlayers) {
                    if (nl.contains(middleLoadPlayer)) continue;
                    this.sendStopPackets(middleLoadPlayer);
                }
                this.listenPlayers.clear();
                this.listenPlayers.addAll(nl.stream().filter(n -> !this.middleLoadPlayers.contains(n)).toList());
                this.middleLoadPlayers.clear();
                this.middleLoadPlayers.addAll(nl.stream().filter(n -> !this.listenPlayers.contains(n)).toList());
                this.sendUpdate();
                return true;
            }
            if (this.canPlayPlayersCheck(currentTime)) {
                this.startReadyWaitPlayers();
                this.notWait = true;
                return true;
            }
            return false;
        }

        private boolean isFailureCoolDown(UUID player) {
            Long fr = this.failurePlayers.get(player);
            if (fr != null) {
                return System.currentTimeMillis() - fr <= MusicRing.getRetryTime();
            }
            return false;
        }

        private boolean canPlayPlayersCheck(long currentTime) {
            long eq = currentTime - this.startTime;
            if (eq > MusicRing.getMaxWaitTime()) {
                return true;
            }
            ArrayList<UUID> removes = new ArrayList<UUID>();
            for (UUID waiter : this.firstWaitPlayers) {
                Player pl = MusicRing.this.getLevel().m_46003_(waiter);
                if (pl != null && this.canListen(pl)) continue;
                removes.add(waiter);
            }
            this.firstWaitPlayers.removeAll(removes);
            return this.firstWaitPlayers.isEmpty();
        }

        private void advancement(ServerPlayer player) {
            IMPCriteriaTriggers.LISTEN_TO_MUSIC.trigger(player, this.getRinger().isRingerStream(), this.getRinger().isRingerRemote(), this.isKamesuta());
        }

        private boolean isKamesuta() {
            String ath = this.getRinger().getRingerMusicAuthor();
            return this.getRinger().getRingerAntenna().m_41786_().getString().equalsIgnoreCase("kamesuta") && ath != null && (ath.equalsIgnoreCase("kamesuta") || ath.equalsIgnoreCase("\u304b\u3081\u3059\u305f") || ath.equalsIgnoreCase("\u30ab\u30e1\u30b9\u30bf"));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean canListen(Player player) {
            if (player.f_19853_ != MusicRing.this.getLevel()) return false;
            double d = Math.sqrt(player.m_20238_(this.getRinger().getRingerSpatialPosition()));
            float f = this.getRinger().isRingerMute() ? 0.0f : this.getRinger().getRingerRange() + 30.0f;
            if (!(d <= (double)f)) return false;
            return true;
        }

        private IMusicRinger getRinger() {
            return MusicRing.this.ringers.get(this.ringerUUID);
        }

        private void depose() {
            for (UUID listenPlayer : this.listenPlayers) {
                this.sendStopPackets(listenPlayer);
            }
            for (UUID middleLoadPlayer : this.middleLoadPlayers) {
                this.sendStopPackets(middleLoadPlayer);
            }
        }
    }
}

