/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music;

import com.google.common.collect.ImmutableMap;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.client.lava.LavaPlayerManager;
import dev.felnull.imp.client.music.LoadCompleteListener;
import dev.felnull.imp.client.music.MusicEntry;
import dev.felnull.imp.client.music.player.MusicPlayer;
import dev.felnull.imp.client.music.speaker.MusicSpeaker;
import dev.felnull.imp.client.music.task.MusicEngineDestroyRunner;
import dev.felnull.imp.client.util.MusicUtils;
import dev.felnull.imp.entity.IRingerPartyParrot;
import dev.felnull.imp.include.dev.felnull.fnjl.concurrent.InvokeExecutor;
import dev.felnull.imp.music.MusicSpeakerInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.music.tracker.MusicTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MusicEngine {
    private static final Logger LOGGER = LogManager.getLogger(MusicEngine.class);
    private static final MusicEngine INSTANCE = new MusicEngine();
    private static final Minecraft mc = Minecraft.m_91087_();
    private final Map<UUID, MusicEntry> musicEntries = new HashMap<UUID, MusicEntry>();
    private final InvokeExecutor musicTickExecutor = new InvokeExecutor();
    private ExecutorService musicLoaderExecutor = this.createMusicLoadExecutor();
    private MusicEngineDestroyRunner musicDestroyRunner = new MusicEngineDestroyRunner();
    private long lastProsesTime;
    public boolean reloadFlag;

    public static MusicEngine getInstance() {
        return INSTANCE;
    }

    public String getDebugString() {
        return String.format("[%s] SPK: %d/%d, LOAD: %d/%d, WKR: %d, TASK %d, TICK: %d ms", IamMusicPlayer.getModName(), this.getCurrentMusicSpeaker(), this.getMaxMusicSpeaker(), this.getCurrentMusicLoad(), this.getMaxMusicLoad(), this.getCurrentMusicLoader(), this.getCurrentMusicTaskCount(), this.lastProsesTime);
    }

    @Nullable
    public MusicEntry getMusicEntry(@NotNull UUID musicPlayerId) {
        return this.musicEntries.get(musicPlayerId);
    }

    public int getMaxMusicLoad() {
        return Math.max(IamMusicPlayer.CONFIG.maxPlayCont, 0);
    }

    public int getMaxMusicSpeaker() {
        return Math.max(IamMusicPlayer.CONFIG.maxPlayCont, 0);
    }

    public int getCurrentMusicLoad() {
        return this.musicEntries.size();
    }

    public int getCurrentMusicSpeaker() {
        int ct = 0;
        for (MusicEntry value : this.musicEntries.values()) {
            ct += value.getSpeakerCount();
        }
        return ct;
    }

    public int getCurrentMusicLoader() {
        ExecutorService executorService = this.musicLoaderExecutor;
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            return threadPoolExecutor.getActiveCount();
        }
        return -1;
    }

    public int getCurrentMusicTaskCount() {
        int ct = 0;
        for (MusicEntry value : this.musicEntries.values()) {
            ct += value.getTaskCount();
        }
        return this.musicTickExecutor.getTaskCount();
    }

    public void tick() {
        long startTime = System.currentTimeMillis();
        MusicUtils.runInvokeTasks(this.musicTickExecutor, "Music Engine");
        ArrayList destroys = new ArrayList();
        this.musicEntries.forEach((uuid, musicEntry) -> {
            if (!musicEntry.tick()) {
                destroys.add(uuid);
            }
        });
        for (UUID destroy : destroys) {
            this.musicEntries.remove(destroy);
        }
        this.lastProsesTime = System.currentTimeMillis() - startTime;
    }

    public void stopAll() {
        if (this.reloadFlag) {
            this.reloadFlag = false;
            return;
        }
        ArrayList<UUID> musicPlayerIds = new ArrayList<UUID>(this.musicEntries.keySet());
        for (UUID musicPlayerId : musicPlayerIds) {
            this.stop(musicPlayerId);
        }
    }

    public void destroy() {
        this.getLogger().info("Music engine reloaded");
        this.stopAll();
        this.musicDestroyRunner.destroy();
        this.musicDestroyRunner = new MusicEngineDestroyRunner();
        if (this.musicLoaderExecutor != null) {
            this.musicLoaderExecutor.shutdown();
        }
        this.musicLoaderExecutor = this.createMusicLoadExecutor();
        LavaPlayerManager.getInstance().reload();
    }

    public void pause() {
        for (MusicEntry value : this.musicEntries.values()) {
            value.pause();
        }
    }

    public void resume() {
        for (MusicEntry value : this.musicEntries.values()) {
            value.resume();
        }
    }

    private ExecutorService createMusicLoadExecutor() {
        return Executors.newCachedThreadPool((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("IMP-Music-Loader-%d").daemon(true).build());
    }

    public ExecutorService getMusicAsyncExecutor() {
        return this.musicLoaderExecutor;
    }

    public MusicEngineDestroyRunner getMusicDestroyRunner() {
        return this.musicDestroyRunner;
    }

    public Executor getMusicTickExecutor() {
        return this.musicTickExecutor;
    }

    public boolean load(@NotNull UUID musicPlayerId, @NotNull MusicSource source, long position, @NotNull LoadCompleteListener listener) {
        if (this.getCurrentMusicLoad() >= this.getMaxMusicLoad()) {
            return false;
        }
        if (this.isExist(musicPlayerId)) {
            return false;
        }
        MusicEntry mpe = new MusicEntry(musicPlayerId, source, position);
        this.musicEntries.put(musicPlayerId, mpe);
        mpe.loadStart(listener);
        return true;
    }

    public boolean loadAndPlay(@NotNull UUID musicPlayerId, @NotNull MusicSource source, long position, boolean delayed) {
        return this.load(musicPlayerId, source, position, (success, time, error, retry) -> {
            if (success) {
                this.play(musicPlayerId, delayed ? time : 0L);
            }
        });
    }

    public boolean play(@NotNull UUID musicPlayerId, long delay) {
        MusicEntry mpe = this.musicEntries.get(musicPlayerId);
        if (mpe == null || !mpe.isLoaded()) {
            return false;
        }
        if (mpe.getMusicPlayer() != null) {
            for (MusicSpeaker musicSpeaker : mpe.getMusicPlayer().getSpeakerList()) {
                this.notifyRangeEntities(musicPlayerId, musicSpeaker.getTracker().getSpeakerInfo());
            }
        }
        mpe.playStart(delay);
        return true;
    }

    public boolean stop(UUID musicPlayerId) {
        MusicEntry mpe = this.musicEntries.remove(musicPlayerId);
        if (mpe == null) {
            return false;
        }
        mpe.destroy();
        return true;
    }

    public boolean addSpeaker(@NotNull UUID musicPlayerId, @NotNull UUID speakerId, MusicTracker tracker) {
        if (this.getCurrentMusicSpeaker() >= this.getMaxMusicSpeaker()) {
            return false;
        }
        MusicEntry mpe = this.musicEntries.get(musicPlayerId);
        if (mpe == null) {
            return false;
        }
        return mpe.addSpeaker(speakerId, tracker);
    }

    public boolean removeSpeaker(@NotNull UUID musicPlayerId, @NotNull UUID speakerId) {
        MusicEntry mpe = this.musicEntries.get(musicPlayerId);
        if (mpe == null) {
            return false;
        }
        return mpe.removeSpeaker(speakerId);
    }

    public boolean isExist(UUID musicPlayerId) {
        return this.musicEntries.containsKey(musicPlayerId);
    }

    public boolean isLoading(UUID musicPlayerId) {
        MusicEntry me = this.musicEntries.get(musicPlayerId);
        if (me != null) {
            return !me.isLoaded();
        }
        return false;
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public Map<UUID, MusicEntry> getMusicEntries() {
        return ImmutableMap.copyOf(this.musicEntries);
    }

    public Map<UUID, MusicPlayer<?, ?>> getMusicPlayers() {
        ImmutableMap.Builder musicPlayersBuilder = ImmutableMap.builder();
        for (Map.Entry<UUID, MusicEntry> entry : this.musicEntries.entrySet()) {
            MusicPlayer<?, ?> player = entry.getValue().getMusicPlayer();
            if (player == null) continue;
            musicPlayersBuilder.put((Object)entry.getKey(), player);
        }
        return musicPlayersBuilder.build();
    }

    public boolean loadAndPlaySimple(@NotNull UUID musicPlayerId, @NotNull MusicTracker musicTracker, @NotNull MusicSource source, long position, boolean delayed) {
        boolean ret = this.load(musicPlayerId, source, position, (success, time, error, retry) -> {
            if (success) {
                this.play(musicPlayerId, delayed ? time : 0L);
            }
        });
        if (ret) {
            this.addSpeaker(musicPlayerId, musicPlayerId, musicTracker);
        }
        return ret;
    }

    public boolean updateMusicTracker(@NotNull UUID musicPlayerId, @NotNull UUID speakerId, MusicTracker musicTracker) {
        if (musicTracker == null) {
            return false;
        }
        MusicEntry mpe = this.musicEntries.get(musicPlayerId);
        if (mpe == null) {
            return false;
        }
        return mpe.updateMusicTracker(speakerId, musicTracker);
    }

    public boolean isPlaying(@NotNull UUID musicPlayerId) {
        MusicEntry mpe = this.musicEntries.get(musicPlayerId);
        if (mpe == null) {
            return false;
        }
        MusicPlayer<?, ?> mp = mpe.getMusicPlayer();
        if (mp == null) {
            return false;
        }
        return mp.isPlaying();
    }

    private void notifyRangeEntities(UUID uuid, MusicSpeakerInfo speakerInfo) {
        if (MusicEngine.mc.f_91073_ == null) {
            return;
        }
        Vec3 v3 = speakerInfo.position();
        AABB aabb = new AABB(new BlockPos(v3)).m_82400_((double)speakerInfo.getRange());
        for (LivingEntity livingentity : MusicEngine.mc.f_91073_.m_45976_(LivingEntity.class, aabb)) {
            if (!(livingentity instanceof IRingerPartyParrot)) continue;
            IRingerPartyParrot ringerPartyParrot = (IRingerPartyParrot)livingentity;
            ringerPartyParrot.setRingerUUID(uuid);
        }
    }
}

