/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.include.dev.felnull.fnjl.math.FNVec2d;
import dev.felnull.imp.include.dev.felnull.fnjl.util.FNMath;
import dev.felnull.imp.include.dev.felnull.fnjl.util.FNURLUtil;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import dev.felnull.otyacraftengine.client.util.OETextureUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.lang3.tuple.Pair;

public class PlayImageRenderer {
    private static final ResourceLocation MISSING_YOUTUBE_THUMBNAIL_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/image/missing_youtube_thumbnail.png");
    private static final ResourceLocation MISSING_SOUND_CLOUD_ARTWORK_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/image/missing_sound_cloud_artwork.png");
    private static final PlayImageRenderer INSTANCE = new PlayImageRenderer();
    private static final String YOUTUBE_THUMBNAIL_URL = "https://i.ytimg.com/vi/%s/hqdefault.jpg";
    private final Map<String, String> soundCloudArtworkURLs = new HashMap<String, String>();

    public static PlayImageRenderer getInstance() {
        return INSTANCE;
    }

    public void draw(ImageInfo imageInfo, PoseStack poseStack, float x, float y, int size) {
        this.draw(imageInfo, poseStack, x, y, size, true);
    }

    public void draw(ImageInfo imageInfo, PoseStack poseStack, float x, float y, float size, boolean cash) {
        if (imageInfo.isEmpty()) {
            return;
        }
        if (imageInfo.getImageType() == ImageInfo.ImageType.PLAYER_FACE) {
            this.drawPlayerFaceImage(imageInfo.getIdentifier(), poseStack, x, y, size);
            return;
        }
        Pair<ResourceLocation, Vec2> td = this.getImageTexture(imageInfo, cash);
        if (td != null) {
            this.drawTextureImage((ResourceLocation)td.getLeft(), poseStack, ((Vec2)td.getRight()).f_82470_, ((Vec2)td.getRight()).f_82471_, x, y, size);
        }
    }

    public void drawPlayerFaceImage(String name, PoseStack poseStack, float x, float y, float size) {
        ResourceLocation texture = OETextureUtil.getPlayerSkinTexture((String)name);
        OERenderUtil.drawTexture((ResourceLocation)texture, (PoseStack)poseStack, (float)x, (float)y, (float)size, (float)size, (float)size, (float)size, (float)(size * 8.0f), (float)(size * 8.0f));
        OERenderUtil.drawTexture((ResourceLocation)texture, (PoseStack)poseStack, (float)x, (float)y, (float)(size * 5.0f), (float)size, (float)size, (float)size, (float)(size * 8.0f), (float)(size * 8.0f));
    }

    private void drawTextureImage(ResourceLocation location, PoseStack poseStack, float wScale, float hScale, float x, float y, float size) {
        if (location == null) {
            return;
        }
        float w = size * wScale;
        float h = size * hScale;
        OERenderUtil.drawTexture((ResourceLocation)location, (PoseStack)poseStack, (float)(x + (size - w) / 2.0f), (float)(y + (size - h) / 2.0f), (float)0.0f, (float)0.0f, (float)w, (float)h, (float)w, (float)h);
    }

    public void renderSprite(ImageInfo imageInfo, PoseStack poseStack, MultiBufferSource multiBufferSource, float x, float y, float z, float size, int i, int j) {
        this.renderSprite(imageInfo, poseStack, multiBufferSource, x, y, z, size, i, j, true);
    }

    public void renderSprite(ImageInfo imageInfo, PoseStack poseStack, MultiBufferSource multiBufferSource, float x, float y, float z, float size, int i, int j, boolean cash) {
        if (imageInfo.isEmpty()) {
            return;
        }
        if (imageInfo.getImageType() == ImageInfo.ImageType.PLAYER_FACE) {
            this.renderPlayerFaceImageSprite(imageInfo.getIdentifier(), poseStack, multiBufferSource, x, y, z, size, i, j);
            return;
        }
        Pair<ResourceLocation, Vec2> td = this.getImageTexture(imageInfo, cash);
        if (td != null) {
            this.renderTextureImageSprite((ResourceLocation)td.getLeft(), poseStack, multiBufferSource, ((Vec2)td.getRight()).f_82470_, ((Vec2)td.getRight()).f_82471_, x, y, z, size, i, j);
        }
    }

    private void renderPlayerFaceImageSprite(String name, PoseStack poseStack, MultiBufferSource multiBufferSource, float x, float y, float z, float size, int i, int j) {
        OERenderUtil.renderPlayerFaceSprite((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (String)name, (float)x, (float)y, (float)z, (float)0.0f, (float)0.0f, (float)0.0f, (float)size, (int)i, (int)j);
    }

    private void renderTextureImageSprite(ResourceLocation location, PoseStack poseStack, MultiBufferSource multiBufferSource, float wScale, float hScale, float x, float y, float z, float size, int i, int j) {
        if (location == null) {
            return;
        }
        float w = size * wScale;
        float h = size * hScale;
        OERenderUtil.renderTextureSprite((ResourceLocation)location, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (float)(x + (size - w) / 2.0f), (float)(y + (size - h) / 2.0f), (float)z, (float)0.0f, (float)0.0f, (float)0.0f, (float)w, (float)h, (float)0.0f, (float)0.0f, (float)w, (float)h, (float)w, (float)h, (int)i, (int)j);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<ResourceLocation, Vec2> getImageTexture(ImageInfo imageInfo, boolean cash) {
        if (imageInfo.getImageType() == ImageInfo.ImageType.URL) {
            ResourceLocation loc = OETextureUtil.getURLTextureAsyncLoad((String)imageInfo.getIdentifier(), (boolean)cash);
            OETextureUtil.TextureScale scale = OETextureUtil.getTextureScale((ResourceLocation)loc);
            float w = 1.0f;
            float h = 1.0f;
            if (scale != null) {
                w = (float)scale.w();
                h = (float)scale.h();
            }
            return Pair.of((Object)loc, (Object)new Vec2(w, h));
        }
        if (imageInfo.getImageType() == ImageInfo.ImageType.YOUTUBE_THUMBNAIL) {
            ResourceLocation loc = OETextureUtil.getURLTextureAsyncLoad((String)String.format(YOUTUBE_THUMBNAIL_URL, imageInfo.getIdentifier()), (boolean)cash, (ResourceLocation)MISSING_YOUTUBE_THUMBNAIL_TEXTURE);
            OETextureUtil.TextureScale scale = OETextureUtil.getTextureScale((ResourceLocation)loc);
            float w = 1.0f;
            float h = 1.0f;
            if (loc == MISSING_YOUTUBE_THUMBNAIL_TEXTURE) {
                FNVec2d st = FNMath.scale(120.0, 90.0);
                w = (float)st.getX();
                h = (float)st.getY();
            } else if (scale != null) {
                w = (float)scale.w();
                h = (float)scale.h();
            }
            return Pair.of((Object)loc, (Object)new Vec2(w, h));
        }
        if (imageInfo.getImageType() == ImageInfo.ImageType.SOUND_CLOUD_ARTWORK) {
            String idf = imageInfo.getIdentifier();
            Map<String, String> map = this.soundCloudArtworkURLs;
            synchronized (map) {
                if (this.soundCloudArtworkURLs.containsKey(idf)) {
                    String url = this.soundCloudArtworkURLs.get(idf);
                    if (url != null) {
                        ResourceLocation loc = OETextureUtil.getURLTextureAsyncLoad((String)url, (boolean)cash, (ResourceLocation)MISSING_SOUND_CLOUD_ARTWORK_TEXTURE);
                        OETextureUtil.TextureScale scale = OETextureUtil.getTextureScale((ResourceLocation)loc);
                        float w = 1.0f;
                        float h = 1.0f;
                        if (scale != null) {
                            w = (float)scale.w();
                            h = (float)scale.h();
                        }
                        return Pair.of((Object)loc, (Object)new Vec2(w, h));
                    }
                    return Pair.of((Object)MISSING_SOUND_CLOUD_ARTWORK_TEXTURE, (Object)new Vec2(1.0f, 1.0f));
                }
                this.soundCloudArtworkURLs.put(idf, null);
                SoundCloudImageLoadThread lt = new SoundCloudImageLoadThread(idf);
                lt.start();
                return Pair.of((Object)MISSING_SOUND_CLOUD_ARTWORK_TEXTURE, (Object)new Vec2(1.0f, 1.0f));
            }
        }
        return null;
    }

    private class SoundCloudImageLoadThread
    extends Thread {
        private static final String IMG_ST = "<img ";
        private static final String IMG_END = ">";
        private static final String SRC_ST = "src=\"";
        private static final String SRC_END = "\"";
        private final String url;

        public SoundCloudImageLoadThread(String url) {
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String src;
            try {
                src = SoundCloudImageLoadThread.extractImage(FNURLUtil.getResponse(new URL(this.url)));
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            Map<String, String> map = PlayImageRenderer.this.soundCloudArtworkURLs;
            synchronized (map) {
                PlayImageRenderer.this.soundCloudArtworkURLs.put(this.url, src);
            }
        }

        private static String extractImage(String src) {
            String ts = src.substring(src.indexOf(IMG_ST) + IMG_ST.length());
            ts = ts.substring(0, ts.indexOf(IMG_END));
            ts = ts.substring(ts.indexOf(SRC_ST) + SRC_ST.length());
            ts = ts.substring(0, ts.indexOf(SRC_END));
            return ts;
        }
    }
}

