/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.data;

import dev.felnull.imp.item.CassetteTapeItem;
import dev.felnull.imp.item.IMPItems;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.server.music.MusicManager;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.imp.util.IMPNbtUtil;
import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoomboxData {
    private final Map<UUID, UUID> playerSelectPlaylists = new HashMap<UUID, UUID>();
    private final DataAccess access;
    private MonitorType monitorType = MonitorType.OFF;
    private MonitorType lastMonitorType = MonitorType.OFF;
    private boolean handleRaising = true;
    private boolean lidOpen;
    private int handleRaisedProgressOld = this.getHandleRaisedMax();
    private int handleRaisedProgress = this.getHandleRaisedMax();
    private int lidOpenProgressOld;
    private int lidOpenProgress;
    private int parabolicAntennaProgressOld;
    private int parabolicAntennaProgress;
    private int antennaProgressOld;
    private int antennaProgress;
    private ItemStack oldCassetteTape = ItemStack.f_41583_;
    private boolean oldCassetteTapeFlg;
    private boolean changeCassetteTape;
    private boolean playing;
    private int volume = 150;
    private boolean loop;
    private boolean mute;
    private long musicPosition;
    private boolean loadingMusic;
    private String radioUrl = "";
    private MusicSource radioSource = MusicSource.EMPTY;
    private ImageInfo radioImage = ImageInfo.EMPTY;
    private String radioName = "";
    private String radioAuthor = "";
    private Music selectedMusic;
    private ContinuousType continuousType = ContinuousType.NONE;
    private boolean radioStartFlg;
    private boolean noChangeCassetteTape;

    public BoomboxData(CompoundTag boomboxTag, @NotNull DataAccess access) {
        this.access = access;
        if (boomboxTag != null) {
            this.load(boomboxTag.m_128469_("BoomBoxData"), true, true);
        }
    }

    public void tick(Level level) {
        this.handleRaisedProgressOld = this.handleRaisedProgress;
        this.lidOpenProgressOld = this.lidOpenProgress;
        this.antennaProgressOld = this.antennaProgress;
        this.parabolicAntennaProgressOld = this.parabolicAntennaProgress;
        this.handleRaisedProgress = this.handleRaising ? Mth.m_14045_((int)(this.handleRaisedProgress + 1), (int)0, (int)this.getHandleRaisedMax()) : Mth.m_14045_((int)(this.handleRaisedProgress - 1), (int)0, (int)this.getHandleRaisedMax());
        this.lidOpenProgress = this.lidOpen ? Mth.m_14045_((int)(this.lidOpenProgress + 1), (int)0, (int)this.getLidOpenProgressMax()) : Mth.m_14045_((int)(this.lidOpenProgress - 1), (int)0, (int)this.getLidOpenProgressMax());
        this.antennaProgress = this.isUseAntenna() && this.isRadioStream() ? Mth.m_14045_((int)(this.antennaProgress + 1), (int)0, (int)30) : Mth.m_14045_((int)(this.antennaProgress - 1), (int)0, (int)30);
        if (this.isPowered() && this.isUseAntenna() && this.isAntennaExist() && this.getAntenna().m_150930_((Item)IMPItems.PARABOLIC_ANTENNA.get())) {
            this.parabolicAntennaProgress += 2;
        }
        if (!level.m_5776_()) {
            if (this.getRinger() != null) {
                this.loadingMusic = this.getRinger().isRingerWait();
            }
            if (this.isPowered() && this.monitorType == MonitorType.OFF) {
                this.monitorType = MonitorType.PLAYBACK;
            }
            if (!this.isPowered() && this.monitorType != MonitorType.OFF) {
                this.monitorType = MonitorType.OFF;
            }
            if (this.monitorType != this.lastMonitorType) {
                this.lastMonitorType = this.monitorType;
                this.setMusicPosition(0L);
                this.setPlaying(false);
            }
            if (!this.canPlay()) {
                this.setMusicPosition(0L);
                this.setPlaying(false);
            }
            if (!this.isRadioRemote()) {
                this.playerSelectPlaylists.clear();
                this.setSelectedMusic(null);
                this.setContinuousType(ContinuousType.NONE);
            }
            if (this.radioStartFlg) {
                this.setRadioStartFlg(false);
                this.setPlaying(true);
            }
            if (this.monitorType == MonitorType.REMOTE_PLAYBACK && this.getSelectedMusic() == null) {
                this.monitorType = MonitorType.REMOTE_PLAYBACK_SELECT;
            }
            if (this.monitorType == MonitorType.RADIO && this.getRadioSource().isEmpty()) {
                this.monitorType = MonitorType.RADIO_SELECT;
            }
            if ((this.isRadio() && !this.isAntennaExist() || this.isRadioRemote() && !IMPItemUtil.isRemotePlayBackAntenna(this.getAntenna()) || this.isRadioStream() && IMPItemUtil.isRemotePlayBackAntenna(this.getAntenna())) && (this.isRadioRemote() && !IMPItemUtil.isRemotePlayBackAntenna(this.getAntenna()) || this.isRadioStream() && !IMPItemUtil.isRadioAntenna(this.getAntenna()))) {
                this.monitorType = MonitorType.PLAYBACK;
            }
            if (!this.isRadioStream()) {
                this.setRadioImage(ImageInfo.EMPTY);
                this.setRadioSource(MusicSource.EMPTY);
                this.setRadioAuthor("");
                this.setRadioName("");
                this.setRadioUrl("");
            }
            if (this.monitorType != MonitorType.RADIO_SELECT) {
                this.setRadioUrl("");
            }
            if (this.changeCassetteTape) {
                if (!this.isLidOpen()) {
                    this.startLidOpen(true, level);
                }
                if (this.getLidOpenProgress() >= this.getLidOpenProgressMax()) {
                    this.changeCassetteTape = false;
                    this.startLidOpen(false, level);
                }
            }
        }
    }

    public boolean canPlay() {
        boolean canPlayFlg = this.monitorType == MonitorType.PLAYBACK && this.isMusicCassetteTapeExist();
        boolean canPlayFlg2 = this.monitorType == MonitorType.RADIO && !this.getRadioSource().isEmpty();
        boolean canPlayFlg3 = this.monitorType == MonitorType.REMOTE_PLAYBACK;
        return canPlayFlg || canPlayFlg2 || canPlayFlg3;
    }

    public CompoundTag onInstruction(ServerPlayer player, String name, int num, CompoundTag data) {
        if ("buttons_press".equals(name)) {
            ButtonType type = ButtonType.getByName(data.m_128461_("Type"));
            switch (type) {
                case POWER: {
                    this.setPower(!this.isPowered());
                    break;
                }
                case LOOP: {
                    this.setLoop(!this.isLoop());
                    break;
                }
                case VOL_DOWN: {
                    if (!this.isPowered()) break;
                    this.setVolume(Mth.m_14045_((int)(this.volume - 10), (int)0, (int)300));
                    break;
                }
                case VOL_UP: {
                    if (this.isPowered()) {
                        this.setVolume(Mth.m_14045_((int)(this.volume + 10), (int)0, (int)300));
                    }
                    this.setMute(false);
                    break;
                }
                case VOL_MUTE: {
                    this.setMute(!this.isMute());
                    break;
                }
                case VOL_MAX: {
                    if (this.isPowered()) {
                        this.setVolume(300);
                    }
                    this.setMute(false);
                    break;
                }
                case RADIO: {
                    if (this.isRadio()) {
                        this.setMonitorType(MonitorType.PLAYBACK);
                        break;
                    }
                    this.setPower(true);
                    this.setRadioMode();
                    break;
                }
                case START: {
                    if (!this.isMusicCassetteTapeExist() && !this.isRadio()) break;
                    this.setPower(true);
                    this.setPlaying(true);
                    break;
                }
                case STOP: {
                    if (!this.isPowered()) break;
                    this.setPlaying(false);
                    this.setMusicPosition(0L);
                    break;
                }
                case PAUSE: {
                    if (!this.isPowered()) break;
                    this.setPlaying(false);
                    if (!this.isRadioStream()) break;
                    this.setMusicPosition(0L);
                }
            }
            return null;
        }
        if ("set_volume".equals(name)) {
            if (this.isPowered()) {
                this.setVolume(data.m_128451_("volume"));
            }
            return null;
        }
        if ("set_playing".equals(name)) {
            if (this.isPowered()) {
                boolean pl = data.m_128471_("playing");
                this.setPlaying(pl);
                if (!pl) {
                    this.setMusicPosition(0L);
                }
            }
            return null;
        }
        if ("set_pause".equals(name)) {
            if (this.isPowered()) {
                this.setPlaying(false);
            }
            return null;
        }
        if ("set_loop".equals(name)) {
            if (this.isPowered()) {
                this.setLoop(data.m_128471_("loop"));
            }
            return null;
        }
        if ("restat_and_set_position".equals(name)) {
            if (this.isPowered()) {
                this.setMusicPositionAndRestart(data.m_128454_("position"));
            }
            return null;
        }
        if ("set_radio_url".equals(name)) {
            if (this.isPowered()) {
                this.setRadioUrl(data.m_128461_("url"));
            }
            return null;
        }
        if ("set_monitor".equals(name)) {
            if (this.isPowered()) {
                MonitorType m = MonitorType.getByName(data.m_128461_("name"));
                this.setMonitorType(m);
                if (m == MonitorType.RADIO && this.getRadioSource() != null && !this.getRadioSource().isEmpty() || m == MonitorType.REMOTE_PLAYBACK && this.getSelectedMusic() != null && !this.getSelectedMusic().getSource().isEmpty()) {
                    this.setRadioStartFlg(true);
                }
            }
            return null;
        }
        if ("set_radio_source".equals(name)) {
            if (this.isPowered()) {
                this.setRadioSource((MusicSource)OENbtUtil.readSerializable((CompoundTag)data, (String)"source", (ITAGSerializable)new MusicSource()));
            }
            return null;
        }
        if ("set_radio_image".equals(name)) {
            if (this.isPowered()) {
                this.setRadioImage((ImageInfo)OENbtUtil.readSerializable((CompoundTag)data, (String)"image", (ITAGSerializable)new ImageInfo()));
            }
            return null;
        }
        if ("set_radio_name".equals(name)) {
            if (this.isPowered()) {
                this.setRadioName(data.m_128461_("name"));
            }
            return null;
        }
        if ("set_radio_author".equals(name)) {
            if (this.isPowered()) {
                this.setRadioAuthor(data.m_128461_("author"));
            }
            return null;
        }
        if ("set_selected_play_list".equals(name)) {
            if (this.isPowered() && this.isRadioRemote()) {
                if (data.m_128441_("pl")) {
                    UUID uuid = data.m_128342_("pl");
                    MusicPlayList pl = MusicManager.getInstance().getSaveData().getPlayLists().get(uuid);
                    if (pl != null && pl.getAuthority().getAuthorityType(player.m_36316_().getId()).isMoreReadOnly()) {
                        this.setSelectedPlayList(player, uuid);
                    }
                } else {
                    this.setSelectedPlayList(player, null);
                }
            }
            return null;
        }
        if ("set_selected_music".equals(name)) {
            if (this.isPowered() && this.isRadioRemote()) {
                if (data.m_128441_("m")) {
                    MusicPlayList pl;
                    UUID uuid = data.m_128342_("m");
                    Music m = MusicManager.getInstance().getSaveData().getMusics().get(uuid);
                    if (m != null && (pl = MusicManager.getInstance().getPlaylistByMusic(m.getUuid())) != null && pl.getAuthority().getAuthorityType(player.m_36316_().getId()).isMoreReadOnly()) {
                        this.setSelectedMusic(m);
                    }
                } else {
                    this.setSelectedMusic(null);
                }
            }
            return null;
        }
        if ("set_continuous_type".equals(name)) {
            if (this.isPowered() && this.isRadioRemote()) {
                this.setContinuousType(ContinuousType.getByName(data.m_128461_("type")));
            }
            return null;
        }
        return null;
    }

    public void onCassetteTapeChange(ItemStack newItem, ItemStack oldItem) {
        if (!this.oldCassetteTapeFlg) {
            this.oldCassetteTape = oldItem.m_41777_();
        }
        this.oldCassetteTapeFlg = false;
        if (!this.isRadio()) {
            this.setMusicPosition(0L);
            this.setPlaying(false);
        }
        if (!newItem.m_41619_() || !this.isLidOpen()) {
            this.changeCassetteTape = true;
        }
        this.update();
    }

    public void setOldCassetteTape(ItemStack oldCassetteTape) {
        this.oldCassetteTape = oldCassetteTape;
        this.oldCassetteTapeFlg = true;
        this.update();
    }

    public CompoundTag save(CompoundTag tag, boolean absolutely, boolean sync) {
        tag.m_128359_("MonitorType", this.monitorType.getName());
        tag.m_128379_("HandleRaising", this.handleRaising);
        tag.m_128379_("LidOpen", this.lidOpen);
        tag.m_128379_("Playing", this.playing);
        tag.m_128405_("Volume", this.volume);
        tag.m_128379_("Loop", this.loop);
        tag.m_128379_("Mute", this.mute);
        tag.m_128356_("RingerPosition", this.musicPosition);
        tag.m_128359_("RadioUrl", this.radioUrl);
        OENbtUtil.writeSerializable((CompoundTag)tag, (String)"RadioSource", (ITAGSerializable)this.radioSource);
        OENbtUtil.writeSerializable((CompoundTag)tag, (String)"RadioImage", (ITAGSerializable)this.radioImage);
        tag.m_128359_("RadioName", this.radioName);
        tag.m_128359_("RadioAuthor", this.radioAuthor);
        IMPNbtUtil.writeUUIDMap(tag, "PlayerSelectPlaylists", this.playerSelectPlaylists);
        if (this.selectedMusic != null) {
            OENbtUtil.writeSerializable((CompoundTag)tag, (String)"SelectedMusic", (ITAGSerializable)this.selectedMusic);
        }
        tag.m_128359_("ContinuousType", this.continuousType.getName());
        if (absolutely) {
            tag.m_128405_("HandleRaisedProgressOld", this.handleRaisedProgressOld);
            tag.m_128405_("HandleRaisedProgress", this.handleRaisedProgress);
            tag.m_128405_("LidOpenProgressOld", this.lidOpenProgressOld);
            tag.m_128405_("LidOpenProgress", this.lidOpenProgress);
            tag.m_128405_("ParabolicAntennaProgressOld", this.parabolicAntennaProgressOld);
            tag.m_128405_("ParabolicAntennaProgress", this.parabolicAntennaProgress);
            tag.m_128405_("AntennaProgressOld", this.antennaProgressOld);
            tag.m_128405_("AntennaProgress", this.antennaProgress);
            tag.m_128359_("LastMonitorType", this.lastMonitorType.getName());
            tag.m_128379_("NoChangeCassetteTape", this.noChangeCassetteTape);
        }
        if (absolutely || sync) {
            tag.m_128379_("ChangeCassetteTape", this.changeCassetteTape);
            tag.m_128365_("OldCassetteTape", (Tag)this.oldCassetteTape.m_41739_(new CompoundTag()));
            tag.m_128379_("OldCassetteTapeFlg", this.oldCassetteTapeFlg);
            tag.m_128379_("LoadingMusic", this.loadingMusic);
            tag.m_128379_("RadioStartFlg", this.radioStartFlg);
        }
        return tag;
    }

    public void load(CompoundTag tag, boolean absolutely, boolean sync) {
        this.monitorType = MonitorType.getByName(tag.m_128461_("MonitorType"));
        this.handleRaising = tag.m_128471_("HandleRaising");
        this.lidOpen = tag.m_128471_("LidOpen");
        this.playing = tag.m_128471_("Playing");
        if (tag.m_128441_("Volume")) {
            this.volume = tag.m_128451_("Volume");
        }
        this.loop = tag.m_128471_("Loop");
        this.mute = tag.m_128471_("Mute");
        this.musicPosition = tag.m_128454_("RingerPosition");
        this.radioUrl = tag.m_128461_("RadioUrl");
        this.radioSource = (MusicSource)OENbtUtil.readSerializable((CompoundTag)tag, (String)"RadioSource", (ITAGSerializable)new MusicSource());
        this.radioImage = (ImageInfo)OENbtUtil.readSerializable((CompoundTag)tag, (String)"RadioImage", (ITAGSerializable)new ImageInfo());
        this.radioName = tag.m_128461_("RadioName");
        this.radioAuthor = tag.m_128461_("RadioAuthor");
        IMPNbtUtil.readUUIDMap(tag, "PlayerSelectPlaylists", this.playerSelectPlaylists);
        this.continuousType = ContinuousType.getByName(tag.m_128461_("ContinuousType"));
        if (tag.m_128441_("SelectedMusic")) {
            this.selectedMusic = (Music)OENbtUtil.readSerializable((CompoundTag)tag, (String)"SelectedMusic", (ITAGSerializable)new Music());
        }
        if (absolutely) {
            this.handleRaisedProgressOld = tag.m_128451_("HandleRaisedProgressOld");
            this.handleRaisedProgress = tag.m_128451_("HandleRaisedProgress");
            this.lidOpenProgressOld = tag.m_128451_("LidOpenProgressOld");
            this.lidOpenProgress = tag.m_128451_("LidOpenProgress");
            this.parabolicAntennaProgressOld = tag.m_128451_("ParabolicAntennaProgressOld");
            this.parabolicAntennaProgress = tag.m_128451_("ParabolicAntennaProgress");
            this.antennaProgressOld = tag.m_128451_("AntennaProgressOld");
            this.antennaProgress = tag.m_128451_("AntennaProgress");
            this.lastMonitorType = MonitorType.getByName(tag.m_128461_("LastMonitorType"));
            this.noChangeCassetteTape = tag.m_128471_("NoChangeCassetteTape");
        }
        if (absolutely || sync) {
            this.changeCassetteTape = tag.m_128471_("ChangeCassetteTape");
            this.oldCassetteTape = ItemStack.m_41712_((CompoundTag)tag.m_128469_("OldCassetteTape"));
            this.oldCassetteTapeFlg = tag.m_128471_("OldCassetteTapeFlg");
            this.loadingMusic = tag.m_128471_("LoadingMusic");
            this.radioStartFlg = tag.m_128471_("RadioStartFlg");
        }
        if (!sync) {
            if (this.handleRaising) {
                this.handleRaisedProgress = this.getHandleRaisedMax();
            }
            if (this.lidOpen) {
                this.lidOpenProgress = this.getLidOpenProgressMax();
            }
        }
    }

    public void setNoChangeCassetteTape(boolean noChangeCassetteTape) {
        this.noChangeCassetteTape = noChangeCassetteTape;
    }

    public boolean isNoChangeCassetteTape() {
        return this.noChangeCassetteTape;
    }

    public void setRadioSource(MusicSource radioSource) {
        this.radioSource = radioSource;
        this.update();
    }

    public void setRadioImage(ImageInfo radioImage) {
        this.radioImage = radioImage;
        this.update();
    }

    public MusicSource getRadioSource() {
        return this.radioSource;
    }

    public ImageInfo getRadioImage() {
        return this.radioImage;
    }

    public void setRadioUrl(String radioUrl) {
        this.radioUrl = radioUrl;
        this.update();
    }

    public void setRadioName(String radioName) {
        this.radioName = radioName;
        this.update();
    }

    public void setRadioAuthor(String radioAuthor) {
        this.radioAuthor = radioAuthor;
        this.update();
    }

    public String getRadioName() {
        return this.radioName;
    }

    public String getRadioAuthor() {
        return this.radioAuthor;
    }

    public String getRadioUrl() {
        return this.radioUrl;
    }

    public boolean isLoadingMusic() {
        return this.loadingMusic;
    }

    public long getMusicPosition() {
        return this.musicPosition;
    }

    public void setMusicPosition(long position) {
        ItemStack nc;
        MusicSource m;
        this.musicPosition = position;
        if (this.isMusicCassetteTapeExist() && !this.isRadioRemote() && (m = this.getMusicSource()) != null && !ItemStack.m_41728_((ItemStack)(nc = CassetteTapeItem.setTapePercentage(this.getCassetteTape().m_41777_(), (float)position / (float)m.getDuration())), (ItemStack)this.getCassetteTape())) {
            this.setCassetteTape(nc);
        }
        this.update();
    }

    public void setCassetteTape(ItemStack stack) {
        this.access.setCassetteTape(stack);
    }

    public MusicSource getMusicSource() {
        Music m;
        if (this.isMusicCassetteTapeExist() && (m = CassetteTapeItem.getMusic(this.getCassetteTape())) != null) {
            return m.getSource();
        }
        return null;
    }

    public void setMusicPositionAndRestart(long position) {
        this.setMusicPosition(position);
        if (this.getRinger() != null) {
            this.getRinger().ringerRestart();
            this.update();
        }
    }

    public float getRawVolume() {
        return (float)this.getVolume() / 300.0f;
    }

    public void setRadioMode() {
        if (this.isAntennaExist()) {
            if (IMPItemUtil.isRemotePlayBackAntenna(this.getAntenna())) {
                this.setMonitorType(MonitorType.REMOTE_PLAYBACK_SELECT);
            } else {
                this.setMonitorType(MonitorType.RADIO_SELECT);
            }
        }
        this.update();
    }

    public boolean isRadio() {
        return this.isRadioStream() || this.isRadioRemote();
    }

    public boolean isRadioStream() {
        return this.monitorType == MonitorType.RADIO_SELECT || this.monitorType == MonitorType.RADIO;
    }

    public boolean isRadioRemote() {
        return this.monitorType == MonitorType.REMOTE_PLAYBACK || this.monitorType == MonitorType.REMOTE_PLAYBACK_SELECT;
    }

    public void setPower(boolean power) {
        this.access.setPower(power);
    }

    public boolean isChangeCassetteTape() {
        return this.changeCassetteTape;
    }

    private boolean isMusicCassetteTapeExist() {
        return this.isCassetteTapeExist() && CassetteTapeItem.getMusic(this.getCassetteTape()) != null;
    }

    private boolean isCassetteTapeExist() {
        return IMPItemUtil.isCassetteTape(this.getCassetteTape());
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        if (this.canPlay() || !playing) {
            this.playing = playing;
            this.update();
        }
    }

    public ItemStack getOldCassetteTape() {
        return this.oldCassetteTape;
    }

    public void setMonitorType(MonitorType monitorType) {
        this.monitorType = monitorType;
        this.update();
    }

    public MonitorType getMonitorType() {
        return this.monitorType;
    }

    public boolean isUseAntenna() {
        return this.isRadio();
    }

    public boolean isAntennaExist() {
        return IMPItemUtil.isAntenna(this.getAntenna());
    }

    @Nullable
    public IMusicRinger getRinger() {
        return this.access.getRinger();
    }

    public boolean cycleLidOpen(Level level) {
        boolean flg2;
        boolean flg = this.lidOpenProgress >= this.getLidOpenProgressMax();
        boolean bl = flg2 = this.lidOpenProgress <= 0;
        if (!flg && !flg2) {
            return false;
        }
        if (flg) {
            this.startLidOpen(false, level);
        }
        if (flg2) {
            this.startLidOpen(true, level);
        }
        return true;
    }

    public void setContinuousType(ContinuousType continuousType) {
        this.continuousType = continuousType;
        this.update();
    }

    public ContinuousType getContinuousType() {
        return this.continuousType;
    }

    public void setSelectedMusic(Music selectedMusic) {
        this.selectedMusic = selectedMusic;
        this.update();
    }

    public Music getSelectedMusic() {
        return this.selectedMusic;
    }

    @Nullable
    public Music getCassetteTapeMusic() {
        if (IMPItemUtil.isCassetteTape(this.getCassetteTape())) {
            return CassetteTapeItem.getMusic(this.getCassetteTape());
        }
        return null;
    }

    public void startLidOpen(boolean open, Level level) {
        this.setLidOpen(open);
        BlockPos pos = this.getPosition();
        level.m_5594_(null, pos, this.isLidOpen() ? SoundEvents.f_12627_ : SoundEvents.f_12626_, SoundSource.BLOCKS, 0.5f, 0.4f / (level.m_5822_().nextFloat() * 0.4f + 0.8f));
    }

    public boolean isLidOpen() {
        return this.lidOpen;
    }

    public void setLidOpen(boolean lidOpen) {
        this.lidOpen = lidOpen;
        this.update();
    }

    public void setSelectedPlayList(@NotNull ServerPlayer player, UUID selectedPlayList) {
        if (selectedPlayList != null) {
            this.playerSelectPlaylists.put(player.m_36316_().getId(), selectedPlayList);
        } else {
            this.playerSelectPlaylists.remove(player.m_36316_().getId());
        }
        this.update();
    }

    @Nullable
    public UUID getSelectedPlayList(@NotNull Player player) {
        return this.playerSelectPlaylists.get(player.m_36316_().getId());
    }

    public ItemStack getCassetteTape() {
        return this.access.getCassetteTape();
    }

    public ItemStack getAntenna() {
        return this.access.getAntenna();
    }

    public int getLidOpenProgressMax() {
        return 10;
    }

    public int getHandleRaisedProgress() {
        return this.handleRaisedProgress;
    }

    public float getHandleRaisedProgress(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.handleRaisedProgressOld, (float)this.handleRaisedProgress);
    }

    public int getParabolicAntennaProgress() {
        return this.parabolicAntennaProgress;
    }

    public float getParabolicAntennaProgress(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.parabolicAntennaProgressOld, (float)this.parabolicAntennaProgress);
    }

    public int getLidOpenProgress() {
        return this.lidOpenProgress;
    }

    public float getLidOpenProgress(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.lidOpenProgressOld, (float)this.lidOpenProgress);
    }

    public boolean isLoop() {
        return this.loop;
    }

    public boolean isMute() {
        return this.mute;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
        this.update();
    }

    public void setMute(boolean mute) {
        this.mute = mute;
        this.update();
    }

    public void setVolume(int volume) {
        this.volume = volume;
        this.update();
    }

    public int getVolume() {
        return this.volume;
    }

    public int getAntennaProgress() {
        return this.antennaProgress;
    }

    public float getAntennaProgress(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.antennaProgressOld, (float)this.antennaProgress);
    }

    public boolean isHandleRaising() {
        return this.handleRaising;
    }

    public int getHandleRaisedMax() {
        return 10;
    }

    public boolean cycleRaisedHandle() {
        boolean flg2;
        boolean flg = this.getHandleRaisedProgress() >= this.getHandleRaisedMax();
        boolean bl = flg2 = this.getHandleRaisedProgress() <= 0;
        if (!flg && !flg2) {
            return false;
        }
        if (flg) {
            this.setHandleRaising(false);
        }
        if (flg2) {
            this.setHandleRaising(true);
        }
        return true;
    }

    public void setHandleRaising(boolean handleRaising) {
        this.handleRaising = handleRaising;
        this.update();
    }

    public void setHandleRaisedProgressOld(int handleRaisedProgressOld) {
        this.handleRaisedProgressOld = handleRaisedProgressOld;
    }

    public int getHandleRaisedProgressOld() {
        return this.handleRaisedProgressOld;
    }

    public void setHandleRaisedProgress(int handleRaisedProgress) {
        this.handleRaisedProgress = handleRaisedProgress;
    }

    public void setAntennaProgressOld(int antennaProgressOld) {
        this.antennaProgressOld = antennaProgressOld;
    }

    public boolean isPowered() {
        return this.access.isPowered();
    }

    public BlockPos getPosition() {
        return new BlockPos(this.access.getPosition());
    }

    public void update() {
        this.access.dataUpdate(this);
    }

    public void setRadioStartFlg(boolean radioStartFlg) {
        this.radioStartFlg = radioStartFlg;
        this.update();
    }

    public Buttons getButtons() {
        return new Buttons(this.isRadio(), this.isPlaying(), !this.isPlaying() && this.getMusicPosition() > 0L, this.isLoop(), this.isMute(), !this.isMute() && this.volume >= 300);
    }

    public static enum MonitorType {
        OFF("off"),
        PLAYBACK("playback"),
        REMOTE_PLAYBACK("remote_playback"),
        REMOTE_PLAYBACK_SELECT("remote_playback_select"),
        RADIO("radio"),
        RADIO_SELECT("radio_select");

        private final String name;

        private MonitorType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static MonitorType getByName(String name) {
            for (MonitorType value : MonitorType.values()) {
                if (!value.getName().equals(name)) continue;
                return value;
            }
            return OFF;
        }
    }

    public static enum ContinuousType {
        NONE("none"),
        ORDER("order"),
        RANDOM("random");

        private final String name;
        private final Component component;

        private ContinuousType(String name) {
            this.name = name;
            this.component = new TranslatableComponent("imp.text.continuous." + name);
        }

        public Component getComponent() {
            return this.component;
        }

        public String getName() {
            return this.name;
        }

        public static ContinuousType getByName(String name) {
            for (ContinuousType value : ContinuousType.values()) {
                if (!value.getName().equals(name)) continue;
                return value;
            }
            return NONE;
        }
    }

    public static interface DataAccess {
        public ItemStack getCassetteTape();

        public ItemStack getAntenna();

        public boolean isPowered();

        public void setPower(boolean var1);

        public IMusicRinger getRinger();

        public Vec3 getPosition();

        public void setCassetteTape(ItemStack var1);

        public void dataUpdate(BoomboxData var1);
    }

    public static enum ButtonType {
        NONE("none", n -> false),
        POWER("power", n -> false),
        RADIO("radio", n -> n.radio()),
        START("start", n -> n.start()),
        PAUSE("pause", n -> n.pause()),
        STOP("stop", n -> false),
        LOOP("loop", n -> n.loop()),
        VOL_DOWN("volDown", n -> false),
        VOL_UP("volUp", n -> false),
        VOL_MUTE("volMute", n -> n.volMute()),
        VOL_MAX("volMax", n -> n.volMax());

        private final String name;
        private final Component component;
        private final Function<Buttons, Boolean> getter;

        private ButtonType(String name, Function<Buttons, Boolean> getter) {
            this.name = name;
            this.component = new TranslatableComponent("imp.button.boombox." + name);
            this.getter = getter;
        }

        public String getName() {
            return this.name;
        }

        public Component getComponent() {
            return this.component;
        }

        public boolean getState(Buttons buttons) {
            return this.getter.apply(buttons);
        }

        public static ButtonType getByName(String name) {
            for (ButtonType value : ButtonType.values()) {
                if (!value.getName().equals(name)) continue;
                return value;
            }
            return NONE;
        }
    }

    public record Buttons(boolean radio, boolean start, boolean pause, boolean loop, boolean volMute, boolean volMax) {
        public static final Buttons EMPTY = new Buttons(false, false, false, false, false, false);
    }
}

