/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.planner;

import dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.planner.AbstractRoutePlanner;
import dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.tools.Tuple;
import dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.tools.ip.IpBlock;
import dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.tools.ip.Ipv6Block;
import dev.felnull.imp.include.org.apache.http.HttpException;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;

public final class RotatingNanoIpRoutePlanner
extends AbstractRoutePlanner {
    private static final Logger log = LoggerFactory.getLogger(RotatingNanoIpRoutePlanner.class);
    private final Predicate<InetAddress> ipFilter;
    private final AtomicReference<BigInteger> currentBlock;
    private final AtomicReference<BigInteger> blockNanoStart;
    private final AtomicBoolean next;

    public RotatingNanoIpRoutePlanner(List<IpBlock> ipBlocks) {
        this(ipBlocks, ip -> true);
    }

    public RotatingNanoIpRoutePlanner(List<IpBlock> ipBlocks, Predicate<InetAddress> ipFilter) {
        this(ipBlocks, ipFilter, true);
    }

    public RotatingNanoIpRoutePlanner(List<IpBlock> ipBlocks, Predicate<InetAddress> ipFilter, boolean handleSearchFailure) {
        super(ipBlocks, handleSearchFailure);
        this.ipFilter = ipFilter;
        this.currentBlock = new AtomicReference<BigInteger>(BigInteger.ZERO);
        this.blockNanoStart = new AtomicReference<BigInteger>(BigInteger.valueOf(System.nanoTime()));
        this.next = new AtomicBoolean(false);
        if (this.ipBlock.getType() != Inet6Address.class || this.ipBlock.getSize().compareTo(Ipv6Block.BLOCK64_IPS) < 0) {
            throw new IllegalArgumentException("Please use a bigger IPv6 Block!");
        }
    }

    public BigInteger getCurrentBlock() {
        return this.currentBlock.get();
    }

    public long getAddressIndexInBlock() {
        return System.nanoTime() - this.blockNanoStart.get().longValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Tuple<InetAddress, InetAddress> determineAddressPair(Tuple<Inet4Address, Inet6Address> remoteAddresses) throws HttpException {
        InetAddress remoteAddress;
        InetAddress currentAddress = null;
        if (this.ipBlock.getType() != Inet6Address.class) throw new HttpException("Unknown IpBlock type: " + this.ipBlock.getType().getCanonicalName());
        if (remoteAddresses.r != null) {
            currentAddress = this.extractLocalAddress();
            log.debug("Selected " + currentAddress.toString() + " as new outgoing ip");
            remoteAddress = (InetAddress)remoteAddresses.r;
        } else {
            if (remoteAddresses.l == null) throw new HttpException("Could not resolve host");
            remoteAddress = (InetAddress)remoteAddresses.l;
            log.warn("Could not look up AAAA record for host. Falling back to unbalanced IPv4.");
        }
        this.next.set(false);
        return new Tuple<InetAddress, InetAddress>(currentAddress, remoteAddress);
    }

    @Override
    protected void onAddressFailure(InetAddress address) {
        this.currentBlock.accumulateAndGet(BigInteger.ONE, BigInteger::add);
        this.blockNanoStart.set(BigInteger.valueOf(System.nanoTime()));
    }

    private InetAddress extractLocalAddress() {
        InetAddress localAddress;
        long triesSinceBlockSkip = 0L;
        BigInteger it = BigInteger.valueOf(0L);
        do {
            try {
                if (this.ipBlock.getSize().multiply(BigInteger.valueOf(2L)).compareTo(it) < 0) {
                    throw new RuntimeException("Can't find a free ip");
                }
                it = it.add(BigInteger.ONE);
                if (++triesSinceBlockSkip > 128L) {
                    this.currentBlock.accumulateAndGet(BigInteger.ONE, BigInteger::add);
                }
                BigInteger nanoTime = BigInteger.valueOf(System.nanoTime());
                BigInteger timeOffset = nanoTime.subtract(this.blockNanoStart.get());
                BigInteger blockOffset = this.currentBlock.get().multiply(Ipv6Block.BLOCK64_IPS);
                localAddress = (InetAddress)this.ipBlock.getAddressAtIndex(blockOffset.add(timeOffset));
            }
            catch (IllegalArgumentException ex) {
                this.currentBlock.set(BigInteger.ZERO);
                localAddress = null;
            }
        } while (localAddress == null || !this.ipFilter.test(localAddress) || !this.isValidAddress(localAddress));
        return localAddress;
    }
}

