/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.tools.ip;

import dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.tools.BigRandom;
import dev.felnull.imp.include.com.sedmelluq.lava.extensions.youtuberotator.tools.ip.IpBlock;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Ipv6Block
extends IpBlock<Inet6Address> {
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger BITS1 = BigInteger.valueOf(-1L);
    public static final BigInteger BLOCK64_IPS = TWO.pow(64);
    public static final int IPV6_BIT_SIZE = 128;
    private static final BigRandom random = new BigRandom();
    private static final Pattern CIDR_REGEX = Pattern.compile("([\\da-f:]+)/(\\d{1,3})");
    private final String cidr;
    private final int maskBits;
    private final BigInteger prefix;
    private static final Logger log = LoggerFactory.getLogger(Ipv6Block.class);

    public static boolean isIpv6CidrBlock(String cidr) {
        if (!cidr.contains("/")) {
            cidr = cidr + "/128";
        }
        return CIDR_REGEX.matcher(cidr).matches();
    }

    public Ipv6Block(String cidr) {
        BigInteger unboundedPrefix;
        if (!cidr.contains("/")) {
            cidr = cidr + "/128";
        }
        this.cidr = cidr.toLowerCase();
        Matcher matcher = CIDR_REGEX.matcher(this.cidr);
        if (!matcher.find()) {
            throw new IllegalArgumentException(cidr + " does not appear to be a valid CIDR.");
        }
        try {
            InetAddress address = InetAddress.getByName(matcher.group(1));
            unboundedPrefix = Ipv6Block.addressToLong((Inet6Address)address);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IPv6 address", e);
        }
        this.maskBits = Integer.parseInt(matcher.group(2));
        BigInteger prefixMask = BITS1.shiftLeft(128 - this.maskBits - 1);
        this.prefix = unboundedPrefix.and(prefixMask);
        log.info("Using Ipv6Block with {} addresses", (Object)this.getSize());
    }

    @Override
    public Inet6Address getRandomAddress() {
        if (this.maskBits == 128) {
            return Ipv6Block.longToAddress(this.prefix);
        }
        BigInteger randomAddressOffset = random.nextBigInt(128 - (this.maskBits + 1)).abs();
        Inet6Address inetAddress = Ipv6Block.longToAddress(this.prefix.add(randomAddressOffset));
        log.debug(inetAddress.toString());
        return inetAddress;
    }

    @Override
    public Inet6Address getAddressAtIndex(long index) {
        return this.getAddressAtIndex(BigInteger.valueOf(index));
    }

    @Override
    public Inet6Address getAddressAtIndex(BigInteger index) {
        if (index.compareTo(this.getSize()) > 0) {
            throw new IllegalArgumentException("Index out of bounds for provided CIDR Block");
        }
        return Ipv6Block.longToAddress(this.prefix.add(index));
    }

    @Override
    public Class<Inet6Address> getType() {
        return Inet6Address.class;
    }

    @Override
    public BigInteger getSize() {
        return TWO.pow(128 - this.maskBits);
    }

    public String toString() {
        return this.cidr;
    }

    @Override
    public int getMaskBits() {
        return this.maskBits;
    }

    private static Inet6Address longToAddress(BigInteger l) {
        byte[] b = new byte[16];
        int start = (b.length - 1) * 8;
        for (int i = 0; i < b.length; ++i) {
            int shift = start - i * 8;
            b[i] = shift > 0 ? l.shiftRight(start - i * 8).byteValue() : l.byteValue();
        }
        try {
            return (Inet6Address)Inet6Address.getByAddress(b);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private static BigInteger addressToLong(Inet6Address address) {
        return Ipv6Block.bytesToLong(address.getAddress());
    }

    private static BigInteger bytesToLong(byte[] b) {
        BigInteger value = BigInteger.valueOf(0L);
        int start = (b.length - 1) * 8;
        value = value.or(BigInteger.valueOf(b[0]).shiftLeft(start));
        for (int i = 1; i < b.length; ++i) {
            int shift = start - i * 8;
            value = shift > 0 ? value.or(BigInteger.valueOf(b[i] & 0xFF).shiftLeft(shift)) : value.or(BigInteger.valueOf(b[i] & 0xFF));
        }
        return value;
    }
}

