/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.music.tracker;

import dev.architectury.utils.value.FloatSupplier;
import dev.felnull.imp.music.MusicSpeakerFixedInfo;
import dev.felnull.imp.music.MusicSpeakerInfo;
import dev.felnull.imp.music.SpatialType;
import dev.felnull.imp.music.tracker.FixedMusicTracker;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityMusicTracker
extends FixedMusicTracker {
    private final Level level;
    private final FloatSupplier deltaSupplier;
    private int entityID = -1;

    public EntityMusicTracker(Level level, FloatSupplier deltaSupplier) {
        this.level = level;
        this.deltaSupplier = deltaSupplier;
    }

    public EntityMusicTracker(Entity entity, float volume, float range) {
        super(new MusicSpeakerInfo(entity.m_20182_(), volume, range, new MusicSpeakerFixedInfo(-1, SpatialType.ENTRUST)));
        this.level = null;
        this.deltaSupplier = null;
        this.entityID = entity.m_142049_();
    }

    @Override
    public MusicSpeakerInfo getSpeakerInfo() {
        Entity en;
        MusicSpeakerInfo sp = super.getSpeakerInfo();
        if (this.level != null && this.deltaSupplier != null && this.entityID >= 0 && (en = this.level.m_6815_(this.entityID)) != null) {
            return new MusicSpeakerInfo(EntityMusicTracker.getEntityPosition(en, this.deltaSupplier.getAsFloat()), sp.volume(), sp.range(), new MusicSpeakerFixedInfo(-1, SpatialType.ENTRUST));
        }
        return sp;
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        super.save(tag);
        tag.m_128405_("EntityID", this.entityID);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.entityID = tag.m_128451_("EntityID");
    }

    public static Vec3 getEntityPosition(Entity entity, float delta) {
        return entity.m_20299_(delta);
    }
}

