/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.music.tracker;

import dev.architectury.utils.value.FloatSupplier;
import dev.felnull.imp.music.MusicSpeakerFixedInfo;
import dev.felnull.imp.music.MusicSpeakerInfo;
import dev.felnull.imp.music.SpatialType;
import dev.felnull.imp.music.tracker.EntityMusicTracker;
import dev.felnull.imp.music.tracker.FixedMusicTracker;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;

public class PlayerMusicTracker
extends FixedMusicTracker {
    private final Player myPlayer;
    private final EntityGetter entityGetter;
    private final FloatSupplier deltaSupplier;
    private UUID playerId;

    public PlayerMusicTracker(Player myPlayer, EntityGetter entityGetter, FloatSupplier deltaSupplier) {
        this.myPlayer = myPlayer;
        this.entityGetter = entityGetter;
        this.deltaSupplier = deltaSupplier;
    }

    public PlayerMusicTracker(Player player, float volume, float range) {
        super(new MusicSpeakerInfo(player.m_20182_(), volume, range, new MusicSpeakerFixedInfo(-1, SpatialType.ENTRUST)));
        this.playerId = player.m_36316_().getId();
        this.myPlayer = null;
        this.entityGetter = null;
        this.deltaSupplier = null;
    }

    @Override
    public MusicSpeakerInfo getSpeakerInfo() {
        Player pl;
        MusicSpeakerInfo sp = super.getSpeakerInfo();
        if (this.myPlayer != null && this.entityGetter != null && this.playerId != null && this.deltaSupplier != null && (pl = this.entityGetter.m_46003_(this.playerId)) != null) {
            SpatialType spt = this.myPlayer.m_36316_().getId().equals(this.playerId) ? SpatialType.DISABLE : sp.fixedInfo().spatialType();
            return new MusicSpeakerInfo(EntityMusicTracker.getEntityPosition((Entity)pl, this.deltaSupplier.getAsFloat()), sp.volume(), sp.range(), new MusicSpeakerFixedInfo(-1, spt));
        }
        return sp;
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        super.save(tag);
        tag.m_128362_("PlayerId", this.playerId);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.playerId = tag.m_128342_("PlayerId");
    }
}

