package dev.felnull.imp.client.gui.components;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.utils.value.Value;
import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class ContinuousWidget extends AbstractWidget implements IIMPSmartRender {
    private final Value<BoomboxData.ContinuousType> continuousTypeValue;

    public ContinuousWidget(int x, int y, Value<BoomboxData.ContinuousType> continuousTypeValue) {
        super(x, y, 40, 10, Component.m_237115_("imp.widget.continuousControl"));
        this.continuousTypeValue = continuousTypeValue;
    }

    @Override
    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        this.m_168802_(narrationElementOutput);
    }

    @Override
    public void m_5716_(double d, double e) {
        super.m_5716_(d, e);
        continuousTypeValue.accept(BoomboxData.ContinuousType.values()[(continuousTypeValue.get().ordinal() + 1) % BoomboxData.ContinuousType.values().length]);
    }

    @Override
    public void m_6303_(PoseStack poseStack, int i, int j, float f) {
        drawSmartCenterText(poseStack, continuousTypeValue.get().getComponent(), f_93620_ + f_93618_ / 2f, f_93621_ + 2, m_198029_() ? 0XFF007F06 : 0XFF115D0E);
    }
}
