package dev.felnull.imp.client.gui.components;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ImageSetButton extends Button implements IIMPSmartRender {
    private final ImageSetType type;

    public ImageSetButton(int x, int y, ImageSetType type, OnPress onPress, Screen screen) {
        super(x, y, 33, 15, type.getName(), onPress, (button, poseStack, i, j) -> screen.m_96602_(poseStack, type.getName(), i, j));
        this.type = type;
    }

    public static enum ImageSetType {
        FILE_OPEN("file_open"),
        PLAYER_FACE("player_face"),
        DELETE("delete");
        //        URL("url");
        private final Component name;

        private ImageSetType(String name) {
            this.name = Component.m_237115_("imp.button.imageSet." + name);
        }

        public Component getName() {
            return name;
        }
    }

    @Override
    public void m_6303_(PoseStack poseStack, int mx, int my, float f) {
        drawSmartButtonBox(poseStack, f_93620_, f_93621_, f_93618_, f_93619_, m_198029_());
        if (type == ImageSetType.PLAYER_FACE) {
            OERenderUtils.drawPlayerFace(poseStack, mc.f_91074_.m_36316_().getId(), (float) f_93620_ + ((float) f_93618_ - 11f) / 2f, (float) f_93621_ + ((float) f_93619_ - 11f) / 2f, 11);
        } else {
            OERenderUtils.drawTexture(MusicManagerMonitor.WIDGETS_TEXTURE, poseStack, (float) f_93620_ + ((float) f_93618_ - 11f) / 2f, (float) f_93621_ + ((float) f_93619_ - 11f) / 2f, 73 + (type == ImageSetType.DELETE ? 11 : 0), 19, 11, 11);
        }
        if (this.m_198029_())
            this.m_7428_(poseStack, mx, my);
    }
}
